# bat

> 可以打印并且合并文件的命令。
> `cat` 的复制品，外加语法高亮和 Git 集成。
> 更多信息：<https://github.com/sharkdp/bat>.

- 使用美化样式打印一个或多个文件的内容到 `stdout`：

`bat {{路径/到/文件1 路径/到/文件2 ...}}`

- 将多个文件连接成一个目标文件：

`bat {{路径/到/文件1 路径/到/文件2 ...}} > {{路径/到/目标文件}}`

- 移除修饰并禁用分页（`--style plain` 可以用 `-p` 代替，或用 `-pp` 组合两个选项）：

`bat --style plain --pager never {{路径/到/文件}}`

- 使用不同的背景颜色高亮显示特定行或一行范围：

`bat {{[-H|--highlight-line]}} {{10|5:10|:10|10:|10:+5}} {{路径/到/文件}}`

- 显示不可打印字符，如空格、制表符或换行：

`bat {{[-A|--show-all]}} {{路径/到/文件}}`

- 在输出中只保留行号，移除所有其他修饰：

`bat {{[-n|--number]}} {{路径/到/文件}}`

- 通过明确设置语言来语法高亮显示 JSON 文件：

`bat {{[-l|--language]}} json {{路径/到/文件.json}}`

- 显示所有支持的语言：

`bat {{[-L|--list-languages]}}`
