# jq

> Процессор JSON, использующий предметно-ориентированный язык (DSL).
> Больше информации: <https://jqlang.github.io/jq/manual/>.

- Выполнить указанное выражение с выводом в цветном и отформатированном виде:

`jq '.' {{путь/к/файлу.json}}`

- Выполнить указанный скрипт:

`{{cat путь/к/файлу.json}} | jq {{[-f|--from-file]}} {{путь/к/скрипту.jq}}`

- Передать указанные аргументы:

`{{cat путь/к/файлу.json}} | jq {{--arg "имя1" "значение1" --arg "имя2" "значение2" ...}} '{{. + $ARGS.named}}'`

- Создать новый объект JSON на основе объектов из нескольких файлов:

`{{cat путь/к/нескольким_json_файлам_*.json}} | jq '{{{новый_ключ1: .ключ1, новый_ключ2: .ключ2.вложенный_ключ, ...}}}'`

- Вывести указанные элементы массива:

`{{cat путь/к/файлу.json}} | jq '{{.[индекс1], .[индекс2], ...}}'`

- Вывести все элементы массива/значения объекта:

`{{cat путь/к/файлу.json}} | jq '.[]'`

- Вывести объекты из массива, отфильтровав их по двум условиям:

`{{cat путь/к/файлу.json}} | jq '.[] | select((.ключ1=="значение1") and .ключ2=="значение2")'`

- Добавить/удалить указанные ключи:

`{{cat путь/к/файлу.json}} | jq '. {{+|-}} {{{"ключ1": "значение1", "ключ2": "значение2", ...}}}'`
