# sed

> 以可用脚本的来批量编辑文本。
> 更多信息：<https://keith.github.io/xcode-man-pages/sed.1.html>.

- 替换文件中第一个出现的字符串，并打印结果：

`sed 's/{{查找内容}}/{{替换内容}}/' {{文件名}}`

- 替换文件中所有符合正则表达式的部分：

`sed -E 's/{{正则表达式}}/{{替换内容}}/g' {{文件名}}`

- 替换文件中所有出现的字符串，覆盖文件（直接覆盖文件）：

`sed --in-place='' 's/{{查找内容}}/{{替换内容}}/g' {{文件名}}`

- 仅替换与行模式（一种搜索条件）匹配的行内容：

`sed '/{{行模式}}/s/{{查找内容}}/{{替换内容}}/' {{文件名}}`

- 只打印第 n 行到下一行之间的文本：

`sed -n '{{行号}},/^$/p' {{文件名}}`

- 将多个查找替换表达式应用于文件：

`sed -e 's/{{查找内容}}/{{替换内容}}/' -e 's/{{查找内容}}/{{替换内容}}/' {{文件名}}`

- 将分隔符 / 替换为查找或替换模式中没有用到的的任何其他字符，例如 #（用于查找或替换内容中使用了 / 的情况）：

`sed 's#{{查找内容}}#{{替换内容}}#' {{文件名}}`
