# qpdf

> 다재다능한 PDF 변환 소프트웨어.
> 더 많은 정보: <https://github.com/qpdf/qpdf>.

- PDF 파일에서 페이지 1-3, 5 및 6-10을 추출하여 다른 파일로 저장:

`qpdf --empty --pages {{경로/대상/입력.pdf}} {{1-3,5,6-10}} -- {{경로/대상/출력.pdf}}`

- 여러 PDF 파일의 모든 페이지를 병합하여 새 PDF 파일로 저장:

`qpdf --empty --pages {{경로/대상/파일1.pdf 파일2.pdf ...}} -- {{경로/대상/출력.pdf}}`

- 주어진 페이지를 여러 PDF 파일에서 병합하여 새 PDF 파일로 저장:

`qpdf --empty --pages {{경로/대상/파일1.pdf}} {{1,6-8}} {{경로/대상/파일2.pdf}} {{3,4,5}} -- {{경로/대상/출력.pdf}}`

- 각 `n` 페이지 그룹을 주어진 파일명 패턴으로 별도의 출력 파일로 작성:

`qpdf --split-pages={{n}} {{경로/대상/입력.pdf}} {{경로/대상/출력_%d.pdf}}`

- 특정 PDF 페이지를 주어진 각도로 회전:

`qpdf --rotate={{90:2,4,6}} --rotate={{180:7-8}} {{경로/대상/입력.pdf}} {{경로/대상/출력.pdf}}`

- 암호로 보호된 파일의 암호 제거:

`qpdf --password={{암호}} --decrypt {{경로/대상/입력.pdf}} {{경로/대상/출력.pdf}}`
