/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.apache.subversion.javahl.CommitItem;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.ISVNRepos;
import org.apache.subversion.javahl.ProgressEvent;
import org.apache.subversion.javahl.SVNClient;
import org.apache.subversion.javahl.SVNRepos;
import org.apache.subversion.javahl.SVNUtil;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.WC;
import org.apache.subversion.javahl.callback.AuthnCallback;
import org.apache.subversion.javahl.callback.ClientNotifyCallback;
import org.apache.subversion.javahl.callback.CommitMessageCallback;
import org.apache.subversion.javahl.callback.ProgressCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Status;

class SVNTests
extends TestCase {
    protected ISVNRepos admin;
    protected ISVNClient client;
    protected File rootDir;
    private String fsType;
    protected String testBaseName;
    protected static int testCounter;
    protected boolean cleanupAfterTests = false;
    protected static List<File> testDirs;
    protected File greekDump;
    protected File greekRepos;
    protected WC greekWC;
    protected File localTmp;
    protected File repositories;
    protected File workingCopies;
    protected File conf;
    protected String logMessage = "Log Message";
    protected Map<String, MyCommitItem> expectedCommitItems;
    protected static String rootDirectoryName;
    protected static String rootUrl;
    protected static final String USERNAME = "jrandom";
    protected static final String PASSWORD = "rayjandom";

    protected SVNTests() {
        this.init();
    }

    protected SVNTests(String string) {
        super(string);
        this.init();
    }

    private void init() {
        String string;
        String string2 = System.getProperty("test.cleanup");
        if (string2 != null) {
            boolean bl = this.cleanupAfterTests = 0 < string2.trim().length();
        }
        if ((string = System.getProperty("test.disablecredstore")) != null) {
            try {
                SVNUtil.disableNativeCredentialsStore();
            }
            catch (Throwable throwable) {
                System.err.println("*** ERROR: Could not disable the native credentials store");
            }
        }
        if (rootDirectoryName == null) {
            rootDirectoryName = System.getProperty("test.rootdir");
        }
        if (rootDirectoryName == null) {
            rootDirectoryName = System.getProperty("user.dir");
        }
        this.rootDir = new File(rootDirectoryName);
        if (rootUrl == null) {
            rootUrl = System.getProperty("test.rooturl");
        }
        if (rootUrl == null || rootUrl.trim().length() == 0) {
            rootUrl = this.rootDir.toURI().toString();
            if (!rootUrl.startsWith("file:///")) {
                if (rootUrl.startsWith("file://")) {
                    rootUrl = rootUrl.replaceFirst("file://", "file:///");
                } else if (rootUrl.startsWith("file:/")) {
                    rootUrl = rootUrl.replaceFirst("file:/", "file:///");
                }
            }
            if (!rootUrl.endsWith("/")) {
                rootUrl = rootUrl + '/';
            }
        }
        if (this.fsType == null) {
            this.fsType = System.getProperty("test.fstype", "fsfs").toLowerCase();
            if (!"fsfs".equals(this.fsType) && !"bdb".equals(this.fsType)) {
                this.fsType = "fsfs";
            }
        }
        this.localTmp = new File(this.rootDir, "local_tmp");
        this.conf = new File(this.localTmp, "config");
        this.repositories = new File(this.rootDir, "repositories");
        this.workingCopies = new File(this.rootDir, "working_copies");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createDirectories();
        this.admin = new SVNRepos();
        this.initClient();
        File file = this.buildGreekFiles();
        this.greekRepos = new File(this.localTmp, "repos");
        this.greekDump = new File(this.localTmp, "greek_dump");
        this.admin.create(this.greekRepos, true, false, null, this.fsType);
        this.addExpectedCommitItem(file.getAbsolutePath(), this.makeReposUrl(this.greekRepos).toString(), null, NodeKind.dir, 1);
        this.client.doImport(file.getAbsolutePath(), this.makeReposUrl(this.greekRepos).toString(), Depth.infinity, false, false, null, new MyCommitMessage(), null);
        this.admin.dump(this.greekRepos, new FileOutputStream(this.greekDump), null, null, false, false, null);
    }

    private void createDirectories() {
        this.rootDir.mkdirs();
        if (this.localTmp.exists()) {
            SVNTests.removeDirOrFile(this.localTmp);
        }
        this.localTmp.mkdir();
        this.conf.mkdir();
        this.repositories.mkdir();
        this.workingCopies.mkdir();
    }

    private void initClient() throws SubversionException {
        this.client = new SVNClient();
        this.client.notification2(new MyNotifier());
        if (DefaultAuthn.useDeprecated()) {
            this.client.setPrompt(DefaultAuthn.getDeprecated());
        } else {
            this.client.setPrompt(DefaultAuthn.getDefault());
        }
        this.client.username(USERNAME);
        this.client.setProgressCallback(new DefaultProgressListener());
        this.client.setConfigDirectory(this.conf.getAbsolutePath());
        this.expectedCommitItems = new HashMap<String, MyCommitItem>();
    }

    private File buildGreekFiles() throws IOException {
        File file = new File(this.localTmp, "greek_files");
        file.mkdir();
        this.greekWC = new WC();
        this.greekWC.addItem("", null);
        this.greekWC.addItem("iota", "This is the file 'iota'.");
        this.greekWC.addItem("A", null);
        this.greekWC.addItem("A/mu", "This is the file 'mu'.");
        this.greekWC.addItem("A/B", null);
        this.greekWC.addItem("A/B/lambda", "This is the file 'lambda'.");
        this.greekWC.addItem("A/B/E", null);
        this.greekWC.addItem("A/B/E/alpha", "This is the file 'alpha'.");
        this.greekWC.addItem("A/B/E/beta", "This is the file 'beta'.");
        this.greekWC.addItem("A/B/F", null);
        this.greekWC.addItem("A/C", null);
        this.greekWC.addItem("A/D", null);
        this.greekWC.addItem("A/D/gamma", "This is the file 'gamma'.");
        this.greekWC.addItem("A/D/H", null);
        this.greekWC.addItem("A/D/H/chi", "This is the file 'chi'.");
        this.greekWC.addItem("A/D/H/psi", "This is the file 'psi'.");
        this.greekWC.addItem("A/D/H/omega", "This is the file 'omega'.");
        this.greekWC.addItem("A/D/G", null);
        this.greekWC.addItem("A/D/G/pi", "This is the file 'pi'.");
        this.greekWC.addItem("A/D/G/rho", "This is the file 'rho'.");
        this.greekWC.addItem("A/D/G/tau", "This is the file 'tau'.");
        this.greekWC.materialize(file);
        return file;
    }

    static final void removeDirOrFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                SVNTests.removeDirOrFile(file2);
            }
        }
        file.delete();
    }

    protected void tearDown() throws Exception {
        this.admin.dispose();
        this.client.dispose();
        SVNTests.removeDirOrFile(this.localTmp);
        List<File> list = testDirs;
        testDirs = null;
        if (this.cleanupAfterTests && list != null) {
            for (File file : list) {
                SVNTests.removeDirOrFile(file);
            }
        }
        super.tearDown();
    }

    protected URI makeReposUrl(File file) throws SubversionException {
        try {
            String string = file.getAbsolutePath().substring(this.rootDir.getAbsolutePath().length() + 1);
            return new URI(rootUrl + string.replace(File.separatorChar, '/'));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SubversionException(uRISyntaxException.getMessage());
        }
    }

    protected void addExpectedCommitItem(String string, String string2, String string3, NodeKind nodeKind, int n) {
        String string4 = null;
        if (string != null) {
            string4 = string3 != null ? string.replace(File.separatorChar, '/') + '/' + string3 : string.replace(File.separatorChar, '/');
        }
        String string5 = null;
        if (string2 != null) {
            string5 = string3 != null ? string2 + '/' + string3 : string2;
        }
        String string6 = string5 != null ? string5 : string4;
        this.expectedCommitItems.put(string6, new MyCommitItem(string4, nodeKind, n, string5));
    }

    protected String getAdminDirectoryName() {
        String string = null;
        if (this.client != null) {
            string = this.client.getAdminDirectoryName();
        }
        if (string == null) {
            SVNTests.fail((String)"Unable to determine the WC admin directory name");
        }
        return string;
    }

    private class MyStatusCallback
    implements StatusCallback {
        private List<Status> statuses = new ArrayList<Status>();

        private MyStatusCallback() {
        }

        @Override
        public void doStatus(String string, Status status) {
            if (status != null) {
                this.statuses.add(status);
            }
        }

        public Status[] getStatusArray() {
            return this.statuses.toArray(new Status[this.statuses.size()]);
        }
    }

    class MyNotifier
    implements ClientNotifyCallback {
        MyNotifier() {
        }

        @Override
        public void onNotify(ClientNotifyInformation clientNotifyInformation) {
        }
    }

    class MyCommitItem {
        String myPath;
        NodeKind myNodeKind;
        int myStateFlags;
        String myUrl;

        private MyCommitItem(String string, NodeKind nodeKind, int n, String string2) {
            this.myPath = string;
            this.myNodeKind = nodeKind;
            this.myStateFlags = n;
            this.myUrl = string2;
        }

        private void test(CommitItem commitItem, String string) {
            TestCase.assertEquals((String)"commit item path", (String)this.myPath, (String)commitItem.getPath());
            TestCase.assertEquals((String)"commit item node kind", (Object)((Object)this.myNodeKind), (Object)((Object)commitItem.getNodeKind()));
            TestCase.assertEquals((String)"commit item state flags", (int)this.myStateFlags, (int)commitItem.getStateFlags());
            TestCase.assertEquals((String)"commit item url", (String)this.myUrl, (String)commitItem.getUrl());
            SVNTests.this.expectedCommitItems.remove(string);
        }
    }

    class MyCommitMessage
    implements CommitMessageCallback {
        MyCommitMessage() {
        }

        @Override
        public String getLogMessage(Set<CommitItem> set) {
            for (CommitItem object : set) {
                String string = object.getUrl() != null ? object.getUrl() : object.getPath();
                MyCommitItem myCommitItem = SVNTests.this.expectedCommitItems.get(string);
                TestCase.assertNotNull((String)("commit item for " + string + " not expected"), (Object)myCommitItem);
                myCommitItem.test(object, string);
            }
            for (String string : SVNTests.this.expectedCommitItems.keySet()) {
                TestCase.fail((String)("commit item for " + string + " not found"));
            }
            return SVNTests.this.logMessage;
        }
    }

    protected class OneTest {
        protected File repository;
        protected File workingCopy;
        protected URI url;
        protected WC wc;
        String testName;

        protected OneTest(boolean bl, boolean bl2) throws SubversionException, IOException {
            this.testName = SVNTests.this.testBaseName + ++testCounter;
            this.wc = SVNTests.this.greekWC.copy();
            this.repository = this.createInitialRepository(bl2);
            this.url = SVNTests.this.makeReposUrl(this.repository);
            if (bl) {
                this.workingCopy = this.createInitialWorkingCopy(this.repository);
            }
        }

        protected OneTest(boolean bl) throws SubversionException, IOException {
            this(bl, true);
        }

        protected OneTest() throws SubversionException, IOException {
            this(true);
        }

        protected OneTest copy(String string) throws SubversionException, IOException {
            return new OneTest(this, string);
        }

        private OneTest(OneTest oneTest, String string) throws SubversionException, IOException {
            this.testName = SVNTests.this.testBaseName + testCounter + string;
            this.repository = oneTest.getRepository();
            this.url = oneTest.getUrl();
            this.wc = oneTest.wc.copy();
            this.workingCopy = this.createInitialWorkingCopy(this.repository);
        }

        public File getRepository() {
            return this.repository;
        }

        public File getWorkingCopy() {
            return this.workingCopy;
        }

        public String getWCPath() {
            return this.workingCopy.getAbsolutePath();
        }

        public Set<String> getWCPathSet() {
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(this.workingCopy.getAbsolutePath());
            return hashSet;
        }

        public Set<String> getWCPathSet(String string) {
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(this.workingCopy.getAbsolutePath() + string);
            return hashSet;
        }

        public URI getUrl() {
            return this.url;
        }

        public Set<String> getUrlSet(String string) {
            HashSet<String> hashSet = new HashSet<String>(1);
            hashSet.add(this.url + string);
            return hashSet;
        }

        public WC getWc() {
            return this.wc;
        }

        private void trackDir(File file) {
            if (testDirs == null) {
                testDirs = new ArrayList<File>();
            }
            testDirs.add(file);
        }

        protected File createInitialRepository(boolean bl) throws SubversionException, IOException {
            File file = new File(SVNTests.this.repositories, this.testName);
            SVNTests.removeDirOrFile(file);
            this.trackDir(file);
            SVNTests.this.admin.create(file, true, false, SVNTests.this.conf, SVNTests.this.fsType);
            if (bl) {
                SVNTests.this.admin.load(file, new FileInputStream(SVNTests.this.greekDump), false, false, false, false, null, null);
            }
            return file;
        }

        protected File createInitialWorkingCopy(File file) throws SubversionException, IOException {
            URI uRI = SVNTests.this.makeReposUrl(file);
            this.workingCopy = new File(SVNTests.this.workingCopies, this.testName);
            SVNTests.removeDirOrFile(this.workingCopy);
            this.trackDir(this.workingCopy);
            SVNTests.this.client.checkout(uRI.toString(), this.workingCopy.getAbsolutePath(), null, null, Depth.infinity, false, false);
            this.checkStatus();
            return this.workingCopy;
        }

        public void checkStatus() throws SubversionException, IOException {
            this.checkStatus(false);
        }

        public void checkStatus(boolean bl) throws SubversionException, IOException {
            MyStatusCallback myStatusCallback = new MyStatusCallback();
            SVNTests.this.client.status(this.workingCopy.getAbsolutePath(), Depth.unknown, bl, false, true, true, false, false, null, myStatusCallback);
            this.wc.check(myStatusCallback.getStatusArray(), this.workingCopy.getAbsolutePath(), bl);
        }

        public String toString() {
            return this.testName;
        }
    }

    protected static class DefaultProgressListener
    implements ProgressCallback {
        protected DefaultProgressListener() {
        }

        @Override
        public void onProgress(ProgressEvent progressEvent) {
        }
    }

    protected static class DefaultAuthn {
        protected DefaultAuthn() {
        }

        public static boolean useDeprecated() {
            String string = System.getProperty("test.authn.deprecated");
            return string != null && !string.isEmpty();
        }

        public static AuthnCallback getDefault() {
            return new DefaultAuthnCallback();
        }

        public static UserPasswordCallback getDeprecated() {
            return new DeprecatedAuthnCallback();
        }

        private static class DeprecatedAuthnCallback
        implements UserPasswordCallback {
            private DeprecatedAuthnCallback() {
            }

            @Override
            public int askTrustSSLServer(String string, boolean bl) {
                return 1;
            }

            @Override
            public String askQuestion(String string, String string2, boolean bl) {
                return "";
            }

            @Override
            public boolean askYesNo(String string, String string2, boolean bl) {
                return bl;
            }

            @Override
            public String getPassword() {
                return SVNTests.PASSWORD;
            }

            @Override
            public String getUsername() {
                return SVNTests.USERNAME;
            }

            @Override
            public boolean prompt(String string, String string2) {
                return true;
            }

            @Override
            public boolean prompt(String string, String string2, boolean bl) {
                return true;
            }

            @Override
            public String askQuestion(String string, String string2, boolean bl, boolean bl2) {
                return "";
            }

            @Override
            public boolean userAllowedSave() {
                return false;
            }
        }

        private static class DefaultAuthnCallback
        implements AuthnCallback {
            private DefaultAuthnCallback() {
            }

            @Override
            public AuthnCallback.UsernameResult usernamePrompt(String string, boolean bl) {
                return new AuthnCallback.UsernameResult(SVNTests.USERNAME);
            }

            @Override
            public AuthnCallback.UserPasswordResult userPasswordPrompt(String string, String string2, boolean bl) {
                return new AuthnCallback.UserPasswordResult(SVNTests.USERNAME, SVNTests.PASSWORD);
            }

            @Override
            public AuthnCallback.SSLServerTrustResult sslServerTrustPrompt(String string, AuthnCallback.SSLServerCertFailures sSLServerCertFailures, AuthnCallback.SSLServerCertInfo sSLServerCertInfo, boolean bl) {
                return AuthnCallback.SSLServerTrustResult.acceptTemporarily();
            }

            @Override
            public AuthnCallback.SSLClientCertResult sslClientCertPrompt(String string, boolean bl) {
                return null;
            }

            @Override
            public AuthnCallback.SSLClientCertPassphraseResult sslClientCertPassphrasePrompt(String string, boolean bl) {
                return null;
            }

            @Override
            public boolean allowStorePlaintextPassword(String string) {
                return false;
            }

            @Override
            public boolean allowStorePlaintextPassphrase(String string) {
                return false;
            }
        }
    }
}

