/*                                                              -*- C -*-
 * extra.h      -- Extra pre-processor definitions
 *
 * Copyright ? 2000-2020 Erick Gallesio - I3S-CNRS/ESSI <eg@unice.fr>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 *
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: 19-May-2000 18:44 (eg)
 * Last file update: 17-Jan-2023 12:08 (eg)
 */

#define PREFIXDIR               "/opt/local"
#define SCMDIR                  "/opt/local/share/stklos/1.70"
#define DEFAULT_BOOT_FILE       "/opt/local/share/stklos/1.70/boot.img"
#define EXECDIR                 "/opt/local/lib/stklos/1.70"
#define BUILD_OS                "Darwin-18.7.0"
#define BUILD_ARCH              "x86_64"
#define BUILD_MACHINE           "Darwin-18.7.0-x86_64"
#define DARWIN               1
#define DARWIN_OLD       1
#define STACK_GROWS_DOWN
#define PCRE_PKG_CONFIG         "present"

/* SRFI-176 stuff */
#define CONF_SUMMARY            "(:system (libffi libpcre libgmp libgc ) :compiled () :configure ( \"--prefix=/opt/local\" \"ac_cv_prog_ASCIIDOCTOR=true\" \"CC=/usr/bin/clang\" \"CFLAGS=-pipe -Os -isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX10.14.sdk -arch x86_64\"))"
#define C_VERSION               "Apple LLVM version 10.0.1 (clang-1001.0.46.4)"
#define C_COMPILE               "(\"/usr/bin/clang\" \"-pipe\" \"-Os\" \"-isysroot/Library/Developer/CommandLineTools/SDKs/MacOSX10.14.sdk\" \"-arch\" \"x86_64\" )"
#define C_LINK                  "(\"/usr/bin/clang\" \"-lgmp\" \"-L/opt/local/lib\" \"-lpcre\" \"-lpcreposix\" \"-L/opt/local/lib\" \"-lffi\" \"-L/opt/local/lib\" \"-lgc\" \"-lpthread\" \"-lm\" )"

#define SHARED_LIB_COMPILE      "(\"/usr/bin/clang\" \"-fPIC\" \"-fno-common\" \"-I/opt/local/include/stklos\" \"-I/opt/local/include/stklos/gc\" )"
#define SHARED_LIB_LINK         "(\"/usr/bin/clang\" \"-bundle\" \"-undefined\" \"dynamic_lookup\" )"
#define SHARED_LIB_SUFFIX       "dylib"
#define SHARED_SUFFIX           "so"
#define SHARED_EXTENSION        ".so"


/* Various stuff */
#define unix 1
#define Darwin    1           /* result of uname -o */
#define DEFAULT_CASE_SENSITIVE  1
#define CONTROL_FX_PARAMETERS   1
