/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.spanish;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.trees.AbstractCollinsHeadFinder;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.spanish.SpanishTreebankLanguagePack;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.Generics;

public class SpanishHeadFinder
extends AbstractCollinsHeadFinder {
    private static final long serialVersionUID = -841219428125220698L;
    private static final String[] allVerbs = new String[]{"vmip000", "vmii000", "vmif000", "vmis000", "vmic000", "vmsp000", "vmsi000", "vmm0000", "vmn0000", "vmg0000", "vmp0000", "vaip000", "vaii000", "vaif000", "vais000", "vaic000", "vasp000", "vasi000", "vam0000", "van0000", "vag0000", "vap0000", "vsip000", "vsii000", "vsis000", "vsif000", "vsic000", "vssp000", "vssi000", "vsm0000", "vsn0000", "vsg0000", "vsp0000"};

    public SpanishHeadFinder() {
        this(new SpanishTreebankLanguagePack());
    }

    public SpanishHeadFinder(TreebankLanguagePack tlp) {
        super(tlp, new String[0]);
        this.nonTerminalInfo = Generics.newHashMap();
        String[][] rootRules = new String[][]{{"right", "grup.verb", "s.a", "sn"}, {"left", "S"}, {"right", "sadv", "grup.adv", "neg", "interjeccio", "i", "sp", "grup.prep"}, this.insertVerbs(new String[]{"rightdis"}, new String[]{"nc0s000", "nc0p000", "nc00000", "np00000", "rg", "rn"})};
        this.nonTerminalInfo.put(tlp.startSymbol(), rootRules);
        this.nonTerminalInfo.put("S", rootRules);
        this.nonTerminalInfo.put("sentence", rootRules);
        this.nonTerminalInfo.put("inc", rootRules);
        String[][] adjectivePhraseRules = new String[][]{{"leftdis", "grup.a", "s.a", "spec"}};
        this.nonTerminalInfo.put("s.a", adjectivePhraseRules);
        this.nonTerminalInfo.put("sa", adjectivePhraseRules);
        this.nonTerminalInfo.put("grup.a", new String[][]{{"rightdis", "aq0000", "ao0000"}, this.insertVerbs(new String[]{"right"}, new String[0]), {"right", "rg", "rn"}});
        this.nonTerminalInfo.put("sadv", new String[][]{{"left", "grup.adv", "sadv"}});
        this.nonTerminalInfo.put("grup.adv", new String[][]{{"left", "conj"}, {"rightdis", "rg", "rn", "neg", "grup.adv"}, {"rightdis", "pr000000", "pi000000", "nc0s000", "nc0p000", "nc00000", "np00000"}});
        this.nonTerminalInfo.put("neg", new String[][]{{"leftdis", "rg", "rn"}});
        this.nonTerminalInfo.put("sn", new String[][]{{"leftdis", "nc0s000", "nc0p000", "nc00000"}, {"left", "grup.nom", "grup.w", "grup.z", "sn"}, {"leftdis", "spec"}});
        this.nonTerminalInfo.put("grup.nom", new String[][]{{"leftdis", "nc0s000", "nc0p000", "nc00000", "np00000", "w", "grup.w"}, {"leftdis", "pi000000", "pd000000"}, {"left", "grup.nom", "sp"}, {"leftdis", "pn000000", "aq0000", "ao0000"}, {"left", "grup.a", "i", "grup.verb"}, {"leftdis", "grup.adv"}});
        this.nonTerminalInfo.put("grup.verb", new String[][]{this.insertVerbs(new String[]{"left"}, new String[0])});
        this.nonTerminalInfo.put("infinitiu", new String[][]{this.insertVerbs(new String[]{"left"}, new String[]{"infinitiu"})});
        this.nonTerminalInfo.put("gerundi", new String[][]{{"left", "vmg0000", "vag0000", "vsg0000", "gerundi"}});
        this.nonTerminalInfo.put("participi", new String[][]{{"left", "aq", "vmp0000", "vap0000", "vsp0000", "grup.a"}});
        this.nonTerminalInfo.put("spec", new String[][]{{"left", "conj", "spec"}, {"leftdis", "da0000", "de0000", "di0000", "dd0000", "dp0000", "dn0000", "dt0000"}, {"leftdis", "z0", "grup.z"}, {"left", "rg", "rn"}, {"leftdis", "pt000000", "pe000000", "pd000000", "pp000000", "pi000000", "pn000000", "pr000000"}, {"left", "grup.adv", "w"}});
        this.nonTerminalInfo.put("conj", new String[][]{{"leftdis", "cs", "cc"}, {"leftdis", "grup.cc", "grup.cs"}, {"left", "sp"}});
        this.nonTerminalInfo.put("interjeccio", new String[][]{{"leftdis", "i", "nc0s000", "nc0p000", "nc00000", "np00000", "pi000000"}, {"left", "interjeccio"}});
        this.nonTerminalInfo.put("relatiu", new String[][]{{"left", "pr000000"}});
        this.nonTerminalInfo.put("sp", new String[][]{{"left", "prep", "sp"}});
        this.nonTerminalInfo.put("prep", new String[][]{{"leftdis", "sp000", "prep", "grup.prep"}});
        this.nonTerminalInfo.put("grup.cc", new String[][]{{"left", "cs"}});
        this.nonTerminalInfo.put("grup.cs", new String[][]{{"left", "cs"}});
        this.nonTerminalInfo.put("grup.prep", new String[][]{{"left", "prep", "grup.prep", "s"}});
        this.nonTerminalInfo.put("grup.pron", new String[][]{{"rightdis", "px000000"}});
        this.nonTerminalInfo.put("grup.w", new String[][]{{"right", "w"}, {"leftdis", "z0"}, {"left"}});
        this.nonTerminalInfo.put("grup.z", new String[][]{{"leftdis", "z0", "zu", "zp", "zd", "zm"}, {"right", "nc0s000", "nc0p000", "nc00000", "np00000"}});
    }

    private String[] insertVerbs(String[] toLeft, String[] toRight) {
        return ArrayUtils.concatenate(toLeft, ArrayUtils.concatenate(allVerbs, toRight));
    }

    public static void main(String[] args) {
        DiskTreebank treebank = new DiskTreebank();
        CategoryWordTag.suppressTerminalDetails = true;
        treebank.loadPath(args[0]);
        final SpanishHeadFinder chf = new SpanishHeadFinder();
        ((Treebank)treebank).apply(new TreeVisitor(){

            @Override
            public void visitTree(Tree pt) {
                Tree head = pt.headTerminal(chf);
            }
        });
    }
}

