/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.trees.GrammaticalRelation;
import java.io.Serializable;

public class TypedDependency
implements Comparable<TypedDependency>,
Serializable {
    private static final long serialVersionUID = -7690294213151279779L;
    private GrammaticalRelation reln;
    private IndexedWord gov;
    private IndexedWord dep;
    private boolean extra;

    public TypedDependency(GrammaticalRelation reln, IndexedWord gov, IndexedWord dep) {
        this.reln = reln;
        this.gov = gov;
        this.dep = dep;
    }

    public TypedDependency(TypedDependency other) {
        this.reln = other.reln;
        this.gov = other.gov;
        this.dep = other.dep;
        this.extra = other.extra;
    }

    public GrammaticalRelation reln() {
        return this.reln;
    }

    public void setGov(IndexedWord gov) {
        this.gov = gov;
    }

    public void setDep(IndexedWord dep) {
        this.dep = dep;
    }

    public IndexedWord gov() {
        return this.gov;
    }

    public IndexedWord dep() {
        return this.dep;
    }

    public boolean extra() {
        return this.extra;
    }

    public void setReln(GrammaticalRelation reln) {
        this.reln = reln;
    }

    public void setExtra() {
        this.extra = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypedDependency)) {
            return false;
        }
        TypedDependency typedDep = (TypedDependency)o;
        if (this.reln != null ? !this.reln.equals(typedDep.reln) : typedDep.reln != null) {
            return false;
        }
        if (this.gov != null ? !this.gov.equals(typedDep.gov) : typedDep.gov != null) {
            return false;
        }
        return !(this.dep != null ? !this.dep.equals(typedDep.dep) : typedDep.dep != null);
    }

    public int hashCode() {
        int result = this.reln != null ? this.reln.hashCode() : 17;
        result = 29 * result + (this.gov != null ? this.gov.hashCode() : 0);
        result = 29 * result + (this.dep != null ? this.dep.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.toString(CoreLabel.OutputFormat.VALUE_INDEX);
    }

    public String toString(CoreLabel.OutputFormat format) {
        return this.reln + "(" + this.gov.toString(format) + ", " + this.dep.toString(format) + ")";
    }

    @Override
    public int compareTo(TypedDependency tdArg) {
        IndexedWord depArg = tdArg.dep();
        IndexedWord depThis = this.dep();
        int indexArg = depArg.index();
        int indexThis = depThis.index();
        if (indexThis > indexArg) {
            return 1;
        }
        if (indexThis < indexArg) {
            return -1;
        }
        int govIndexArg = tdArg.gov().index();
        int govIndexThis = this.gov().index();
        if (govIndexThis > govIndexArg) {
            return 1;
        }
        if (govIndexThis < govIndexArg) {
            return -1;
        }
        return this.reln().compareTo(tdArg.reln());
    }
}

