/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.Alignment;
import edu.stanford.nlp.semgraph.semgrex.Env;
import edu.stanford.nlp.semgraph.semgrex.GraphRelation;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.semgraph.semgrex.VariableStrings;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NodePattern
extends SemgrexPattern {
    private static final Redwood.RedwoodChannels log = Redwood.channels(NodePattern.class);
    private static final long serialVersionUID = -5981133879119233896L;
    private final GraphRelation reln;
    private final boolean negDesc;
    private final Map<String, Pair<Object, Object>> attributes;
    private final boolean isRoot;
    private boolean isLink;
    private boolean isEmpty;
    private final String name;
    private String descString;
    SemgrexPattern child;
    private List<Pair<Integer, String>> variableGroups;

    public NodePattern(GraphRelation r, boolean negDesc, Map<String, String> attrs, boolean root, boolean empty, String name) {
        this(r, negDesc, attrs, root, empty, name, new ArrayList<Pair<Integer, String>>(0));
    }

    public NodePattern(GraphRelation r, boolean negDesc, Map<String, String> attrs, boolean root, boolean empty, String name, List<Pair<Integer, String>> variableGroups) {
        this.reln = r;
        this.negDesc = negDesc;
        this.attributes = Generics.newHashMap();
        this.descString = "{";
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            if (!this.descString.equals("{")) {
                this.descString = this.descString + ";";
            }
            String key = entry.getKey();
            String value = entry.getValue();
            if (value.equals("__")) {
                this.attributes.put(key, Pair.makePair(true, true));
            } else if (value.matches("/.*/")) {
                boolean isRegexp = false;
                for (int i = 1; i < value.length() - 1; ++i) {
                    char chr = value.charAt(i);
                    if (chr >= 'A' && chr <= 'Z' || chr >= 'a' && chr <= 'z' || chr >= '0' && chr <= '9') continue;
                    isRegexp = true;
                    break;
                }
                String patternContent = value.substring(1, value.length() - 1);
                if (isRegexp) {
                    this.attributes.put(key, Pair.makePair(Pattern.compile(patternContent), Pattern.compile(patternContent, 66)));
                } else {
                    this.attributes.put(key, Pair.makePair(patternContent, patternContent));
                }
            } else {
                this.attributes.put(key, Pair.makePair(value, value));
            }
            this.descString = this.descString + key + ':' + value;
        }
        if (root) {
            if (!this.descString.equals("{")) {
                this.descString = this.descString + ";";
            }
            this.descString = this.descString + "$";
        }
        if (empty) {
            if (!this.descString.equals("{")) {
                this.descString = this.descString + ";";
            }
            this.descString = this.descString + "#";
        }
        this.descString = this.descString + '}';
        this.name = name;
        this.child = null;
        this.isRoot = root;
        this.isEmpty = empty;
        this.variableGroups = variableGroups;
    }

    public boolean nodeAttrMatch(IndexedWord node, SemanticGraph sg, boolean ignoreCase) {
        if (this.isRoot && this.negDesc == sg.getRoots().contains(node)) {
            return false;
        }
        if (this.isEmpty) {
            return this.negDesc ? !node.equals(IndexedWord.NO_WORD) : node.equals(IndexedWord.NO_WORD);
        }
        for (Map.Entry<String, Pair<Object, Object>> attr : this.attributes.entrySet()) {
            boolean matches;
            Object toMatch;
            String key = attr.getKey();
            Class c = Env.lookupAnnotationKey(this.env, key);
            Object value = node.get(c);
            String nodeValue = value == null ? null : value.toString();
            if (nodeValue == null) {
                return this.negDesc;
            }
            Object object = toMatch = ignoreCase ? attr.getValue().second : attr.getValue().first;
            if (toMatch instanceof Boolean) {
                matches = (Boolean)toMatch;
            } else if (toMatch instanceof String) {
                matches = ignoreCase ? nodeValue.equalsIgnoreCase(toMatch.toString()) : nodeValue.equals(toMatch.toString());
            } else if (toMatch instanceof Pattern) {
                matches = ((Pattern)toMatch).matcher(nodeValue).matches();
            } else {
                throw new IllegalStateException("Unknown matcher type: " + toMatch + " (of class + " + toMatch.getClass() + ")");
            }
            if (matches) continue;
            return this.negDesc;
        }
        return !this.negDesc;
    }

    public void makeLink() {
        this.isLink = true;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isNull() {
        return this.isEmpty;
    }

    @Override
    public String localString() {
        return this.toString(true, false);
    }

    @Override
    public String toString() {
        return this.toString(true, true);
    }

    @Override
    public String toString(boolean hasPrecedence) {
        return this.toString(hasPrecedence, true);
    }

    public String toString(boolean hasPrecedence, boolean addChild) {
        StringBuilder sb = new StringBuilder();
        if (this.isNegated()) {
            sb.append('!');
        }
        if (this.isOptional()) {
            sb.append('?');
        }
        sb.append(' ');
        if (this.reln != null) {
            sb.append(this.reln);
            sb.append(' ');
        }
        if (!hasPrecedence && addChild && this.child != null) {
            sb.append('(');
        }
        if (this.negDesc) {
            sb.append('!');
        }
        sb.append(this.descString);
        if (this.name != null) {
            sb.append('=').append(this.name);
        }
        if (addChild && this.child != null) {
            sb.append(' ');
            sb.append(this.child.toString(false));
            if (!hasPrecedence) {
                sb.append(')');
            }
        }
        return sb.toString();
    }

    @Override
    public void setChild(SemgrexPattern n) {
        this.child = n;
    }

    @Override
    public List<SemgrexPattern> getChildren() {
        if (this.child == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.child);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public SemgrexMatcher matcher(SemanticGraph sg, IndexedWord node, Map<String, IndexedWord> namesToNodes, Map<String, String> namesToRelations, VariableStrings variableStrings, boolean ignoreCase) {
        return new NodeMatcher(this, sg, null, null, true, node, namesToNodes, namesToRelations, variableStrings, ignoreCase);
    }

    @Override
    public SemgrexMatcher matcher(SemanticGraph sg, Alignment alignment, SemanticGraph sg_align, boolean hyp, IndexedWord node, Map<String, IndexedWord> namesToNodes, Map<String, String> namesToRelations, VariableStrings variableStrings, boolean ignoreCase) {
        return new NodeMatcher(this, sg, alignment, sg_align, this.reln.equals(GraphRelation.ALIGNED_ROOT) ? false : hyp, this.reln.equals(GraphRelation.ALIGNED_ROOT) ? sg_align.getFirstRoot() : node, namesToNodes, namesToRelations, variableStrings, ignoreCase);
    }

    private static class NodeMatcher
    extends SemgrexMatcher {
        private boolean finished = false;
        private Iterator<IndexedWord> nodeMatchCandidateIterator = null;
        private final NodePattern myNode;
        private SemgrexMatcher childMatcher;
        private boolean matchedOnce = false;
        private boolean committedVariables = false;
        private String nextMatchReln = null;
        private IndexedWord nextMatch = null;
        private boolean namedFirst = false;
        private boolean relnNamedFirst = false;
        private boolean ignoreCase = false;

        public NodeMatcher(NodePattern n, SemanticGraph sg, Alignment alignment, SemanticGraph sg_align, boolean hyp, IndexedWord node, Map<String, IndexedWord> namesToNodes, Map<String, String> namesToRelations, VariableStrings variableStrings, boolean ignoreCase) {
            super(sg, alignment, sg_align, hyp, node, namesToNodes, namesToRelations, variableStrings);
            this.myNode = n;
            this.ignoreCase = ignoreCase;
            this.resetChildIter();
        }

        @Override
        void resetChildIter() {
            this.nodeMatchCandidateIterator = this.myNode.reln.searchNodeIterator(this.node, this.hyp ? this.sg : this.sg_aligned);
            if (this.myNode.reln instanceof GraphRelation.ALIGNMENT) {
                ((GraphRelation.ALIGNMENT)this.myNode.reln).setAlignment(this.alignment, this.hyp, (GraphRelation.SearchNodeIterator)this.nodeMatchCandidateIterator);
            }
            this.finished = false;
            if (this.nextMatch != null) {
                this.decommitVariableGroups();
                this.decommitNamedNodes();
                this.decommitNamedRelations();
            }
            this.nextMatch = null;
        }

        private void resetChild() {
            if (this.childMatcher == null) {
                if (this.myNode.child == null) {
                    this.matchedOnce = false;
                } else {
                    this.childMatcher = this.myNode.child.matcher(this.sg, this.alignment, this.sg_aligned, this.myNode.reln instanceof GraphRelation.ALIGNMENT ? !this.hyp : this.hyp, this.nextMatch, this.namesToNodes, this.namesToRelations, this.variableStrings, this.ignoreCase);
                }
            } else {
                this.childMatcher.resetChildIter(this.nextMatch);
            }
        }

        private void goToNextNodeMatch() {
            this.decommitVariableGroups();
            this.decommitNamedNodes();
            this.decommitNamedRelations();
            this.finished = true;
            Matcher m = null;
            while (this.nodeMatchCandidateIterator.hasNext()) {
                if (this.myNode.reln.getName() != null) {
                    String foundReln = (String)this.namesToRelations.get(this.myNode.reln.getName());
                    this.nextMatchReln = ((GraphRelation.SearchNodeIterator)this.nodeMatchCandidateIterator).getReln();
                    if (foundReln != null && !this.nextMatchReln.equals(foundReln)) {
                        this.nextMatch = this.nodeMatchCandidateIterator.next();
                        continue;
                    }
                }
                this.nextMatch = this.nodeMatchCandidateIterator.next();
                if (this.myNode.descString.equals("{}") && this.myNode.isLink) {
                    IndexedWord otherNode = (IndexedWord)this.namesToNodes.get(this.myNode.name);
                    if (otherNode != null) {
                        if (otherNode.equals(this.nextMatch)) {
                            if (this.myNode.negDesc) continue;
                            this.finished = false;
                            break;
                        }
                        if (!this.myNode.negDesc) continue;
                        this.finished = false;
                        break;
                    }
                    boolean found = this.myNode.nodeAttrMatch(this.nextMatch, this.hyp ? this.sg : this.sg_aligned, this.ignoreCase);
                    if (!found) continue;
                    for (Pair varGroup : this.myNode.variableGroups) {
                        String thisVariable = (String)varGroup.second();
                        String thisVarString = this.variableStrings.getString(thisVariable);
                        if (thisVarString == null || thisVarString.equals(m.group((Integer)varGroup.first()))) continue;
                        found = false;
                        break;
                    }
                    this.finished = false;
                    break;
                }
                boolean found = this.myNode.nodeAttrMatch(this.nextMatch, this.hyp ? this.sg : this.sg_aligned, this.ignoreCase);
                if (!found) continue;
                for (Pair varGroup : this.myNode.variableGroups) {
                    String thisVariable = (String)varGroup.second();
                    String thisVarString = this.variableStrings.getString(thisVariable);
                    if (thisVarString == null || thisVarString.equals(m.group((Integer)varGroup.first()))) continue;
                    found = false;
                    break;
                }
                this.finished = false;
                break;
            }
            if (!this.finished) {
                this.resetChild();
                if (this.myNode.name != null) {
                    if (!this.namesToNodes.containsKey(this.myNode.name)) {
                        this.namedFirst = true;
                    }
                    this.namesToNodes.put(this.myNode.name, this.nextMatch);
                }
                if (this.myNode.reln.getName() != null) {
                    if (!this.namesToRelations.containsKey(this.myNode.reln.getName())) {
                        this.relnNamedFirst = true;
                    }
                    this.namesToRelations.put(this.myNode.reln.getName(), this.nextMatchReln);
                }
                this.commitVariableGroups(m);
            }
        }

        private void commitVariableGroups(Matcher m) {
            this.committedVariables = true;
            for (Pair varGroup : this.myNode.variableGroups) {
                String thisVarString = m.group((Integer)varGroup.first());
                this.variableStrings.setVar(varGroup.second(), thisVarString);
            }
        }

        private void decommitVariableGroups() {
            if (this.committedVariables) {
                for (Pair varGroup : this.myNode.variableGroups) {
                    this.variableStrings.unsetVar(varGroup.second());
                }
            }
            this.committedVariables = false;
        }

        private void decommitNamedNodes() {
            if (this.namesToNodes.containsKey(this.myNode.name) && this.namedFirst) {
                this.namedFirst = false;
                this.namesToNodes.remove(this.myNode.name);
            }
        }

        private void decommitNamedRelations() {
            if (this.namesToRelations.containsKey(((NodePattern)this.myNode).reln.name) && this.relnNamedFirst) {
                this.relnNamedFirst = false;
                this.namesToRelations.remove(((NodePattern)this.myNode).reln.name);
            }
        }

        private boolean matchChild() {
            if (this.nextMatch == null) {
                return false;
            }
            if (this.childMatcher == null) {
                if (!this.matchedOnce) {
                    this.matchedOnce = true;
                    return true;
                }
                return false;
            }
            boolean match = this.childMatcher.matches();
            if (!match && this.nextMatch != null) {
                this.decommitVariableGroups();
                this.decommitNamedNodes();
                this.decommitNamedRelations();
            }
            return match;
        }

        @Override
        public boolean matches() {
            if (this.finished) {
                return false;
            }
            while (!this.finished) {
                if (this.matchChild()) {
                    if (this.myNode.isNegated()) {
                        this.finished = true;
                        return false;
                    }
                    if (this.myNode.isOptional()) {
                        this.finished = true;
                    }
                    return true;
                }
                this.goToNextNodeMatch();
            }
            if (this.myNode.isNegated()) {
                return true;
            }
            this.nextMatch = null;
            this.decommitVariableGroups();
            this.decommitNamedNodes();
            this.decommitNamedRelations();
            return this.myNode.isOptional();
        }

        @Override
        public IndexedWord getMatch() {
            return this.nextMatch;
        }

        @Override
        public String toString() {
            return "node matcher for: " + this.myNode.localString();
        }
    }
}

