/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.spanish.process;

import edu.stanford.nlp.international.spanish.SpanishVerbStripper;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnCoraPronounDisambiguator {
    private static Redwood.RedwoodChannels log = Redwood.channels(AnCoraPronounDisambiguator.class);
    private static final Set<String> ambiguousPersonalPronouns = new HashSet<String>(Arrays.asList("me", "te", "se", "nos", "os"));
    private static final Set<String> alwaysReflexiveVerbs = new HashSet<String>(Arrays.asList("acercar", "acostumbrar", "adaptar", "afeitar", "agarrar", "ahincar", "alegrar", "Anticipar", "aplicar", "aprobar", "aprovechar", "asegurar", "Atreve", "bajar", "beneficiar", "callar", "casar", "cobrar", "colocar", "comer", "comportar", "comprar", "concentrar", "cuidar", "deber", "decidir", "defender", "desplazar", "detectar", "divirtiendo", "echar", "encontrar", "enfrentar", "entender", "enterar", "entrometer", "equivocar", "escapar", "esconder", "esforzando", "establecer", "felicitar", "fija", "Fija", "ganar", "guarda", "guardar", "Habituar", "hacer", "imagina", "imaginar", "iniciar", "inscribir", "ir", "jode", "jugar", "Levantar", "Manifestar", "mantener", "marchar", "meter", "Negar", "obsesionar", "Olvida", "Olvidar", "olvidar", "oponer", "Para", "pasar", "plantear", "poner", "pudra", "queda", "quedar", "querer", "quita", "reciclar", "reconoce", "reconstruir", "recordar", "recuperar", "reencontrar", "referir", "registrar", "reincorporar", "rendir", "reservar", "retirar", "reunir", "sentar", "sentir", "someter", "subir", "tirando", "toma", "tomar", "tomen", "Une", "unir", "Ve", "vestir"));
    private static final Set<String> neverReflexiveVerbs = new HashSet<String>(Arrays.asList("abrir", "aguar", "anunciar", "arrebatando", "arruinar", "clasificar", "compensar", "compra", "comprar", "concretar", "contar", "crea", "crear", "Cuente", "Decir", "decir", "deja", "digan", "devolver", "devuelve", "dirigiendo", "distraer", "enfrascar", "exigiendo", "exigir", "haz", "ignorar", "impedir", "insultar", "juzgar", "llamar", "llevando", "llevar", "manda", "mirar", "Miren", "multar", "negar", "ocultando", "pagar", "patear", "pedir", "permitir", "pidiendo", "preguntar", "prevenir", "quitar", "razona", "resultar", "saca", "sacar", "saludar", "seguir", "servir", "situar", "suceder", "tener", "tutear", "utilizar", "vender", "ver", "visitar"));
    private static final Map<Pair<String, String>, PersonalPronounType> bruteForceDecisions = new HashMap<Pair<String, String>, PersonalPronounType>();

    public static boolean isAmbiguous(String pronoun) {
        return ambiguousPersonalPronouns.contains(pronoun);
    }

    public static PersonalPronounType disambiguatePersonalPronoun(SpanishVerbStripper.StrippedVerb strippedVerb, int pronounIdx, String clauseYield) {
        List<String> pronouns = strippedVerb.getPronouns();
        String pronoun = pronouns.get(pronounIdx).toLowerCase();
        if (!ambiguousPersonalPronouns.contains(pronoun)) {
            throw new IllegalArgumentException("We don't support disambiguating pronoun '" + pronoun + "'");
        }
        if (pronouns.size() == 1 && pronoun.equalsIgnoreCase("se")) {
            return PersonalPronounType.REFLEXIVE;
        }
        String verb = strippedVerb.getStem();
        if (alwaysReflexiveVerbs.contains(verb)) {
            return PersonalPronounType.REFLEXIVE;
        }
        if (neverReflexiveVerbs.contains(verb)) {
            return PersonalPronounType.OBJECT;
        }
        Pair<String, String> bruteForceKey = new Pair<String, String>(verb, clauseYield);
        if (bruteForceDecisions.containsKey(bruteForceKey)) {
            return bruteForceDecisions.get(bruteForceKey);
        }
        log.info("Failed to disambiguate: " + verb + "\nContaining clause:\t" + clauseYield + "\n");
        return PersonalPronounType.UNKNOWN;
    }

    static {
        bruteForceDecisions.put(new Pair<String, String>("contar", "No contarte mi vida nunca m\u00e1s"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("Creer", "Creerselo todo"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("creer", "cre\u00e9rselo todo ..."), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("creer", "creerte"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("Dar", "Darte de alta ahi"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("da", "A mi dame billetes uno al lado del otro que es la forma mas l\u00edquida que uno pueda estar"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("da", "danos UNA razon UNA"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("da", "y ... dame una razon por la que hubiera matado o se hubiera comido a el compa\u00f1ero ?"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("dar", "darme cuenta"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("dar", "darme la enhorabuena"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("dar", "darnos cuenta"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("dar", "darselo a la do\u00f1a"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("dar", "darte cuenta"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("dar", "darte de alta"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("dar", "darte vuelta en cuestiones que no tienen nada que ver con lo que comenzaste diciendo"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("dar", "podr\u00eda darnos"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("dar", "puede darnos"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("decir", "suele decirnos"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("decir", "suelo dec\u00edrmelo"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("dejar", "deber\u00eda dejarnos faenar"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("dejar", "dejarme un intermitente encendido"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("dejar", ": dejarnos un pa\u00eds tan limpio en su gobierno como el cielo claro despu\u00e9s de las tormentas mediterr\u00e1neas , que inundan nuestras obras p\u00fablicas sin encontrar nunca ni un solo responsable pol\u00edtico de tanta mala gesti\u00f3n , ya sea la plaza de Cerd\u00e0 socialista o los incendios forestales de la Generalitat"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("dejar", "podemos dejarnos adormecer"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("enga\u00f1ar", "enga\u00f1arnos"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("estira", "=LRB= al menos estirate a los japoneses HDP !!! =RRB="), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("estira", "-LRB- al menos estirate a los japoneses HDP !!! -RRB-"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("estira", "( al menos estirate a los japoneses HDP !!! )"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("explica", "explicame como hago"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("explicar", "deber\u00e1 explicarnos"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("liar", "liarme a tiros"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("librar", "librarme de el mismo para siempre"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("llevar", "llevarnos a una trampa en esta elecci\u00f3n"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("manifestar", "manifestarme su solidaridad"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("manifestar", "manifestarnos sobre las circunstancias que mantienen en vilo la vida y obra de los colombianos"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("mirando", "est\u00e1bamos mir\u00e1ndonos"), PersonalPronounType.REFLEXIVE);
        bruteForceDecisions.put(new Pair<String, String>("poner", "ponerme en ascuas"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("servir", "servirme de gu\u00eda"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("volver", "debe volvernos"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("volver", "deja de volverme"), PersonalPronounType.OBJECT);
        bruteForceDecisions.put(new Pair<String, String>("volver", "volvernos"), PersonalPronounType.REFLEXIVE);
    }

    public static enum PersonalPronounType {
        OBJECT,
        REFLEXIVE,
        UNKNOWN;

    }
}

