(tag-map

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Changes to the Bies mapping
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Abbreviations and other odds and ends
ABBREV	ABBREV
DET+ABBREV	ABBREV
DET+DIALECT	DTNN
DET+FOREIGN	DTNN
DET+NOUN	DTNN
DET+TYPO	DTNN
DIALECT	NN
FOREIGN	NN
GRAMMAR_PROBLEM	NN
LATIN	NN
TYPO	NN

;; Maps ف back to CC, which will then be split by the parser
;; splitCC feature
CONNEC_PART	CC

;; For ان when it heads SBAR...hard to distinguish after normalization
SUB_CONJ	SUB_CONJ

INTERROG_ADV	INTERROG_ADV
INTERROG_PART	INTERROG_PART
INTERROG_PRON	INTERROG_PRON
INTERROG_PRON+CASE_DEF_GEN	INTERROG_PRON
INTERROG_PRON+CASE_DEF_NOM	INTERROG_PRON
INTERROG_PRON+NSUFF_FEM_SG+CASE_DEF_GEN	INTERROG_PRON

;; Noun and verb particles
VOC_PART	NRP
JUS_PART	VRP
NEG_PART	VRP
FUT_PART	VRP
PART	VRP
RC_PART	VRP
RESTRIC_PART	VRP
VERB_PART	VRP

;; Appear under PRT
EMPHATIC_PART	RP
FOCUS_PART	RP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Bies mapping + Kulick et. al 2006 determiner
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ADJ	JJ
ADJ+CASE_DEF_ACC	JJ
ADJ+CASE_DEF_GEN	JJ
ADJ+CASE_DEF_NOM	JJ
ADJ+CASE_INDEF_ACC	JJ
ADJ+CASE_INDEF_GEN	JJ
ADJ+CASE_INDEF_NOM	JJ
ADJ+NSUFF_FEM_DU_ACC	JJ
ADJ+NSUFF_FEM_DU_ACCGEN	JJ
ADJ+NSUFF_FEM_DU_GEN	JJ
ADJ+NSUFF_FEM_DU_NOM	JJ
ADJ+NSUFF_FEM_DU_NOM_POSS	JJ
ADJ+NSUFF_FEM_PL	JJ
ADJ+NSUFF_FEM_PL+CASE_DEF_ACCGEN	JJ
ADJ+NSUFF_FEM_PL+CASE_DEF_NOM	JJ
ADJ+NSUFF_FEM_PL+CASE_INDEF_ACC	JJ
ADJ+NSUFF_FEM_PL+CASE_INDEF_ACCGEN	JJ
ADJ+NSUFF_FEM_PL+CASE_INDEF_GEN	JJ
ADJ+NSUFF_FEM_SG	JJ
ADJ+NSUFF_FEM_SG+CASE_DEF_ACC	JJ
ADJ+NSUFF_FEM_SG+CASE_DEF_GEN	JJ
ADJ+NSUFF_FEM_SG+CASE_DEF_NOM	JJ
ADJ+NSUFF_FEM_SG+CASE_INDEF_ACC	JJ
ADJ+NSUFF_FEM_SG+CASE_INDEF_GEN	JJ
ADJ+NSUFF_FEM_SG+CASE_INDEF_NOM	JJ
ADJ+NSUFF_MASC_DU_ACC	JJ
ADJ+NSUFF_MASC_DU_ACCGEN	JJ
ADJ+NSUFF_MASC_DU_ACCGEN_POSS	JJ
ADJ+NSUFF_MASC_DU_GEN	JJ
ADJ+NSUFF_MASC_DU_GEN_POSS	JJ
ADJ+NSUFF_MASC_DU_NOM	JJ
ADJ+NSUFF_MASC_DU_NOM_POSS	JJ
ADJ+NSUFF_MASC_PL_ACC	JJ
ADJ+NSUFF_MASC_PL_ACCGEN	JJ
ADJ+NSUFF_MASC_PL_ACCGEN_POSS	JJ
ADJ+NSUFF_MASC_PL_ACC_POSS	JJ
ADJ+NSUFF_MASC_PL_GEN	JJ
ADJ+NSUFF_MASC_PL_GEN_POSS	JJ
ADJ+NSUFF_MASC_PL_NOM	JJ
ADJ+NSUFF_MASC_PL_NOM_POSS	JJ
ADJ.VN	VN
ADJ.VN+CASE_DEF_GEN	VN
ADJ.VN+CASE_DEF_NOM	VN
ADJ.VN+CASE_INDEF_ACC	VN
ADJ.VN+CASE_INDEF_GEN	VN
ADJ.VN+CASE_INDEF_NOM	VN
ADJ.VN+NSUFF_FEM_DU_ACC	VN
ADJ.VN+NSUFF_FEM_SG	VN
ADJ.VN+NSUFF_FEM_SG+CASE_DEF_ACC	VN
ADJ.VN+NSUFF_FEM_SG+CASE_DEF_GEN	VN
ADJ.VN+NSUFF_FEM_SG+CASE_INDEF_ACC	VN
ADJ.VN+NSUFF_FEM_SG+CASE_INDEF_GEN	VN
ADJ.VN+NSUFF_FEM_SG+CASE_INDEF_NOM	VN
ADJ.VN+NSUFF_MASC_DU_ACC	VN
ADJ.VN+NSUFF_MASC_DU_GEN	VN
ADJ.VN+NSUFF_MASC_DU_NOM_POSS	VN
ADJ.VN+NSUFF_MASC_PL_ACC	VN
ADJ.VN+NSUFF_MASC_PL_ACCGEN	VN
ADJ.VN+NSUFF_MASC_PL_GEN	VN
ADJ.VN+NSUFF_MASC_PL_NOM	VN
ADJ_COMP	JJR
ADJ_COMP+CASE_DEF_ACC	JJR
ADJ_COMP+CASE_DEF_GEN	JJR
ADJ_COMP+CASE_DEF_NOM	JJR
ADJ_COMP+CASE_INDEF_ACC	JJR
ADJ_COMP+CASE_INDEF_GEN	JJR
ADJ_COMP+CASE_INDEF_NOM	JJR
ADJ_COMP+NSUFF_FEM_SG+CASE_INDEF_NOM	JJR
ADJ_NUM	ADJ_NUM
ADJ_NUM+CASE_DEF_ACC	ADJ_NUM
ADJ_NUM+CASE_DEF_GEN	ADJ_NUM
ADJ_NUM+CASE_DEF_NOM	ADJ_NUM
ADJ_NUM+CASE_INDEF_ACC	ADJ_NUM
ADJ_NUM+CASE_INDEF_GEN	ADJ_NUM
ADJ_NUM+CASE_INDEF_NOM	ADJ_NUM
ADJ_NUM+NSUFF_FEM_DU_GEN	ADJ_NUM
ADJ_NUM+NSUFF_FEM_SG+CASE_DEF_ACC	ADJ_NUM
ADJ_NUM+NSUFF_FEM_SG+CASE_DEF_GEN	ADJ_NUM
ADJ_NUM+NSUFF_FEM_SG+CASE_DEF_NOM	ADJ_NUM
ADJ_NUM+NSUFF_FEM_SG+CASE_INDEF_ACC	ADJ_NUM
ADJ_NUM+NSUFF_FEM_SG+CASE_INDEF_GEN	ADJ_NUM
ADJ_NUM+NSUFF_FEM_SG+CASE_INDEF_NOM	ADJ_NUM
ADV	RB
ADV+CASE_INDEF_ACC	RB
CONJ	CC
CV	VB
CV+CVSUFF_SUBJ:2FS	VB
CV+CVSUFF_SUBJ:2MP	VB
CV+CVSUFF_SUBJ:2MS	VB
CVSUFF_DO:1P	PRP
CVSUFF_DO:1S	PRP
CVSUFF_DO:3FS	PRP
CVSUFF_DO:3MP	PRP
CVSUFF_DO:3MS	PRP
DEM_PRON	DT
DEM_PRON_F	DT
DEM_PRON_FD	DT
DEM_PRON_FS	DT
DEM_PRON_MD	DT
DEM_PRON_MP	DT
DEM_PRON_MS	DT
DET	DT
DET+ADJ	DTJJ
DET+ADJ+CASE_DEF_ACC	DTJJ
DET+ADJ+CASE_DEF_GEN	DTJJ
DET+ADJ+CASE_DEF_NOM	DTJJ
DET+ADJ+NSUFF_FEM_DU_ACC	DTJJ
DET+ADJ+NSUFF_FEM_DU_ACCGEN	DTJJ
DET+ADJ+NSUFF_FEM_DU_ACCGEN_POSS	DTJJ
DET+ADJ+NSUFF_FEM_DU_GEN	DTJJ
DET+ADJ+NSUFF_FEM_DU_NOM	DTJJ
DET+ADJ+NSUFF_FEM_PL+CASE_DEF_ACC	DTJJ
DET+ADJ+NSUFF_FEM_PL+CASE_DEF_ACCGEN	DTJJ
DET+ADJ+NSUFF_FEM_PL+CASE_DEF_GEN	DTJJ
DET+ADJ+NSUFF_FEM_PL+CASE_DEF_NOM	DTJJ
DET+ADJ+NSUFF_FEM_SG	DTJJ
DET+ADJ+NSUFF_FEM_SG+CASE_DEF_ACC	DTJJ
DET+ADJ+NSUFF_FEM_SG+CASE_DEF_GEN	DTJJ
DET+ADJ+NSUFF_FEM_SG+CASE_DEF_NOM	DTJJ
DET+ADJ+NSUFF_MASC_DU_ACC	DTJJ
DET+ADJ+NSUFF_MASC_DU_ACCGEN	DTJJ
DET+ADJ+NSUFF_MASC_DU_GEN	DTJJ
DET+ADJ+NSUFF_MASC_DU_NOM	DTJJ
DET+ADJ+NSUFF_MASC_PL_ACC	DTJJ
DET+ADJ+NSUFF_MASC_PL_ACCGEN	DTJJ
DET+ADJ+NSUFF_MASC_PL_ACCGEN_POSS	DTJJ
DET+ADJ+NSUFF_MASC_PL_ACC_POSS	DTJJ
DET+ADJ+NSUFF_MASC_PL_GEN	DTJJ
DET+ADJ+NSUFF_MASC_PL_GEN_POSS	DTJJ
DET+ADJ+NSUFF_MASC_PL_NOM	DTJJ
DET+ADJ.VN	VN
DET+ADJ.VN+CASE_DEF_ACC	VN
DET+ADJ.VN+CASE_DEF_GEN	VN
DET+ADJ.VN+CASE_DEF_NOM	VN
DET+ADJ.VN+NSUFF_FEM_DU_ACC	VN
DET+ADJ.VN+NSUFF_FEM_DU_GEN	VN
DET+ADJ.VN+NSUFF_FEM_PL+CASE_DEF_GEN	VN
DET+ADJ.VN+NSUFF_FEM_PL+CASE_DEF_NOM	VN
DET+ADJ.VN+NSUFF_FEM_SG	VN
DET+ADJ.VN+NSUFF_FEM_SG+CASE_DEF_ACC	VN
DET+ADJ.VN+NSUFF_FEM_SG+CASE_DEF_GEN	VN
DET+ADJ.VN+NSUFF_FEM_SG+CASE_DEF_NOM	VN
DET+ADJ.VN+NSUFF_MASC_DU_ACC	VN
DET+ADJ.VN+NSUFF_MASC_DU_GEN	VN
DET+ADJ.VN+NSUFF_MASC_PL_ACC	VN
DET+ADJ.VN+NSUFF_MASC_PL_ACCGEN	VN
DET+ADJ.VN+NSUFF_MASC_PL_GEN	VN
DET+ADJ.VN+NSUFF_MASC_PL_NOM	VN
DET+ADJ_COMP	DTJJR
DET+ADJ_COMP+CASE_DEF_ACC	DTJJR
DET+ADJ_COMP+CASE_DEF_GEN	DTJJR
DET+ADJ_COMP+CASE_DEF_NOM	DTJJR
DET+ADJ_COMP+NSUFF_MASC_DU_GEN	DTJJR
DET+ADJ_COMP+NSUFF_MASC_PL_GEN	DTJJR
DET+ADJ_COMP+NSUFF_MASC_PL_NOM	DTJJR
DET+ADJ_NUM	ADJ_NUM
DET+ADJ_NUM+CASE_DEF_ACC	ADJ_NUM
DET+ADJ_NUM+CASE_DEF_GEN	ADJ_NUM
DET+ADJ_NUM+CASE_DEF_NOM	ADJ_NUM
DET+ADJ_NUM+NSUFF_FEM_PL+CASE_DEF_GEN	ADJ_NUM
DET+ADJ_NUM+NSUFF_FEM_PL+CASE_DEF_NOM	ADJ_NUM
DET+ADJ_NUM+NSUFF_FEM_SG	ADJ_NUM
DET+ADJ_NUM+NSUFF_FEM_SG+CASE_DEF_ACC	ADJ_NUM
DET+ADJ_NUM+NSUFF_FEM_SG+CASE_DEF_GEN	ADJ_NUM
DET+ADJ_NUM+NSUFF_FEM_SG+CASE_DEF_NOM	ADJ_NUM
DET+ADJ_NUM+NSUFF_MASC_DU_ACC	ADJ_NUM
DET+ADJ_NUM+NSUFF_MASC_DU_GEN	ADJ_NUM
DET+ADJ_NUM+NSUFF_MASC_DU_NOM	ADJ_NUM
DET+ADJ_NUM+NSUFF_MASC_PL_ACCGEN	ADJ_NUM
DET+ADJ_NUM+NSUFF_MASC_PL_GEN	ADJ_NUM
DET+NOUN+CASE_DEF_ACC	DTNN
DET+NOUN+CASE_DEF_GEN	DTNN
DET+NOUN+CASE_DEF_NOM	DTNN
DET+NOUN+NSUFF_FEM_DU_ACC	DTNNS
DET+NOUN+NSUFF_FEM_DU_ACCGEN	DTNNS
DET+NOUN+NSUFF_FEM_DU_GEN	DTNNS
DET+NOUN+NSUFF_FEM_DU_GEN_POSS	DTNNS
DET+NOUN+NSUFF_FEM_DU_NOM	DTNNS
DET+NOUN+NSUFF_FEM_PL	DTNNS
DET+NOUN+NSUFF_FEM_PL+CASE_DEF_ACC	DTNNS
DET+NOUN+NSUFF_FEM_PL+CASE_DEF_ACCGEN	DTNNS
DET+NOUN+NSUFF_FEM_PL+CASE_DEF_GEN	DTNNS
DET+NOUN+NSUFF_FEM_PL+CASE_DEF_NOM	DTNNS
DET+NOUN+NSUFF_FEM_SG	DTNN
DET+NOUN+NSUFF_FEM_SG+CASE_DEF_ACC	DTNN
DET+NOUN+NSUFF_FEM_SG+CASE_DEF_GEN	DTNN
DET+NOUN+NSUFF_FEM_SG+CASE_DEF_NOM	DTNN
DET+NOUN+NSUFF_MASC_DU	DTNNS
DET+NOUN+NSUFF_MASC_DU_ACC	DTNNS
DET+NOUN+NSUFF_MASC_DU_ACCGEN	DTNNS
DET+NOUN+NSUFF_MASC_DU_GEN	DTNNS
DET+NOUN+NSUFF_MASC_DU_GEN_POSS	DTNNS
DET+NOUN+NSUFF_MASC_DU_NOM	DTNNS
DET+NOUN+NSUFF_MASC_PL_ACC	DTNNS
DET+NOUN+NSUFF_MASC_PL_ACCGEN	DTNNS
DET+NOUN+NSUFF_MASC_PL_GEN	DTNNS
DET+NOUN+NSUFF_MASC_PL_GEN_POSS	DTNNS
DET+NOUN+NSUFF_MASC_PL_NOM	DTNNS
DET+NOUN.VN	VBG
DET+NOUN.VN+CASE_DEF_ACC	VBG
DET+NOUN.VN+CASE_DEF_GEN	VBG
DET+NOUN.VN+CASE_DEF_NOM	VBG
DET+NOUN.VN+NSUFF_FEM_DU_GEN	VBG
DET+NOUN.VN+NSUFF_FEM_SG+CASE_DEF_ACC	VBG
DET+NOUN.VN+NSUFF_FEM_SG+CASE_DEF_GEN	VBG
DET+NOUN.VN+NSUFF_FEM_SG+CASE_DEF_NOM	VBG
DET+NOUN.VN+NSUFF_MASC_DU_NOM	VBG
DET+NOUN.VN+NSUFF_MASC_PL_ACC	VBG
DET+NOUN.VN+NSUFF_MASC_PL_ACCGEN	VBG
DET+NOUN.VN+NSUFF_MASC_PL_GEN	VBG
DET+NOUN.VN+NSUFF_MASC_PL_NOM	VBG
DET+NOUN_NUM+CASE_DEF_ACC	CD
DET+NOUN_NUM+CASE_DEF_GEN	CD
DET+NOUN_NUM+NSUFF_FEM_SG+CASE_DEF_ACC	CD
DET+NOUN_NUM+NSUFF_FEM_SG+CASE_DEF_GEN	CD
DET+NOUN_NUM+NSUFF_FEM_SG+CASE_DEF_NOM	CD
DET+NOUN_NUM+NSUFF_MASC_DU_NOM	CD
DET+NOUN_NUM+NSUFF_MASC_PL_ACC	CD
DET+NOUN_NUM+NSUFF_MASC_PL_GEN	CD
DET+NOUN_NUM+NSUFF_MASC_PL_NOM	CD
DET+NOUN_PROP	DTNNP
DET+NOUN_PROP+CASE_DEF_ACC	DTNNP
DET+NOUN_PROP+CASE_DEF_GEN	DTNNP
DET+NOUN_PROP+CASE_DEF_NOM	DTNNP
DET+NOUN_PROP+NSUFF_FEM_DU_GEN	DTNNPS
DET+NOUN_PROP+NSUFF_FEM_DU_NOM	DTNNPS
DET+NOUN_PROP+NSUFF_FEM_PL	DTNNPS
DET+NOUN_PROP+NSUFF_FEM_PL+CASE_DEF_ACCGEN	DTNNPS
DET+NOUN_PROP+NSUFF_FEM_PL+CASE_DEF_GEN	DTNNPS
DET+NOUN_PROP+NSUFF_FEM_SG	DTNNP
DET+NOUN_PROP+NSUFF_FEM_SG+CASE_DEF_ACC	DTNNP
DET+NOUN_PROP+NSUFF_FEM_SG+CASE_DEF_GEN	DTNNP
DET+NOUN_PROP+NSUFF_FEM_SG+CASE_DEF_NOM	DTNNP
DET+NOUN_PROP+NSUFF_MASC_DU_ACCGEN	DTNNPS
DET+NOUN_PROP+NSUFF_MASC_DU_GEN	DTNNPS
DET+NOUN_PROP+NSUFF_MASC_PL_ACC	DTNNPS
DET+NOUN_PROP+NSUFF_MASC_PL_GEN	DTNNPS
DET+NOUN_PROP+NSUFF_MASC_PL_NOM	DTNNPS
DET+NOUN_QUANT+CASE_DEF_ACC	NOUN_QUANT
DET+NOUN_QUANT+CASE_DEF_GEN	NOUN_QUANT
DET+NOUN_QUANT+CASE_DEF_NOM	NOUN_QUANT
DET+NOUN_QUANT+NSUFF_FEM_SG+CASE_DEF_ACC	NOUN_QUANT
DET+NOUN_QUANT+NSUFF_FEM_SG+CASE_DEF_GEN	NOUN_QUANT
DET+NOUN_QUANT+NSUFF_FEM_SG+CASE_DEF_NOM	NOUN_QUANT
EXCLAM_PRON	WP
FUT+IV1P+IV+IVSUFF_MOOD:I	VBP
FUT+IV1S+IV+IVSUFF_MOOD:I	VBP
FUT+IV2MP+IV+IVSUFF_SUBJ:MP_MOOD:I	VBP
FUT+IV2MS+IV+IVSUFF_MOOD:I	VBP
FUT+IV3FD+IV+IVSUFF_SUBJ:D_MOOD:I	VBP
FUT+IV3FS+IV+IVSUFF_MOOD:I	VBP
FUT+IV3FS+IV_PASS+IVSUFF_MOOD:I	VBN
FUT+IV3MD+IV+IVSUFF_SUBJ:D_MOOD:I	VBP
FUT+IV3MD+IV_PASS+IVSUFF_SUBJ:D_MOOD:I	VBN
FUT+IV3MP+IV+IVSUFF_SUBJ:MP_MOOD:I	VBP
FUT+IV3MP+IV_PASS+IVSUFF_SUBJ:MP_MOOD:I	VBN
FUT+IV3MS+IV+IVSUFF_MOOD:I	VBP
FUT+IV3MS+IV_PASS+IVSUFF_MOOD:I	VBN
FUT+IV3MS+IV_PASS+IVSUFF_MOOD:S	VBN
INTERJ	UH
IV	VBP
IV+IVSUFF_SUBJ:3FS	VBP
IV1P+IV	VBP
IV1P+IV+IVSUFF_MOOD:I	VBP
IV1P+IV+IVSUFF_MOOD:J	VBP
IV1P+IV+IVSUFF_MOOD:S	VBP
IV1P+IV_PASS+IVSUFF_MOOD:I	VBN
IV1P+IV_PASS+IVSUFF_MOOD:S	VBN
IV1S+IV	VBP
IV1S+IV+IVSUFF_MOOD:I	VBP
IV1S+IV+IVSUFF_MOOD:J	VBP
IV1S+IV+IVSUFF_MOOD:S	VBP
IV1S+IV_PASS+IVSUFF_MOOD:I	VBN
IV1S+IV_PASS+IVSUFF_MOOD:S	VBN
IV2D+IV+IVSUFF_SUBJ:D_MOOD:I	VBP
IV2D+IV+IVSUFF_SUBJ:D_MOOD:SJ	VBP
IV2FP+IV+IVSUFF_SUBJ:FP	VBP
IV2FS+IV+IVSUFF_SUBJ:2FS_MOOD:I	VBP
IV2FS+IV+IVSUFF_SUBJ:2FS_MOOD:SJ	VBP
IV2FS+IV_PASS+IVSUFF_MOOD:I	VBN
IV2FS+IV_PASS+IVSUFF_MOOD:S	VBN
IV2MP+IV+IVSUFF_SUBJ:MP_MOOD:I	VBP
IV2MP+IV+IVSUFF_SUBJ:MP_MOOD:SJ	VBP
IV2MS+IV	VBP
IV2MS+IV+IVSUFF_MOOD:I	VBP
IV2MS+IV+IVSUFF_MOOD:J	VBP
IV2MS+IV+IVSUFF_MOOD:S	VBP
IV2MS+IV_PASS+IVSUFF_MOOD:I	VBN
IV2MS+IV_PASS+IVSUFF_MOOD:J	VBN
IV2MS+IV_PASS+IVSUFF_MOOD:S	VBN
IV3FD+IV+IVSUFF_SUBJ:D_MOOD:I	VBP
IV3FD+IV+IVSUFF_SUBJ:D_MOOD:SJ	VBP
IV3FP+IV+IVSUFF_SUBJ:FP	VBP
IV3FS+IV	VBP
IV3FS+IV+IVSUFF_MOOD:I	VBP
IV3FS+IV+IVSUFF_MOOD:J	VBP
IV3FS+IV+IVSUFF_MOOD:S	VBP
IV3FS+IV+IVSUFF_SUBJ:3FS	VBP
IV3FS+IV_PASS	VBN
IV3FS+IV_PASS+IVSUFF_MOOD:I	VBN
IV3FS+IV_PASS+IVSUFF_MOOD:J	VBN
IV3FS+IV_PASS+IVSUFF_MOOD:S	VBN
IV3MD+IV+IVSUFF_SUBJ:D_MOOD:I	VBP
IV3MD+IV+IVSUFF_SUBJ:D_MOOD:SJ	VBP
IV3MD+IV_PASS+IVSUFF_SUBJ:D_MOOD:I	VBN
IV3MD+IV_PASS+IVSUFF_SUBJ:D_MOOD:SJ	VBN
IV3MP+IV+IVSUFF_MOOD:I	VBP
IV3MP+IV+IVSUFF_MOOD:S	VBP
IV3MP+IV+IVSUFF_SUBJ:MP_MOOD:I	VBP
IV3MP+IV+IVSUFF_SUBJ:MP_MOOD:SJ	VBP
IV3MP+IV_PASS+IVSUFF_MOOD:I	VBN
IV3MP+IV_PASS+IVSUFF_SUBJ:MP_MOOD:I	VBN
IV3MP+IV_PASS+IVSUFF_SUBJ:MP_MOOD:SJ	VBN
IV3MS+IV	VBP
IV3MS+IV+IVSUFF_MOOD:I	VBP
IV3MS+IV+IVSUFF_MOOD:J	VBP
IV3MS+IV+IVSUFF_MOOD:S	VBP
IV3MS+IV_PASS	VBN
IV3MS+IV_PASS+IVSUFF_MOOD:I	VBN
IV3MS+IV_PASS+IVSUFF_MOOD:J	VBN
IV3MS+IV_PASS+IVSUFF_MOOD:S	VBN
IVSUFF_DO:1P	PRP
IVSUFF_DO:1S	PRP
IVSUFF_DO:2FS	PRP
IVSUFF_DO:2MP	PRP
IVSUFF_DO:2MS	PRP
IVSUFF_DO:3D	PRP
IVSUFF_DO:3FS	PRP
IVSUFF_DO:3MP	PRP
IVSUFF_DO:3MS	PRP
IV_PASS	VBN
JUS+IV1P+IV+IVSUFF_MOOD:J	VBP
JUS+IV2FS+IV+IVSUFF_SUBJ:2FS_MOOD:SJ	VBP
JUS+IV2MS+IV+IVSUFF_MOOD:J	VBP
JUS+IV3FS+IV+IVSUFF_MOOD:J	VBP
JUS+IV3MP+IV+IVSUFF_MOOD:J	VBP
JUS+IV3MP+IV+IVSUFF_SUBJ:MP_MOOD:SJ	VBP
JUS+IV3MS+IV+IVSUFF_MOOD:J	VBP
JUS+IV3MS+IV_PASS+IVSUFF_MOOD:J	VBN
NOUN	NN
NOUN+CASE_DEF_ACC	NN
NOUN+CASE_DEF_GEN	NN
NOUN+CASE_DEF_NOM	NN
NOUN+CASE_INDEF_ACC	NN
NOUN+CASE_INDEF_GEN	NN
NOUN+CASE_INDEF_NOM	NN
NOUN+NSUFF_FEM_DU_ACC	NNS
NOUN+NSUFF_FEM_DU_ACCGEN	NNS
NOUN+NSUFF_FEM_DU_ACCGEN_POSS	NNS
NOUN+NSUFF_FEM_DU_ACC_POSS	NNS
NOUN+NSUFF_FEM_DU_GEN	NNS
NOUN+NSUFF_FEM_DU_GEN_POSS	NNS
NOUN+NSUFF_FEM_DU_NOM	NNS
NOUN+NSUFF_FEM_DU_NOM_POSS	NNS
NOUN+NSUFF_FEM_PL	NNS
NOUN+NSUFF_FEM_PL+CASE_DEF_ACC	NNS
NOUN+NSUFF_FEM_PL+CASE_DEF_ACCGEN	NNS
NOUN+NSUFF_FEM_PL+CASE_DEF_GEN	NNS
NOUN+NSUFF_FEM_PL+CASE_DEF_NOM	NNS
NOUN+NSUFF_FEM_PL+CASE_INDEF_ACC	NNS
NOUN+NSUFF_FEM_PL+CASE_INDEF_ACCGEN	NNS
NOUN+NSUFF_FEM_PL+CASE_INDEF_GEN	NNS
NOUN+NSUFF_FEM_PL+CASE_INDEF_NOM	NNS
NOUN+NSUFF_FEM_SG	NN
NOUN+NSUFF_FEM_SG+CASE_DEF_ACC	NN
NOUN+NSUFF_FEM_SG+CASE_DEF_GEN	NN
NOUN+NSUFF_FEM_SG+CASE_DEF_NOM	NN
NOUN+NSUFF_FEM_SG+CASE_INDEF_ACC	NN
NOUN+NSUFF_FEM_SG+CASE_INDEF_GEN	NN
NOUN+NSUFF_FEM_SG+CASE_INDEF_NOM	NN
NOUN+NSUFF_MASC_DU	NNS
NOUN+NSUFF_MASC_DU_ACC	NNS
NOUN+NSUFF_MASC_DU_ACCGEN	NNS
NOUN+NSUFF_MASC_DU_ACCGEN_POSS	NNS
NOUN+NSUFF_MASC_DU_ACC_POSS	NNS
NOUN+NSUFF_MASC_DU_GEN	NNS
NOUN+NSUFF_MASC_DU_GEN_POSS	NNS
NOUN+NSUFF_MASC_DU_NOM	NNS
NOUN+NSUFF_MASC_DU_NOM_POSS	NNS
NOUN+NSUFF_MASC_PL_ACC	NNS
NOUN+NSUFF_MASC_PL_ACCGEN	NNS
NOUN+NSUFF_MASC_PL_ACCGEN_POSS	NNS
NOUN+NSUFF_MASC_PL_ACC_POSS	NNS
NOUN+NSUFF_MASC_PL_GEN	NNS
NOUN+NSUFF_MASC_PL_GEN_POSS	NNS
NOUN+NSUFF_MASC_PL_NOM	NNS
NOUN+NSUFF_MASC_PL_NOM_POSS	NNS
NOUN+NSUFF_MASC_SG_ACC_INDEF	NN
NOUN.VN	VBG
NOUN.VN+CASE_DEF_ACC	VBG
NOUN.VN+CASE_DEF_GEN	VBG
NOUN.VN+CASE_DEF_NOM	VBG
NOUN.VN+CASE_INDEF_ACC	VBG
NOUN.VN+CASE_INDEF_GEN	VBG
NOUN.VN+CASE_INDEF_NOM	VBG
NOUN.VN+NSUFF_FEM_DU_ACC	VBG
NOUN.VN+NSUFF_FEM_PL+CASE_DEF_ACC	VBG
NOUN.VN+NSUFF_FEM_PL+CASE_DEF_ACCGEN	VBG
NOUN.VN+NSUFF_FEM_PL+CASE_DEF_GEN	VBG
NOUN.VN+NSUFF_FEM_PL+CASE_DEF_NOM	VBG
NOUN.VN+NSUFF_FEM_SG	VBG
NOUN.VN+NSUFF_FEM_SG+CASE_DEF_ACC	VBG
NOUN.VN+NSUFF_FEM_SG+CASE_DEF_GEN	VBG
NOUN.VN+NSUFF_FEM_SG+CASE_DEF_NOM	VBG
NOUN.VN+NSUFF_FEM_SG+CASE_INDEF_ACC	VBG
NOUN.VN+NSUFF_FEM_SG+CASE_INDEF_GEN	VBG
NOUN.VN+NSUFF_FEM_SG+CASE_INDEF_NOM	VBG
NOUN.VN+NSUFF_MASC_DU_GEN	VBG
NOUN.VN+NSUFF_MASC_PL_ACC	VBG
NOUN.VN+NSUFF_MASC_PL_ACCGEN	VBG
NOUN.VN+NSUFF_MASC_PL_NOM	VBG
NOUN_NUM	CD
NOUN_NUM+CASE_DEF_ACC	CD
NOUN_NUM+CASE_DEF_GEN	CD
NOUN_NUM+CASE_DEF_NOM	CD
NOUN_NUM+CASE_INDEF_ACC	CD
NOUN_NUM+CASE_INDEF_GEN	CD
NOUN_NUM+CASE_INDEF_NOM	CD
NOUN_NUM+NSUFF_FEM_DU_ACC	CD
NOUN_NUM+NSUFF_FEM_DU_GEN	CD
NOUN_NUM+NSUFF_FEM_DU_GEN_POSS	CD
NOUN_NUM+NSUFF_FEM_PL+CASE_DEF_ACC	CD
NOUN_NUM+NSUFF_FEM_PL+CASE_DEF_ACCGEN	CD
NOUN_NUM+NSUFF_FEM_PL+CASE_DEF_GEN	CD
NOUN_NUM+NSUFF_FEM_PL+CASE_DEF_NOM	CD
NOUN_NUM+NSUFF_FEM_PL+CASE_INDEF_NOM	CD
NOUN_NUM+NSUFF_FEM_SG+CASE_DEF_ACC	CD
NOUN_NUM+NSUFF_FEM_SG+CASE_DEF_GEN	CD
NOUN_NUM+NSUFF_FEM_SG+CASE_DEF_NOM	CD
NOUN_NUM+NSUFF_FEM_SG+CASE_INDEF_ACC	CD
NOUN_NUM+NSUFF_FEM_SG+CASE_INDEF_GEN	CD
NOUN_NUM+NSUFF_FEM_SG+CASE_INDEF_NOM	CD
NOUN_NUM+NSUFF_MASC_DU_ACCGEN_POSS	CD
NOUN_NUM+NSUFF_MASC_DU_ACC_POSS	CD
NOUN_NUM+NSUFF_MASC_DU_GEN	CD
NOUN_NUM+NSUFF_MASC_DU_GEN_POSS	CD
NOUN_NUM+NSUFF_MASC_DU_NOM	CD
NOUN_NUM+NSUFF_MASC_DU_NOM_POSS	CD
NOUN_NUM+NSUFF_MASC_PL_ACC	CD
NOUN_NUM+NSUFF_MASC_PL_ACCGEN	CD
NOUN_NUM+NSUFF_MASC_PL_ACC_POSS	CD
NOUN_NUM+NSUFF_MASC_PL_GEN	CD
NOUN_NUM+NSUFF_MASC_PL_NOM	CD
NOUN_PROP	NNP
NOUN_PROP+CASE_DEF_ACC	NNP
NOUN_PROP+CASE_DEF_GEN	NNP
NOUN_PROP+CASE_DEF_NOM	NNP
NOUN_PROP+CASE_INDEF_ACC	NNP
NOUN_PROP+CASE_INDEF_GEN	NNP
NOUN_PROP+CASE_INDEF_NOM	NNP
NOUN_PROP+NSUFF_FEM_PL+CASE_DEF_GEN	NNPS
NOUN_PROP+NSUFF_FEM_PL+CASE_INDEF_ACCGEN	NNPS
NOUN_PROP+NSUFF_FEM_PL+CASE_INDEF_GEN	NNPS
NOUN_PROP+NSUFF_FEM_SG	NNP
NOUN_PROP+NSUFF_FEM_SG+CASE_DEF_ACC	NNP
NOUN_PROP+NSUFF_FEM_SG+CASE_DEF_GEN	NNP
NOUN_PROP+NSUFF_FEM_SG+CASE_DEF_NOM	NNP
NOUN_PROP+NSUFF_FEM_SG+CASE_INDEF_ACC	NNP
NOUN_PROP+NSUFF_FEM_SG+CASE_INDEF_GEN	NNP
NOUN_PROP+NSUFF_FEM_SG+CASE_INDEF_NOM	NNP
NOUN_PROP+NSUFF_MASC_PL_GEN_POSS	NNPS
NOUN_PROP+NSUFF_MASC_PL_NOM	NNPS
NOUN_QUANT	NOUN_QUANT
NOUN_QUANT+CASE_DEF_ACC	NOUN_QUANT
NOUN_QUANT+CASE_DEF_GEN	NOUN_QUANT
NOUN_QUANT+CASE_DEF_NOM	NOUN_QUANT
NOUN_QUANT+CASE_INDEF_ACC	NOUN_QUANT
NOUN_QUANT+CASE_INDEF_GEN	NOUN_QUANT
NOUN_QUANT+CASE_INDEF_NOM	NOUN_QUANT
NOUN_QUANT+NSUFF_FEM_SG+CASE_DEF_ACC	NOUN_QUANT
NOUN_QUANT+NSUFF_FEM_SG+CASE_DEF_GEN	NOUN_QUANT
NOUN_QUANT+NSUFF_FEM_SG+CASE_DEF_NOM	NOUN_QUANT
NOUN_QUANT+NSUFF_FEM_SG+CASE_INDEF_ACC	NOUN_QUANT
NOUN_QUANT+NSUFF_FEM_SG+CASE_INDEF_GEN	NOUN_QUANT
NOUN_QUANT+NSUFF_MASC_DU_ACC_POSS	NOUN_QUANT
NOUN_QUANT+NSUFF_MASC_DU_GEN	NOUN_QUANT
NOUN_QUANT+NSUFF_MASC_DU_GEN_POSS	NOUN_QUANT
NOUN_QUANT+NSUFF_MASC_DU_NOM_POSS	NOUN_QUANT
NUMERIC_COMMA	PUNC
POSS_PRON_1P	PRP$
POSS_PRON_1S	PRP$
POSS_PRON_2FP	PRP$
POSS_PRON_2FS	PRP$
POSS_PRON_2MP	PRP$
POSS_PRON_2MS	PRP$
POSS_PRON_3D	PRP$
POSS_PRON_3FP	PRP$
POSS_PRON_3FS	PRP$
POSS_PRON_3MP	PRP$
POSS_PRON_3MS	PRP$
PREP	IN
PRON	PRP
PRON_1P	PRP
PRON_1S	PRP
PRON_2D	PRP
PRON_2FP	PRP
PRON_2FS	PRP
PRON_2MP	PRP
PRON_2MS	PRP
PRON_3D	PRP
PRON_3FP	PRP
PRON_3FS	PRP
PRON_3MP	PRP
PRON_3MS	PRP
PSEUDO_VERB	VBP
PV	VBD
PV+PVSUFF_3MS	VBD
PV+PVSUFF_SUBJ:1P	VBD
PV+PVSUFF_SUBJ:1S	VBD
PV+PVSUFF_SUBJ:2FS	VBD
PV+PVSUFF_SUBJ:2MP	VBD
PV+PVSUFF_SUBJ:2MS	VBD
PV+PVSUFF_SUBJ:3FD	VBD
PV+PVSUFF_SUBJ:3FP	VBD
PV+PVSUFF_SUBJ:3FS	VBD
PV+PVSUFF_SUBJ:3MD	VBD
PV+PVSUFF_SUBJ:3MP	VBD
PV+PVSUFF_SUBJ:3MS	VBD
PVSUFF_DO:1P	PRP
PVSUFF_DO:1S	PRP
PVSUFF_DO:2FS	PRP
PVSUFF_DO:2MP	PRP
PVSUFF_DO:2MS	PRP
PVSUFF_DO:3D	PRP
PVSUFF_DO:3FS	PRP
PVSUFF_DO:3MP	PRP
PVSUFF_DO:3MS	PRP
PV_PASS	VBN
PV_PASS+PVSUFF_SUBJ:1P	VBN
PV_PASS+PVSUFF_SUBJ:1S	VBN
PV_PASS+PVSUFF_SUBJ:3FD	VBN
PV_PASS+PVSUFF_SUBJ:3FP	VBN
PV_PASS+PVSUFF_SUBJ:3FS	VBN
PV_PASS+PVSUFF_SUBJ:3MD	VBN
PV_PASS+PVSUFF_SUBJ:3MP	VBN
PV_PASS+PVSUFF_SUBJ:3MS	VBN
REL_ADV	WRB
REL_PRON	WP
REL_PRON+CASE_DEF_ACC	WP
REL_PRON+CASE_DEF_GEN	WP
REL_PRON+CASE_DEF_NOM	WP
REL_PRON+CASE_INDEF_ACC	WP
REL_PRON+NSUFF_FEM_SG+CASE_DEF_GEN	WP
REL_PRON+NSUFF_MASC_SG_ACC_INDEF	WP
VERB	VBP
)
