/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.concurrent;

import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MulticoreWrapperTest {
    private MulticoreWrapper<Integer, Integer> wrapper;
    private int nThreads;

    @Before
    public void setUp() {
        this.nThreads = -1;
    }

    @Test
    public void testSynchronization() {
        this.wrapper = new MulticoreWrapper<Integer, Integer>(this.nThreads, new DelayedIdentityFunction());
        int lastReturned = 0;
        int nItems = 1000;
        for (int i = 0; i < 1000; ++i) {
            this.wrapper.put(i);
            while (this.wrapper.peek()) {
                int result = this.wrapper.poll();
                System.err.printf("Result: %d%n", result);
                Assert.assertEquals((long)result, (long)lastReturned++);
            }
        }
        this.wrapper.join();
        while (this.wrapper.peek()) {
            int result = this.wrapper.poll();
            System.err.printf("Result2: %d%n", result);
            Assert.assertEquals((long)result, (long)lastReturned++);
        }
    }

    @Test
    public void testUnsynchronized() {
        this.wrapper = new MulticoreWrapper<Integer, Integer>(this.nThreads, new DelayedIdentityFunction(), false);
        int nReturned = 0;
        int nItems = 1000;
        for (int i = 0; i < 1000; ++i) {
            this.wrapper.put(i);
            while (this.wrapper.peek()) {
                int result = this.wrapper.poll();
                System.err.printf("Result: %d%n", result);
                ++nReturned;
            }
        }
        this.wrapper.join();
        while (this.wrapper.peek()) {
            int result = this.wrapper.poll();
            System.err.printf("Result2: %d%n", result);
            ++nReturned;
        }
        Assert.assertEquals((long)1000L, (long)nReturned);
    }

    private static class DelayedIdentityFunction
    implements ThreadsafeProcessor<Integer, Integer> {
        private final Random random = new Random();
        private static final int MAX_SLEEP_TIME = 3;

        private DelayedIdentityFunction() {
        }

        @Override
        public Integer process(Integer input) {
            int sleepTime = this.nextSleepTime();
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return input;
        }

        private synchronized int nextSleepTime() {
            return this.random.nextInt(3);
        }

        @Override
        public ThreadsafeProcessor<Integer, Integer> newInstance() {
            return this;
        }
    }
}

