/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.concurrent;

import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.Factory;
import edu.stanford.nlp.util.concurrent.AtomicDouble;
import edu.stanford.nlp.util.logging.PrettyLogger;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentHashCounter<E>
implements Serializable,
Counter<E>,
Iterable<E> {
    private static final long serialVersionUID = -8077192206562696111L;
    private static final int DEFAULT_CAPACITY = 100;
    private final ConcurrentMap<E, AtomicDouble> map;
    private final AtomicDouble totalCount;
    private double defaultReturnValue = 0.0;

    public ConcurrentHashCounter() {
        this(100);
    }

    public ConcurrentHashCounter(int initialCapacity) {
        this.map = new ConcurrentHashMap<E, AtomicDouble>(initialCapacity);
        this.totalCount = new AtomicDouble();
    }

    @Override
    public Iterator<E> iterator() {
        return this.keySet().iterator();
    }

    @Override
    public Factory<Counter<E>> getFactory() {
        return new Factory<Counter<E>>(){
            private static final long serialVersionUID = 6076144467752914760L;

            @Override
            public Counter<E> create() {
                return new ConcurrentHashCounter();
            }
        };
    }

    @Override
    public void setDefaultReturnValue(double value) {
        this.defaultReturnValue = value;
    }

    @Override
    public double defaultReturnValue() {
        return this.defaultReturnValue;
    }

    @Override
    public double getCount(Object key) {
        AtomicDouble v = (AtomicDouble)this.map.get(key);
        return v == null ? this.defaultReturnValue : v.get();
    }

    @Override
    public void setCount(E key, double value) {
        double oldValue;
        block0: while (true) {
            AtomicDouble atomic;
            if ((atomic = (AtomicDouble)this.map.get(key)) == null && (atomic = this.map.putIfAbsent(key, new AtomicDouble(value))) == null) {
                this.totalCount.addAndGet(value);
                return;
            }
            do {
                if ((oldValue = atomic.get()) != 0.0) continue;
                if (!this.map.replace(key, atomic, new AtomicDouble(value))) continue block0;
                this.totalCount.addAndGet(value);
                return;
            } while (!atomic.compareAndSet(oldValue, value));
            break;
        }
        this.totalCount.addAndGet(value - oldValue);
    }

    @Override
    public double incrementCount(E key, double value) {
        double newValue;
        block0: while (true) {
            double oldValue;
            AtomicDouble atomic;
            if ((atomic = (AtomicDouble)this.map.get(key)) == null && (atomic = this.map.putIfAbsent(key, new AtomicDouble(value))) == null) {
                this.totalCount.addAndGet(value);
                return value;
            }
            do {
                if ((oldValue = atomic.get()) != 0.0) continue;
                if (!this.map.replace(key, atomic, new AtomicDouble(value))) continue block0;
                this.totalCount.addAndGet(value);
                return value;
            } while (!atomic.compareAndSet(oldValue, newValue = oldValue + value));
            break;
        }
        this.totalCount.addAndGet(value);
        return newValue;
    }

    @Override
    public double incrementCount(E key) {
        return this.incrementCount(key, 1.0);
    }

    @Override
    public double decrementCount(E key, double value) {
        return this.incrementCount(key, -value);
    }

    @Override
    public double decrementCount(E key) {
        return this.incrementCount(key, -1.0);
    }

    @Override
    public double logIncrementCount(E key, double value) {
        double newValue;
        block0: while (true) {
            double oldValue;
            AtomicDouble atomic;
            if ((atomic = (AtomicDouble)this.map.get(key)) == null && (atomic = this.map.putIfAbsent(key, new AtomicDouble(value))) == null) {
                this.totalCount.addAndGet(value);
                return value;
            }
            do {
                if ((oldValue = atomic.get()) != 0.0) continue;
                if (!this.map.replace(key, atomic, new AtomicDouble(value))) continue block0;
                this.totalCount.addAndGet(value);
                return value;
            } while (!atomic.compareAndSet(oldValue, newValue = SloppyMath.logAdd(oldValue, value)));
            break;
        }
        this.totalCount.addAndGet(value);
        return newValue;
    }

    @Override
    public void addAll(Counter<E> counter) {
        Counters.addInPlace(this, counter);
    }

    @Override
    public double remove(E key) {
        double oldValue;
        AtomicDouble atomic = (AtomicDouble)this.map.get(key);
        if (atomic == null) {
            return this.defaultReturnValue;
        }
        while ((oldValue = atomic.get()) != 0.0 && !atomic.compareAndSet(oldValue, 0.0)) {
        }
        this.map.remove(key, atomic);
        this.totalCount.addAndGet(-1.0 * oldValue);
        return oldValue;
    }

    @Override
    public boolean containsKey(E key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<E> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Collection<Double> values() {
        return new Collection<Double>(){

            @Override
            public int size() {
                return ConcurrentHashCounter.this.map.size();
            }

            @Override
            public boolean isEmpty() {
                return ConcurrentHashCounter.this.map.size() == 0;
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Double) {
                    double value = (Double)o;
                    for (AtomicDouble atomic : ConcurrentHashCounter.this.map.values()) {
                        if (atomic.get() != value) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Iterator<Double> iterator() {
                return new Iterator<Double>(){
                    Iterator<AtomicDouble> iterator;
                    {
                        this.iterator = ConcurrentHashCounter.this.map.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public Double next() {
                        return this.iterator.next().get();
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return ConcurrentHashCounter.this.map.values().toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return ConcurrentHashCounter.this.map.values().toArray(a);
            }

            @Override
            public boolean add(Double e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Double> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<Map.Entry<E, Double>> entrySet() {
        return new AbstractSet<Map.Entry<E, Double>>(){

            @Override
            public Iterator<Map.Entry<E, Double>> iterator() {
                return new Iterator<Map.Entry<E, Double>>(){
                    final Iterator<Map.Entry<E, AtomicDouble>> inner;
                    {
                        this.inner = ConcurrentHashCounter.this.map.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.inner.hasNext();
                    }

                    @Override
                    public Map.Entry<E, Double> next() {
                        return new Map.Entry<E, Double>(){
                            final Map.Entry<E, AtomicDouble> e;
                            {
                                this.e = inner.next();
                            }

                            @Override
                            public E getKey() {
                                return this.e.getKey();
                            }

                            @Override
                            public Double getValue() {
                                return this.e.getValue().get();
                            }

                            @Override
                            public Double setValue(Double value) {
                                double old = this.e.getValue().get();
                                ConcurrentHashCounter.this.setCount(this.e.getKey(), value);
                                this.e.getValue().set(value);
                                return old;
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ConcurrentHashCounter.this.map.size();
            }
        };
    }

    @Override
    public void clear() {
        do {
            this.totalCount.set(0.0);
        } while (this.totalCount.get() != 0.0);
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public double totalCount() {
        return this.totalCount.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConcurrentHashCounter)) {
            return false;
        }
        ConcurrentHashCounter other = (ConcurrentHashCounter)o;
        return this.totalCount.get() == other.totalCount.get() && this.map.equals(other.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public void prettyLog(Redwood.RedwoodChannels channels, String description) {
        PrettyLogger.log(channels, description, this.map);
    }
}

