/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Interval;
import junit.framework.TestCase;

public class IntervalTest
extends TestCase {
    private String toHexString(int n) {
        return String.format("%08x", n);
    }

    public void testIntervalOverlaps() throws Exception {
        Interval<Integer> i1_10 = Interval.toInterval(1, 10);
        Interval<Integer> i2_9 = Interval.toInterval(2, 9);
        Interval<Integer> i5_10 = Interval.toInterval(5, 10);
        Interval<Integer> i1_5 = Interval.toInterval(1, 5);
        Interval<Integer> i1_15 = Interval.toInterval(1, 15);
        Interval<Integer> i5_20 = Interval.toInterval(5, 20);
        Interval<Integer> i10_20 = Interval.toInterval(10, 20);
        Interval<Integer> i15_20 = Interval.toInterval(15, 20);
        Interval<Integer> i1_10b = Interval.toInterval(1, 10);
        IntervalTest.assertTrue((boolean)i1_10.overlaps(i2_9));
        IntervalTest.assertTrue((boolean)i1_10.overlaps(i5_10));
        IntervalTest.assertTrue((boolean)i1_10.overlaps(i1_5));
        IntervalTest.assertTrue((boolean)i1_10.overlaps(i1_15));
        IntervalTest.assertTrue((boolean)i1_10.overlaps(i5_20));
        IntervalTest.assertTrue((boolean)i1_10.overlaps(i10_20));
        IntervalTest.assertFalse((boolean)i1_10.overlaps(i15_20));
        IntervalTest.assertTrue((boolean)i1_10.overlaps(i1_10b));
        IntervalTest.assertTrue((boolean)i2_9.overlaps(i1_10));
        IntervalTest.assertTrue((boolean)i5_10.overlaps(i1_10));
        IntervalTest.assertTrue((boolean)i1_5.overlaps(i1_10));
        IntervalTest.assertTrue((boolean)i1_15.overlaps(i1_10));
        IntervalTest.assertTrue((boolean)i5_20.overlaps(i1_10));
        IntervalTest.assertTrue((boolean)i10_20.overlaps(i1_10));
        IntervalTest.assertFalse((boolean)i15_20.overlaps(i1_10));
        IntervalTest.assertTrue((boolean)i1_10b.overlaps(i1_10));
        int openFlags = 3;
        Interval<Integer> i1_10_open = Interval.toInterval(1, 10, openFlags);
        Interval<Integer> i2_9_open = Interval.toInterval(2, 9, openFlags);
        Interval<Integer> i5_10_open = Interval.toInterval(5, 10, openFlags);
        Interval<Integer> i1_5_open = Interval.toInterval(1, 5, openFlags);
        Interval<Integer> i1_15_open = Interval.toInterval(1, 15, openFlags);
        Interval<Integer> i5_20_open = Interval.toInterval(5, 20, openFlags);
        Interval<Integer> i10_20_open = Interval.toInterval(10, 20, openFlags);
        Interval<Integer> i15_20_open = Interval.toInterval(15, 20, openFlags);
        Interval<Integer> i1_10b_open = Interval.toInterval(1, 10, openFlags);
        IntervalTest.assertTrue((boolean)i1_10_open.overlaps(i2_9_open));
        IntervalTest.assertTrue((boolean)i1_10_open.overlaps(i5_10_open));
        IntervalTest.assertTrue((boolean)i1_10_open.overlaps(i1_5_open));
        IntervalTest.assertTrue((boolean)i1_10_open.overlaps(i1_15_open));
        IntervalTest.assertTrue((boolean)i1_10_open.overlaps(i5_20_open));
        IntervalTest.assertFalse((boolean)i1_10_open.overlaps(i10_20_open));
        IntervalTest.assertFalse((boolean)i1_10_open.overlaps(i15_20_open));
        IntervalTest.assertTrue((boolean)i1_10_open.overlaps(i1_10b_open));
        IntervalTest.assertTrue((boolean)i2_9_open.overlaps(i1_10_open));
        IntervalTest.assertTrue((boolean)i5_10_open.overlaps(i1_10_open));
        IntervalTest.assertTrue((boolean)i1_5_open.overlaps(i1_10_open));
        IntervalTest.assertTrue((boolean)i1_15_open.overlaps(i1_10_open));
        IntervalTest.assertTrue((boolean)i5_20_open.overlaps(i1_10_open));
        IntervalTest.assertFalse((boolean)i10_20_open.overlaps(i1_10_open));
        IntervalTest.assertFalse((boolean)i15_20_open.overlaps(i1_10_open));
        IntervalTest.assertTrue((boolean)i1_10b_open.overlaps(i1_10_open));
    }

    public void testIntervalContains() throws Exception {
        Interval<Integer> i1_10 = Interval.toInterval(1, 10);
        Interval<Integer> i2_9 = Interval.toInterval(2, 9);
        Interval<Integer> i5_10 = Interval.toInterval(5, 10);
        Interval<Integer> i1_5 = Interval.toInterval(1, 5);
        Interval<Integer> i1_15 = Interval.toInterval(1, 15);
        Interval<Integer> i5_20 = Interval.toInterval(5, 20);
        Interval<Integer> i10_20 = Interval.toInterval(10, 20);
        Interval<Integer> i15_20 = Interval.toInterval(15, 20);
        Interval<Integer> i1_10b = Interval.toInterval(1, 10);
        IntervalTest.assertTrue((boolean)i1_10.contains(i2_9));
        IntervalTest.assertTrue((boolean)i1_10.contains(i5_10));
        IntervalTest.assertTrue((boolean)i1_10.contains(i1_5));
        IntervalTest.assertFalse((boolean)i1_10.contains(i1_15));
        IntervalTest.assertFalse((boolean)i1_10.contains(i5_20));
        IntervalTest.assertFalse((boolean)i1_10.contains(i10_20));
        IntervalTest.assertFalse((boolean)i1_10.contains(i15_20));
        IntervalTest.assertTrue((boolean)i1_10.contains(i1_10b));
        IntervalTest.assertFalse((boolean)i2_9.contains(i1_10));
        IntervalTest.assertFalse((boolean)i5_10.contains(i1_10));
        IntervalTest.assertFalse((boolean)i1_5.contains(i1_10));
        IntervalTest.assertTrue((boolean)i1_15.contains(i1_10));
        IntervalTest.assertFalse((boolean)i5_20.contains(i1_10));
        IntervalTest.assertFalse((boolean)i10_20.contains(i1_10));
        IntervalTest.assertFalse((boolean)i15_20.contains(i1_10));
        IntervalTest.assertTrue((boolean)i1_10b.contains(i1_10));
        int openFlags = 3;
        Interval<Integer> i1_10_open = Interval.toInterval(1, 10, openFlags);
        Interval<Integer> i2_9_open = Interval.toInterval(2, 9, openFlags);
        Interval<Integer> i5_10_open = Interval.toInterval(5, 10, openFlags);
        Interval<Integer> i1_5_open = Interval.toInterval(1, 5, openFlags);
        Interval<Integer> i1_15_open = Interval.toInterval(1, 15, openFlags);
        Interval<Integer> i5_20_open = Interval.toInterval(5, 20, openFlags);
        Interval<Integer> i10_20_open = Interval.toInterval(10, 20, openFlags);
        Interval<Integer> i15_20_open = Interval.toInterval(15, 20, openFlags);
        Interval<Integer> i1_10b_open = Interval.toInterval(1, 10, openFlags);
        IntervalTest.assertTrue((boolean)i1_10_open.contains(i2_9_open));
        IntervalTest.assertTrue((boolean)i1_10_open.contains(i5_10_open));
        IntervalTest.assertTrue((boolean)i1_10_open.contains(i1_5_open));
        IntervalTest.assertFalse((boolean)i1_10_open.contains(i1_15_open));
        IntervalTest.assertFalse((boolean)i1_10_open.contains(i5_20_open));
        IntervalTest.assertFalse((boolean)i1_10_open.contains(i10_20_open));
        IntervalTest.assertFalse((boolean)i1_10_open.contains(i15_20_open));
        IntervalTest.assertTrue((boolean)i1_10_open.contains(i1_10b_open));
        IntervalTest.assertFalse((boolean)i2_9_open.contains(i1_10_open));
        IntervalTest.assertFalse((boolean)i5_10_open.contains(i1_10_open));
        IntervalTest.assertFalse((boolean)i1_5_open.contains(i1_10_open));
        IntervalTest.assertTrue((boolean)i1_15_open.contains(i1_10_open));
        IntervalTest.assertFalse((boolean)i5_20_open.contains(i1_10_open));
        IntervalTest.assertFalse((boolean)i10_20_open.contains(i1_10_open));
        IntervalTest.assertFalse((boolean)i15_20_open.contains(i1_10_open));
        IntervalTest.assertTrue((boolean)i1_10b_open.contains(i1_10_open));
        int openClosedFlags = 1;
        Interval<Integer> i1_10_openClosed = Interval.toInterval(1, 10, openClosedFlags);
        Interval<Integer> i2_9_openClosed = Interval.toInterval(2, 9, openClosedFlags);
        Interval<Integer> i5_10_openClosed = Interval.toInterval(5, 10, openClosedFlags);
        Interval<Integer> i1_5_openClosed = Interval.toInterval(1, 5, openClosedFlags);
        Interval<Integer> i1_10b_openClosed = Interval.toInterval(1, 10, openClosedFlags);
        int closedOpenFlags = 2;
        Interval<Integer> i1_10_closedOpen = Interval.toInterval(1, 10, closedOpenFlags);
        Interval<Integer> i2_9_closedOpen = Interval.toInterval(2, 9, closedOpenFlags);
        Interval<Integer> i5_10_closedOpen = Interval.toInterval(5, 10, closedOpenFlags);
        Interval<Integer> i1_5_closedOpen = Interval.toInterval(1, 5, closedOpenFlags);
        Interval<Integer> i1_10b_closedOpen = Interval.toInterval(1, 10, closedOpenFlags);
        IntervalTest.assertTrue((boolean)i1_10_closedOpen.contains(i2_9_openClosed));
        IntervalTest.assertTrue((boolean)i1_10.contains(i2_9_openClosed));
        IntervalTest.assertTrue((boolean)i1_10_openClosed.contains(i2_9_openClosed));
        IntervalTest.assertTrue((boolean)i1_10_closedOpen.contains(i2_9_closedOpen));
        IntervalTest.assertTrue((boolean)i1_10.contains(i2_9_closedOpen));
        IntervalTest.assertTrue((boolean)i1_10_openClosed.contains(i2_9_closedOpen));
        IntervalTest.assertFalse((boolean)i1_10_closedOpen.contains(i5_10_openClosed));
        IntervalTest.assertTrue((boolean)i1_10.contains(i5_10_openClosed));
        IntervalTest.assertTrue((boolean)i1_10_openClosed.contains(i5_10_openClosed));
        IntervalTest.assertTrue((boolean)i1_10_closedOpen.contains(i5_10_closedOpen));
        IntervalTest.assertTrue((boolean)i1_10.contains(i5_10_closedOpen));
        IntervalTest.assertTrue((boolean)i1_10_openClosed.contains(i5_10_closedOpen));
        IntervalTest.assertTrue((boolean)i1_10_closedOpen.contains(i1_5_openClosed));
        IntervalTest.assertTrue((boolean)i1_10.contains(i1_5_openClosed));
        IntervalTest.assertTrue((boolean)i1_10_openClosed.contains(i1_5_openClosed));
        IntervalTest.assertTrue((boolean)i1_10_closedOpen.contains(i1_5_closedOpen));
        IntervalTest.assertTrue((boolean)i1_10.contains(i1_5_closedOpen));
        IntervalTest.assertFalse((boolean)i1_10_openClosed.contains(i1_5_closedOpen));
        IntervalTest.assertTrue((boolean)i1_10_openClosed.contains(i1_10b_openClosed));
        IntervalTest.assertFalse((boolean)i1_10_openClosed.contains(i1_10b_closedOpen));
        IntervalTest.assertFalse((boolean)i1_10_closedOpen.contains(i1_10b_openClosed));
        IntervalTest.assertTrue((boolean)i1_10_closedOpen.contains(i1_10b_closedOpen));
    }

    public void testIntervalRelations() throws Exception {
        Interval<Integer> i1_10 = Interval.toInterval(1, 10);
        Interval<Integer> i2_9 = Interval.toInterval(2, 9);
        Interval<Integer> i5_10 = Interval.toInterval(5, 10);
        Interval<Integer> i1_5 = Interval.toInterval(1, 5);
        Interval<Integer> i1_15 = Interval.toInterval(1, 15);
        Interval<Integer> i5_20 = Interval.toInterval(5, 20);
        Interval<Integer> i10_20 = Interval.toInterval(10, 20);
        Interval<Integer> i15_20 = Interval.toInterval(15, 20);
        Interval<Integer> i1_10b = Interval.toInterval(1, 10);
        Interval.RelType rel = i1_10.getRelation(null);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.NONE), (Object)((Object)rel));
        int flags = i1_10.getRelationFlags(null);
        IntervalTest.assertEquals((int)0, (int)flags);
        rel = i1_10.getRelation(i2_9);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.CONTAIN), (Object)((Object)rel));
        flags = i1_10.getRelationFlags(i2_9);
        IntervalTest.assertEquals((String)this.toHexString(5260322), (String)this.toHexString(flags));
        rel = i1_10.getRelation(i1_5);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.CONTAIN), (Object)((Object)rel));
        flags = i1_10.getRelationFlags(i1_5);
        IntervalTest.assertEquals((String)this.toHexString(5260321), (String)this.toHexString(flags));
        rel = i1_10.getRelation(i1_15);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.INSIDE), (Object)((Object)rel));
        flags = i1_10.getRelationFlags(i1_15);
        IntervalTest.assertEquals((String)this.toHexString(3154977), (String)this.toHexString(flags));
        rel = i1_10.getRelation(i5_10);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.CONTAIN), (Object)((Object)rel));
        flags = i1_10.getRelationFlags(i5_10);
        IntervalTest.assertEquals((String)this.toHexString(5248034), (String)this.toHexString(flags));
        rel = i1_10.getRelation(i5_20);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.OVERLAP), (Object)((Object)rel));
        flags = i1_10.getRelationFlags(i5_20);
        IntervalTest.assertEquals((String)this.toHexString(1057826), (String)this.toHexString(flags));
        rel = i1_10.getRelation(i10_20);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.END_MEET_BEGIN), (Object)((Object)rel));
        flags = i1_10.getRelationFlags(i10_20);
        IntervalTest.assertEquals((String)this.toHexString(0x102122), (String)this.toHexString(flags));
        rel = i1_10.getRelation(i15_20);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.BEFORE), (Object)((Object)rel));
        flags = i1_10.getRelationFlags(i15_20);
        IntervalTest.assertEquals((String)this.toHexString(139810), (String)this.toHexString(flags));
        rel = i1_10.getRelation(i1_10b);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.EQUAL), (Object)((Object)rel));
        flags = i1_10.getRelationFlags(i1_10b);
        IntervalTest.assertEquals((String)this.toHexString(7410721), (String)this.toHexString(flags));
        rel = i2_9.getRelation(i1_10);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.INSIDE), (Object)((Object)rel));
        flags = i2_9.getRelationFlags(i1_10);
        IntervalTest.assertEquals((String)this.toHexString(3154980), (String)this.toHexString(flags));
        rel = i1_5.getRelation(i1_10);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.INSIDE), (Object)((Object)rel));
        flags = i1_5.getRelationFlags(i1_10);
        IntervalTest.assertEquals((String)this.toHexString(3154977), (String)this.toHexString(flags));
        rel = i1_15.getRelation(i1_10);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.CONTAIN), (Object)((Object)rel));
        flags = i1_15.getRelationFlags(i1_10);
        IntervalTest.assertEquals((String)this.toHexString(5260321), (String)this.toHexString(flags));
        rel = i5_10.getRelation(i1_10);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.INSIDE), (Object)((Object)rel));
        flags = i5_10.getRelationFlags(i1_10);
        IntervalTest.assertEquals((String)this.toHexString(3150884), (String)this.toHexString(flags));
        rel = i5_20.getRelation(i1_10);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.OVERLAP), (Object)((Object)rel));
        flags = i5_20.getRelationFlags(i1_10);
        IntervalTest.assertEquals((String)this.toHexString(1066020), (String)this.toHexString(flags));
        rel = i10_20.getRelation(i1_10);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.BEGIN_MEET_END), (Object)((Object)rel));
        flags = i10_20.getRelationFlags(i1_10);
        IntervalTest.assertEquals((String)this.toHexString(0x104414), (String)this.toHexString(flags));
        rel = i15_20.getRelation(i1_10);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.AFTER), (Object)((Object)rel));
        flags = i15_20.getRelationFlags(i1_10);
        IntervalTest.assertEquals((String)this.toHexString(279620), (String)this.toHexString(flags));
        rel = i1_10b.getRelation(i1_10);
        IntervalTest.assertEquals((Object)((Object)Interval.RelType.EQUAL), (Object)((Object)rel));
        flags = i1_10b.getRelationFlags(i1_10);
        IntervalTest.assertEquals((String)this.toHexString(7410721), (String)this.toHexString(flags));
    }
}

