/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.BijectiveFunction;
import java.util.function.Function;

public class Functions {
    private Functions() {
    }

    public static <T1, T2, T3> Function<T1, T3> compose(Function<T1, T2> f, Function<? super T2, T3> g) {
        return new ComposedFunction<T2, T1, T2>(f, g);
    }

    public static <T> Function<T, T> identityFunction() {
        return t -> t;
    }

    public static <T1, T2> BijectiveFunction<T2, T1> invert(BijectiveFunction<T1, T2> f) {
        if (f instanceof InvertedBijection) {
            return ((InvertedBijection)f).f;
        }
        return new InvertedBijection<T1, T2>(f);
    }

    private static class InvertedBijection<T1, T2>
    implements BijectiveFunction<T2, T1> {
        private final BijectiveFunction<T1, T2> f;

        InvertedBijection(BijectiveFunction<T1, T2> f) {
            this.f = f;
        }

        @Override
        public T1 apply(T2 in) {
            return this.f.unapply(in);
        }

        @Override
        public T2 unapply(T1 in) {
            return (T2)this.f.apply(in);
        }
    }

    private static class ComposedFunction<T1, T2, T3>
    implements Function<T1, T3> {
        Function<? super T2, T3> g;
        Function<T1, T2> f;

        public ComposedFunction(Function<? super T2, T3> g, Function<T1, T2> f) {
            this.g = g;
            this.f = f;
        }

        @Override
        public T3 apply(T1 t1) {
            return this.g.apply(this.f.apply(t1));
        }
    }
}

