/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayUtils;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class ArrayUtilsTest {
    private int[] sampleGaps = new int[]{1, 5, 6, 10, 17, 22, 29, 33, 100, 1000, 10000, 9999999};
    private int[] sampleBadGaps = new int[]{1, 6, 5, 10, 17};

    @Test
    public void testEqualContentsInt() {
        Assert.assertTrue((boolean)ArrayUtils.equalContents(this.sampleGaps, this.sampleGaps));
        Assert.assertTrue((boolean)ArrayUtils.equalContents(this.sampleBadGaps, this.sampleBadGaps));
        Assert.assertFalse((boolean)ArrayUtils.equalContents(this.sampleGaps, this.sampleBadGaps));
    }

    @Test
    public void testGaps() {
        byte[] encoded = ArrayUtils.gapEncode(this.sampleGaps);
        int[] decoded = ArrayUtils.gapDecode(encoded);
        Assert.assertTrue((boolean)ArrayUtils.equalContents(decoded, this.sampleGaps));
        try {
            ArrayUtils.gapEncode(this.sampleBadGaps);
            throw new RuntimeException("Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @Test
    public void testDelta() {
        byte[] encoded = ArrayUtils.deltaEncode(this.sampleGaps);
        int[] decoded = ArrayUtils.deltaDecode(encoded);
        Assert.assertTrue((boolean)ArrayUtils.equalContents(decoded, this.sampleGaps));
        try {
            ArrayUtils.deltaEncode(this.sampleBadGaps);
            throw new RuntimeException("Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @Test
    public void testRemoveAt() {
        Object[] strings = new String[]{"a", "b", "c"};
        strings = (String[])ArrayUtils.removeAt(strings, 2);
        int i = 0;
        for (Object string : strings) {
            if (i == 0) {
                Assert.assertEquals((Object)"a", (Object)string);
            } else if (i == 1) {
                Assert.assertEquals((Object)"b", (Object)string);
            } else {
                Assert.fail((String)"Array is too big!");
            }
            ++i;
        }
    }

    @Test
    public void testAsSet() {
        String[] items = new String[]{"larry", "moe", "curly"};
        HashSet<String> set = new HashSet<String>(Arrays.asList(items));
        Assert.assertEquals(set, ArrayUtils.asSet(items));
    }

    @Test
    public void testgetSubListIndex() {
        Object[] t1 = new String[]{"this", "is", "test"};
        Object[] t2 = new String[]{"well", "this", "is", "not", "this", "is", "test", "also"};
        Assert.assertEquals((long)4L, (long)ArrayUtils.getSubListIndex(t1, t2).get(0).intValue());
        Object[] t3 = new String[]{"cough", "increased"};
        Object[] t4 = new String[]{"i", "dont", "really", "cough"};
        Assert.assertEquals((long)0L, (long)ArrayUtils.getSubListIndex(t3, t4).size());
        Object[] t5 = new String[]{"cough", "increased"};
        Object[] t6 = new String[]{"cough", "aggravated"};
        Assert.assertEquals((long)0L, (long)ArrayUtils.getSubListIndex(t5, t6).size());
        Object[] t7 = new String[]{"cough", "increased"};
        Object[] t8 = new String[]{"cough", "aggravated", "cough", "increased", "and", "cough", "increased", "and", "cough", "and", "increased"};
        Assert.assertEquals((long)2L, (long)ArrayUtils.getSubListIndex(t7, t8).get(0).intValue());
        Assert.assertEquals((long)5L, (long)ArrayUtils.getSubListIndex(t7, t8).get(1).intValue());
    }
}

