/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class ArrayMapTest
extends TestCase {
    ArrayMap<String, Integer> map;
    HashMap<String, Integer> hmap;

    public void setUp() {
        this.map = new ArrayMap();
        this.hmap = new HashMap();
        this.map.put("Foo", 5);
        this.map.put("Bar", 50);
        this.map.put("Baz", 500);
        this.hmap.put("Foo", 5);
        this.hmap.put("Bar", 50);
        this.hmap.put("Baz", 500);
    }

    public void testEquals() {
        ArrayMapTest.assertEquals(this.map, this.map);
        ArrayMapTest.assertTrue((boolean)this.map.equals(this.map));
        ArrayMapTest.assertEquals(this.map, this.hmap);
        ArrayMapTest.assertEquals(this.hmap, this.map);
    }

    public void testClear() {
        ArrayMapTest.assertFalse((boolean)this.map.isEmpty());
        this.map.clear();
        ArrayMapTest.assertTrue((boolean)this.map.isEmpty());
        this.map.put("aaa", 5);
        ArrayMapTest.assertEquals((int)1, (int)this.map.size());
    }

    public void testPutAll() {
        this.map.clear();
        ArrayMapTest.assertTrue((boolean)this.map.isEmpty());
        this.map.putAll(this.hmap);
        this.testEquals();
        HashMap<String, Integer> newmap = new HashMap<String, Integer>();
        newmap.putAll(this.map);
        ArrayMapTest.assertEquals(newmap, this.map);
        ArrayMapTest.assertEquals(this.map, newmap);
    }

    public void testEntrySet() {
        Set<Map.Entry<String, Integer>> entries = this.map.entrySet();
        Map.Entry<String, Integer> entry = entries.iterator().next();
        entries.remove(entry);
        ArrayMapTest.assertFalse((boolean)this.map.containsKey(entry.getKey()));
        ArrayMapTest.assertEquals((int)2, (int)this.map.size());
        entries.clear();
        ArrayMapTest.assertEquals((int)0, (int)this.map.size());
        ArrayMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testValues() {
        HashSet<Integer> hmapValues = new HashSet<Integer>();
        hmapValues.addAll(this.hmap.values());
        HashSet mapValues = new HashSet();
        mapValues.addAll(this.map.values());
        ArrayMapTest.assertEquals(hmapValues, mapValues);
    }

    public void testPutDuplicateValues() {
        this.map.clear();
        this.map.put("Foo", 6);
        ArrayMapTest.assertEquals((int)6, (int)this.map.get("Foo"));
        ArrayMapTest.assertEquals((int)1, (int)this.map.size());
        this.map.put("Foo", 5);
        ArrayMapTest.assertEquals((int)5, (int)this.map.get("Foo"));
        ArrayMapTest.assertEquals((int)1, (int)this.map.size());
    }
}

