/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.trees.international.pennchinese.ChineseUtils;
import junit.framework.TestCase;

public class ChineseUtilsTest
extends TestCase {
    public void testNormalize() {
        String input = "Hello  \uff25\uff4e\uff47\uff4c\uff49\uff53\uff48 - \u4f60\u597d\u3000\u73ed\u6c49\u00b7\u897f\u5df4\u963f\u5dee\u3000Chris\u2022Manning \ud83e\udd16\ud83e\udd16robot";
        String outputLLL = "Hello  \uff25\uff4e\uff47\uff4c\uff49\uff53\uff48 - \u4f60\u597d\u3000\u73ed\u6c49\u00b7\u897f\u5df4\u963f\u5dee\u3000Chris\u2022Manning \ud83e\udd16\ud83e\udd16robot";
        String outputAAN = "Hello  English - \u4f60\u597d \u73ed\u6c49\u00b7\u897f\u5df4\u963f\u5dee Chris\u00b7Manning \ud83e\udd16\ud83e\udd16robot";
        String outputFFF = "\uff28\uff45\uff4c\uff4c\uff4f\u3000\u3000\uff25\uff4e\uff47\uff4c\uff49\uff53\uff48\u3000\uff0d\u3000\u4f60\u597d\u3000\u73ed\u6c49\u30fb\u897f\u5df4\u963f\u5dee\u3000\uff23\uff48\uff52\uff49\uff53\u30fb\uff2d\uff41\uff4e\uff4e\uff49\uff4e\uff47\u3000\ud83e\udd16\ud83e\udd16\uff52\uff4f\uff42\uff4f\uff54";
        ChineseUtilsTest.assertEquals((String)outputLLL, (String)ChineseUtils.normalize(input, 0, 0, 0));
        ChineseUtilsTest.assertEquals((String)outputAAN, (String)ChineseUtils.normalize(input, 1, 1, 1));
        ChineseUtilsTest.assertEquals((String)outputFFF, (String)ChineseUtils.normalize(input, 2, 2, 2));
    }
}

