/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureConversionUtils;
import edu.stanford.nlp.trees.PennTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalRelations;
import edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalStructure;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Pair;
import java.util.HashSet;
import junit.framework.TestCase;

public class ChineseGrammaticalStructureTest
extends TestCase {
    private static String C(String ... items) {
        StringBuilder out2 = new StringBuilder();
        for (String x : items) {
            out2.append(x);
            out2.append('\n');
        }
        return out2.toString();
    }

    private static Pair<String, String> T(String tree, String ans) {
        return new Pair<String, String>(tree, ans);
    }

    public void testBasicRelations() {
        Pair[] examples = (Pair[])ErasureUtils.uncheckedCast(new Pair[]{ChineseGrammaticalStructureTest.T("(NP (DNP (NP (NP (NR \u6d66\u4e1c)) (NP (NN \u5f00\u53d1))) (DEG \u7684)) (ADJP (JJ \u6709\u5e8f)) (NP (NN \u8fdb\u884c)))", ChineseGrammaticalStructureTest.C("nn(\u5f00\u53d1-2, \u6d66\u4e1c-1)", "assmod(\u8fdb\u884c-5, \u5f00\u53d1-2)", "assm(\u5f00\u53d1-2, \u7684-3)", "amod(\u8fdb\u884c-5, \u6709\u5e8f-4)", "root(ROOT-0, \u8fdb\u884c-5)")), ChineseGrammaticalStructureTest.T("(ROOT (IP (NP (NP (NR \u4e0a\u6d77) (NR \u6d66\u4e1c)) (NP (NN \u5f00\u53d1) (CC \u4e0e) (NN \u6cd5\u5236) (NN \u5efa\u8bbe))) (VP (VV \u540c\u6b65))))", ChineseGrammaticalStructureTest.C("nn(\u6d66\u4e1c-2, \u4e0a\u6d77-1)", "nn(\u5efa\u8bbe-6, \u6d66\u4e1c-2)", "conj(\u5efa\u8bbe-6, \u5f00\u53d1-3)", "cc(\u5efa\u8bbe-6, \u4e0e-4)", "nn(\u5efa\u8bbe-6, \u6cd5\u5236-5)", "nsubj(\u540c\u6b65-7, \u5efa\u8bbe-6)", "root(ROOT-0, \u540c\u6b65-7)")), ChineseGrammaticalStructureTest.T("(LCP (NP (NT \u8fd1\u5e74)) (LC \u6765))", ChineseGrammaticalStructureTest.C("lobj(\u6765-2, \u8fd1\u5e74-1)", "root(ROOT-0, \u6765-2)")), ChineseGrammaticalStructureTest.T("(PP (P \u6839\u636e) (NP (DNP (NP (NP (NN \u56fd\u5bb6)) (CC \u548c) (NP (NR \u4e0a\u6d77\u5e02))) (DEG \u7684)) (ADJP (JJ \u6709\u5173)) (NP (NN \u89c4\u5b9a))))", ChineseGrammaticalStructureTest.C("root(ROOT-0, \u6839\u636e-1)", "conj(\u4e0a\u6d77\u5e02-4, \u56fd\u5bb6-2)", "cc(\u4e0a\u6d77\u5e02-4, \u548c-3)", "assmod(\u89c4\u5b9a-7, \u4e0a\u6d77\u5e02-4)", "assm(\u4e0a\u6d77\u5e02-4, \u7684-5)", "amod(\u89c4\u5b9a-7, \u6709\u5173-6)", "pobj(\u6839\u636e-1, \u89c4\u5b9a-7)")), ChineseGrammaticalStructureTest.T("(IP (NP (NN \u5efa\u7b51)) (VP (VC \u662f) (NP (CP (IP (VP (VV \u5f00\u53d1) (NP (NR \u6d66\u4e1c)))) (DEC \u7684)) (QP (CD \u4e00) (CLP (M \u9879))) (ADJP (JJ \u4e3b\u8981)) (NP (NN \u7ecf\u6d4e) (NN \u6d3b\u52a8)))))", ChineseGrammaticalStructureTest.C("top(\u662f-2, \u5efa\u7b51-1)", "root(ROOT-0, \u662f-2)", "rcmod(\u6d3b\u52a8-10, \u5f00\u53d1-3)", "dobj(\u5f00\u53d1-3, \u6d66\u4e1c-4)", "cpm(\u5f00\u53d1-3, \u7684-5)", "nummod(\u9879-7, \u4e00-6)", "clf(\u6d3b\u52a8-10, \u9879-7)", "amod(\u6d3b\u52a8-10, \u4e3b\u8981-8)", "nn(\u6d3b\u52a8-10, \u7ecf\u6d4e-9)", "attr(\u662f-2, \u6d3b\u52a8-10)")), ChineseGrammaticalStructureTest.T("(IP (NP (NN \u954d)) (VP (SB \u88ab) (VP (VV \u79f0\u4f5c) (NP (PU \u201c) (DNP (NP (ADJP (JJ \u73b0\u4ee3)) (NP (NN \u5de5\u4e1a))) (DEG \u7684)) (NP (NN \u7ef4\u751f\u7d20)) (PU \u201d)))))", ChineseGrammaticalStructureTest.C("nsubjpass(\u79f0\u4f5c-3, \u954d-1)", "pass(\u79f0\u4f5c-3, \u88ab-2)", "root(ROOT-0, \u79f0\u4f5c-3)", "amod(\u5de5\u4e1a-6, \u73b0\u4ee3-5)", "assmod(\u7ef4\u751f\u7d20-8, \u5de5\u4e1a-6)", "assm(\u5de5\u4e1a-6, \u7684-7)", "dobj(\u79f0\u4f5c-3, \u7ef4\u751f\u7d20-8)")), ChineseGrammaticalStructureTest.T("(IP (VP (VP (ADVP (AD \u4e00)) (VP (VV \u51fa\u73b0))) (VP (ADVP (AD \u5c31)) (VP (SB \u88ab) (VP (VV \u7eb3\u5165) (NP (NN \u6cd5\u5236) (NN \u8f68\u9053)))))))))))", ChineseGrammaticalStructureTest.C("advmod(\u51fa\u73b0-2, \u4e00-1)", "root(ROOT-0, \u51fa\u73b0-2)", "advmod(\u7eb3\u5165-5, \u5c31-3)", "pass(\u7eb3\u5165-5, \u88ab-4)", "dep(\u51fa\u73b0-2, \u7eb3\u5165-5)", "nn(\u8f68\u9053-7, \u6cd5\u5236-6)", "dobj(\u7eb3\u5165-5, \u8f68\u9053-7)")), ChineseGrammaticalStructureTest.T("(IP (NP (NP (NR \u683c\u6797\u67ef\u5c14)) (NP (NN \u5236\u51b7\u5242)) (PRN (PU \uff08) (NP (NR \u4e2d\u56fd)) (PU \uff09)) (ADJP (JJ \u6709\u9650)) (NP (NN \u516c\u53f8))) (VP (VC \u662f) (NP (CP (CP (IP (NP (NP (NR \u683c\u6797\u67ef\u5c14) (NN \u96c6\u56e2) (NR \u5317\u7f8e) (NN \u516c\u53f8)) (CC \u4e0e) (NP (NP (NR \u4e2d\u56fd) (NR \u5929\u6d25)) (NP (NN \u5f00\u53d1\u533a)) (ADJP (JJ \u603b)) (NP (NN \u516c\u53f8))) (CC \u548c) (NP (NP (NR \u4e2d\u56fd)) (NP (NR \u5357\u65b9)) (NP (NN \u8bc1\u5238)) (ADJP (JJ \u6709\u9650)) (NP (NN \u516c\u53f8)))) (VP (VV \u5408\u5efa))) (DEC \u7684))) (ADJP (JJ \u5408\u8d44)) (NP (NN \u4f01\u4e1a)))) (PU \u3002))", ChineseGrammaticalStructureTest.C("nn(\u516c\u53f8-7, \u683c\u6797\u67ef\u5c14-1)", "nn(\u516c\u53f8-7, \u5236\u51b7\u5242-2)", "prnmod(\u516c\u53f8-7, \u4e2d\u56fd-4)", "amod(\u516c\u53f8-7, \u6709\u9650-6)", "top(\u662f-8, \u516c\u53f8-7)", "root(ROOT-0, \u662f-8)", "nn(\u516c\u53f8-12, \u683c\u6797\u67ef\u5c14-9)", "nn(\u516c\u53f8-12, \u96c6\u56e2-10)", "nn(\u516c\u53f8-12, \u5317\u7f8e-11)", "conj(\u516c\u53f8-24, \u516c\u53f8-12)", "cc(\u516c\u53f8-24, \u4e0e-13)", "nn(\u5929\u6d25-15, \u4e2d\u56fd-14)", "nn(\u516c\u53f8-18, \u5929\u6d25-15)", "nn(\u516c\u53f8-18, \u5f00\u53d1\u533a-16)", "amod(\u516c\u53f8-18, \u603b-17)", "conj(\u516c\u53f8-24, \u516c\u53f8-18)", "cc(\u516c\u53f8-24, \u548c-19)", "nn(\u516c\u53f8-24, \u4e2d\u56fd-20)", "nn(\u516c\u53f8-24, \u5357\u65b9-21)", "nn(\u516c\u53f8-24, \u8bc1\u5238-22)", "amod(\u516c\u53f8-24, \u6709\u9650-23)", "nsubj(\u5408\u5efa-25, \u516c\u53f8-24)", "rcmod(\u4f01\u4e1a-28, \u5408\u5efa-25)", "cpm(\u5408\u5efa-25, \u7684-26)", "amod(\u4f01\u4e1a-28, \u5408\u8d44-27)", "attr(\u662f-8, \u4f01\u4e1a-28)")), ChineseGrammaticalStructureTest.T("(IP (NP (ADJP (JJ \u6709\u5173)) (NP (NN \u90e8\u95e8))) (VP (ADVP (AD \u5148)) (VP (VV \u9001\u4e0a) (NP (DP (DT \u8fd9\u4e9b)) (NP (NN \u6cd5\u89c4\u6027) (NN \u6587\u4ef6))))) (PU \u3002))", ChineseGrammaticalStructureTest.C("amod(\u90e8\u95e8-2, \u6709\u5173-1)", "nsubj(\u9001\u4e0a-4, \u90e8\u95e8-2)", "advmod(\u9001\u4e0a-4, \u5148-3)", "root(ROOT-0, \u9001\u4e0a-4)", "det(\u6587\u4ef6-7, \u8fd9\u4e9b-5)", "nn(\u6587\u4ef6-7, \u6cd5\u89c4\u6027-6)", "dobj(\u9001\u4e0a-4, \u6587\u4ef6-7)"))});
        HashSet<String> testedRelations = new HashSet<String>();
        for (Pair ex : examples) {
            for (String item : ((String)ex.second).split("\n")) {
                testedRelations.add(item.substring(0, item.indexOf(40)));
            }
        }
        for (String relation : ChineseGrammaticalRelations.shortNameToGRel.keySet()) {
            if (testedRelations.contains(relation)) continue;
            System.out.println("WARNING: relation '" + relation + "' not tested");
        }
        PennTreeReaderFactory trf = new PennTreeReaderFactory();
        for (Pair ex : examples) {
            String testTree = (String)ex.first;
            String testAnswer = (String)ex.second;
            Tree tree = Tree.valueOf(testTree, trf);
            ChineseGrammaticalStructure gs = new ChineseGrammaticalStructure(tree);
            ChineseGrammaticalStructureTest.assertEquals((String)("Unexpected CC processed dependencies for tree " + testTree), (String)testAnswer, (String)GrammaticalStructureConversionUtils.dependenciesToString(gs, gs.typedDependenciesCCprocessed(GrammaticalStructure.Extras.MAXIMAL), tree, false, false, false));
        }
    }

    public static void main(String[] args) {
        new ChineseGrammaticalStructureTest().testBasicRelations();
    }
}

