/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.french;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.trees.AbstractCollinsHeadFinder;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.international.french.FrenchTreebankLanguagePack;
import edu.stanford.nlp.util.Generics;

public class AbishekFrenchHeadFinder
extends AbstractCollinsHeadFinder {
    private static final long serialVersionUID = -7195627297254128427L;

    public AbishekFrenchHeadFinder() {
        this(new FrenchTreebankLanguagePack());
    }

    public AbishekFrenchHeadFinder(FrenchTreebankLanguagePack tlp) {
        super(tlp, new String[0]);
        this.nonTerminalInfo = Generics.newHashMap();
        this.nonTerminalInfo.put(tlp.startSymbol(), new String[][]{{"left", "VN", "V", "NP", "Srel", "Ssub", "Sint"}});
        this.nonTerminalInfo.put("SENT", new String[][]{{"left", "VN", "V", "NP", "Srel", "Ssub", "Sint"}});
        this.nonTerminalInfo.put("AP", new String[][]{{"right", "A", "N", "V"}});
        this.nonTerminalInfo.put("AdP", new String[][]{{"right", "ADV"}, {"left", "P", "D", "C"}});
        this.nonTerminalInfo.put("COORD", new String[][]{{"left", "C"}, {"right"}});
        this.nonTerminalInfo.put("NP", new String[][]{{"right", "N", "PRO", "A", "ADV"}, {"left", "NP"}, {"right"}});
        this.nonTerminalInfo.put("PP", new String[][]{{"right", "P", "CL", "A", "ADV", "V", "N"}});
        this.nonTerminalInfo.put("VN", new String[][]{{"right", "V"}});
        this.nonTerminalInfo.put("VPinf", new String[][]{{"left", "VN", "V"}, {"right"}});
        this.nonTerminalInfo.put("VPpart", new String[][]{{"left", "VN", "V"}, {"right"}});
        this.nonTerminalInfo.put("Srel", new String[][]{{"left", "VN", "V"}});
        this.nonTerminalInfo.put("Ssub", new String[][]{{"left", "VN", "V"}, {"right"}});
        this.nonTerminalInfo.put("Sint", new String[][]{{"left", "VN", "V"}, {"right"}});
        this.nonTerminalInfo.put("MWD", new String[][]{{"left", "D"}, {"left"}});
        this.nonTerminalInfo.put("MWA", new String[][]{{"left", "P"}, {"left", "N"}, {"right", "A"}, {"right"}});
        this.nonTerminalInfo.put("MWC", new String[][]{{"left", "C", "CS"}, {"left"}});
        this.nonTerminalInfo.put("MWN", new String[][]{{"right", "N", "ET"}, {"right"}});
        this.nonTerminalInfo.put("MWV", new String[][]{{"left", "V"}, {"left"}});
        this.nonTerminalInfo.put("MWP", new String[][]{{"left", "P", "ADV", "PRO"}, {"left"}});
        this.nonTerminalInfo.put("MWPRO", new String[][]{{"left", "PRO", "CL", "N", "A"}, {"left"}});
        this.nonTerminalInfo.put("MWCL", new String[][]{{"left", "CL"}, {"right"}});
        this.nonTerminalInfo.put("MWADV", new String[][]{{"left", "P", "ADV"}, {"left"}});
        this.nonTerminalInfo.put("MWI", new String[][]{{"left", "N", "ADV", "P"}, {"left"}});
        this.nonTerminalInfo.put("MWET", new String[][]{{"left", "ET", "N"}, {"left"}});
        this.nonTerminalInfo.put("DUMMYP", new String[][]{{"left"}});
    }

    public static void main(String[] args) {
        DiskTreebank treebank = new DiskTreebank();
        CategoryWordTag.suppressTerminalDetails = true;
        treebank.loadPath(args[0]);
        AbishekFrenchHeadFinder chf = new AbishekFrenchHeadFinder();
        ((Treebank)treebank).apply(pt -> {
            pt.percolateHeads(chf);
            pt.pennPrint();
            System.out.println();
        });
    }
}

