/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeNormalizer;
import java.util.HashSet;
import junit.framework.TestCase;

public class TreeTest
extends TestCase {
    public void testTreeIterator() {
        Tree t = Tree.valueOf("(ROOT (S (NP (DT The) (ADJP (RB very) (JJ proud)) (NN woman)) (VP (VBD yawned) (ADVP (RB loudly))) (. .)))");
        if (t == null) {
            TreeTest.fail((String)"testTreeIterator failed to construct tree");
        }
        HashSet<Tree> m1 = new HashSet<Tree>();
        HashSet<Tree> m2 = new HashSet<Tree>();
        for (Tree sub : t) {
            m1.add(sub);
        }
        for (Tree sub : t.subTrees()) {
            m2.add(sub);
        }
        TreeTest.assertEquals(m1, m2);
    }

    public void testDeeperCopy() {
        Tree t1 = null;
        try {
            t1 = Tree.valueOf("(ROOT (S (NP I) (VP ran)))");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (t1 == null) {
            TreeTest.fail((String)"testDeeperCopy failed to construct tree");
        }
        Tree t2 = t1.deepCopy();
        TreeTest.assertEquals((Object)t1, (Object)t2);
        TreeTest.assertTrue((t1 != t2 ? 1 : 0) != 0);
        Label l1 = t1.firstChild().firstChild().firstChild().label();
        Label l2 = t2.firstChild().firstChild().firstChild().label();
        TreeTest.assertEquals((Object)l1, (Object)l2);
        TreeTest.assertTrue((l1 != l2 ? 1 : 0) != 0);
    }

    public void testRemove() {
        Tree t = Tree.valueOf("(ROOT (S (NP (DT The) (ADJP (RB very) (JJ proud)) (NN woman)) (VP (VBD yawned) (ADVP (RB loudly))) (. .)))");
        Tree kid = t.firstChild();
        try {
            t.remove(kid);
            TreeTest.fail((String)"Tree remove should be unimplemented.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            t.remove(kid);
            TreeTest.fail((String)"Tree removeAll should be unimplemented.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        kid.removeChild(0);
        TreeTest.assertEquals((String)"(ROOT (S (VP (VBD yawned) (ADVP (RB loudly))) (. .)))", (String)t.toString());
        t.removeChild(0);
        TreeTest.assertEquals((String)"ROOT", (String)t.toString());
    }

    public void testDominates() {
        Tree t = Tree.valueOf("(A (B this) (C (D is) (E a) (F small)) (G test))");
        TreeTest.assertFalse((boolean)t.dominates(t));
        for (Tree child : t.children()) {
            TreeTest.assertTrue((boolean)t.dominates(child));
            TreeTest.assertFalse((boolean)child.dominates(t));
        }
    }

    public void testPennPrint() {
        Tree t = Tree.valueOf("( (SBARQ (WHNP (WP What)) (SQ (VBP are) (NP (DT the) (NNP Valdez) (NNS Principles))) (. ?)))", new LabeledScoredTreeReaderFactory(new TreeNormalizer()));
        TreeTest.assertNull((String)"Root of tree should have null label if none in String", (Object)t.label().value());
        String separator = System.getProperty("line.separator");
        String answer = "( (SBARQ" + separator + "    (WHNP (WP What))" + separator + "    (SQ (VBP are)" + separator + "      (NP (DT the) (NNP Valdez) (NNS Principles)))" + separator + "    (. ?)))" + separator;
        TreeTest.assertEquals((String)answer, (String)t.pennString());
    }
}

