/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.QPTreeTransformer;
import edu.stanford.nlp.trees.Tree;
import junit.framework.TestCase;

public class QPTreeTransformerTest
extends TestCase {
    public void testMoney() {
        String input = "(ROOT (S (NP (DT This)) (VP (VBZ costs) (NP (QP ($ $) (CD 1) (CD million)))) (. .)))";
        String output = "(ROOT (S (NP (DT This)) (VP (VBZ costs) (NP (QP ($ $) (QP (CD 1) (CD million))))) (. .)))";
        QPTreeTransformerTest.runTest(input, output);
    }

    public void testMoneyOrMore() {
        String input = "(ROOT (S (NP (DT This)) (VP (VBZ costs) (NP (QP ($ $) (CD 1) (CD million) (CC or) (JJR more)))) (. .)))";
        String output = "(ROOT (S (NP (DT This)) (VP (VBZ costs) (NP (QP (QP ($ $) (QP (CD 1) (CD million))) (CC or) (NP (JJR more))))) (. .)))";
        QPTreeTransformerTest.runTest(input, output);
        input = "(ROOT (S (NP (DT This)) (VP (VBZ costs) (NP (QP ($ $) (CD 1) (CD million)) (QP (CC or) (JJR more)))) (. .)))";
        QPTreeTransformerTest.runTest(input, output);
    }

    public void testCompoundModifiers() {
        String input = "(ROOT (S (NP (NP (DT a) (NN stake)) (PP (IN of) (NP (QP (RB just) (IN under) (CD 30)) (NN %))))))";
        String output = "(ROOT (S (NP (NP (DT a) (NN stake)) (PP (IN of) (NP (QP (XS (RB just) (IN under)) (CD 30)) (NN %))))))";
        QPTreeTransformerTest.runTest(input, output);
    }

    private static void outputResults(String input, String output) {
        Tree inputTree = Tree.valueOf(input);
        System.err.println(inputTree);
        QPTreeTransformer qp = new QPTreeTransformer();
        Tree outputTree = qp.QPtransform(inputTree);
        System.err.println(outputTree);
        System.err.println(output);
    }

    private static void runTest(String input, String output) {
        Tree inputTree = Tree.valueOf(input);
        QPTreeTransformer qp = new QPTreeTransformer();
        Tree outputTree = qp.QPtransform(inputTree);
        QPTreeTransformerTest.assertEquals((String)output, (String)outputTree.toString());
    }
}

