/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.Tree;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public class FindTreebankTree {
    public static void main(String[] args) {
        String needle = "";
        String tagSeparator = "_";
        String encoding = "utf-8";
        String fileRegex = "";
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if ((args[i].equalsIgnoreCase("-tagSeparator") || args[i].equalsIgnoreCase("--tagSeparator")) && i + 1 < args.length) {
                tagSeparator = args[i + 1];
                ++i;
                continue;
            }
            if ((args[i].equalsIgnoreCase("-encoding") || args[i].equalsIgnoreCase("--encoding")) && i + 1 < args.length) {
                encoding = args[i + 1];
                ++i;
                continue;
            }
            if ((args[i].equalsIgnoreCase("-fileRegex") || args[i].equalsIgnoreCase("--fileRegex")) && i + 1 < args.length) {
                fileRegex = args[i + 1];
                ++i;
                continue;
            }
            if (needle.equals("")) {
                needle = args[i].trim();
                continue;
            }
            paths.add(args[i]);
        }
        LabeledScoredTreeReaderFactory trf = new LabeledScoredTreeReaderFactory();
        FileFilter filter = null;
        if (!fileRegex.equals("")) {
            Pattern filePattern = Pattern.compile(fileRegex);
            filter = pathname -> pathname.isDirectory() || filePattern.matcher(pathname.getName()).matches();
        }
        for (String path : paths) {
            DiskTreebank treebank = new DiskTreebank(trf, encoding);
            treebank.loadPath(path, filter);
            Iterator<Tree> treeIterator = treebank.iterator();
            int treeCount = 0;
            String currentFile = "";
            while (treeIterator.hasNext()) {
                if (!currentFile.equals(treebank.getCurrentFilename())) {
                    currentFile = treebank.getCurrentFilename();
                    treeCount = 0;
                }
                ++treeCount;
                Tree tree = treeIterator.next();
                ArrayList<TaggedWord> sentence = tree.taggedYield();
                boolean found = false;
                String haystack = SentenceUtils.listToString(sentence, true);
                found = needle.equals(haystack);
                haystack = haystack.replaceAll(" ", "");
                found = found || needle.equals(haystack);
                haystack = SentenceUtils.listToString(sentence, false, tagSeparator);
                if (!(found = found || needle.equals(haystack))) continue;
                System.out.println("needle found in " + currentFile + " tree " + treeCount);
            }
        }
    }
}

