/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.DataFilePaths;
import edu.stanford.nlp.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HeidelTimeKBPAnnotator
implements Annotator {
    private static final String BASE_PATH = "$NLP_DATA_HOME/packages/heideltime/";
    private static final String DEFAULT_PATH = DataFilePaths.convert("$NLP_DATA_HOME/packages/heideltime/");
    private final File heideltimePath;
    private final boolean outputResults;
    private final String language;
    private final HeidelTimeOutputReader outputReader = new HeidelTimeOutputReader();
    public static final String HEIDELTIME_PATH_PROPERTY = "heideltime.path";
    public static final String HEIDELTIME_LANGUAGE_PROPERTY = "heideltime.language";
    public static final String HEIDELTIME_OUTPUT_RESULTS = "heideltime.outputResults";
    private static final Map<String, String> TRANSLATE = new HashMap<String, String>(){
        {
            this.put("*NL*", "\n");
        }
    };

    public HeidelTimeKBPAnnotator() {
        this(new File(System.getProperty("heideltime", DEFAULT_PATH)));
    }

    public HeidelTimeKBPAnnotator(File heideltimePath) {
        this(heideltimePath, "english", false);
    }

    public HeidelTimeKBPAnnotator(File heideltimePath, String language, boolean outputResults) {
        this.heideltimePath = heideltimePath;
        this.outputResults = outputResults;
        this.language = language;
    }

    public HeidelTimeKBPAnnotator(String name, Properties props) {
        this.heideltimePath = new File(props.getProperty(HEIDELTIME_PATH_PROPERTY, System.getProperty("heideltime", DEFAULT_PATH)));
        this.outputResults = Boolean.valueOf(props.getProperty(HEIDELTIME_OUTPUT_RESULTS, "false"));
        this.language = props.getProperty(HEIDELTIME_LANGUAGE_PROPERTY, "english");
    }

    @Override
    public void annotate(Annotation annotation) {
        try {
            this.annotate((CoreMap)annotation);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void annotate(CoreMap document) throws IOException {
        try {
            File inputFile = File.createTempFile("heideltime", ".input");
            PrintWriter inputWriter = new PrintWriter(inputFile);
            this.prepareHeidelTimeInput(inputWriter, document);
            inputWriter.close();
            Optional<String> pubDate = this.getPubDate(document);
            ArrayList<String> args = new ArrayList<String>(Arrays.asList("java", "-jar", this.heideltimePath.getPath() + "/heideltime.jar", "-c", this.heideltimePath.getPath() + "/config.props", "-l", this.language, "-t", "NEWS"));
            if (pubDate.isPresent()) {
                args.add("-dct");
                args.add(pubDate.get());
            }
            args.add(inputFile.getPath());
            ProcessBuilder process = new ProcessBuilder(args);
            StringWriter outputWriter = new StringWriter();
            SystemUtils.run(process, outputWriter, null);
            String output = outputWriter.getBuffer().toString();
            List<CoreMap> timexAnns = this.outputReader.process(document, output);
            document.set(TimeAnnotations.TimexAnnotations.class, timexAnns);
            if (this.outputResults) {
                System.out.println(timexAnns);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("error running HeidelTime on this doc: " + (String)document.get(CoreAnnotations.DocIDAnnotation.class));
        }
    }

    private Optional<String> getPubDate(CoreMap document) {
        if (!document.containsKey(CoreAnnotations.CalendarAnnotation.class) && !document.containsKey(CoreAnnotations.DocDateAnnotation.class)) {
            throw new IllegalArgumentException("CoreMap must have either a Calendar or DocDate annotation");
        }
        Calendar dateCalendar = (Calendar)document.get(CoreAnnotations.CalendarAnnotation.class);
        if (dateCalendar != null) {
            return Optional.of(String.format("%TF", dateCalendar));
        }
        String s = (String)document.get(CoreAnnotations.DocDateAnnotation.class);
        if (s != null) {
            return Optional.of(s);
        }
        return Optional.empty();
    }

    private void prepareHeidelTimeInput(PrintWriter stream, CoreMap document) {
        for (CoreMap sentence : (List)document.get(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
                String text = token.originalText();
                stream.append(TRANSLATE.getOrDefault(text, text));
                stream.append(" ");
            }
            stream.append("\n");
        }
    }

    private static int beginOffset(CoreMap ann) {
        return (Integer)ann.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
    }

    private static int endOffset(CoreMap ann) {
        return (Integer)ann.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.SentencesAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(TimeAnnotations.TimexAnnotations.class);
    }

    static class HeidelTimeOutputReader {
        Pattern timeMLOpen = Pattern.compile(".*<TimeML>", 32);
        Pattern timeMLClose = Pattern.compile("</TimeML>.*", 32);
        Pattern timexTagOpen = Pattern.compile("<TIMEX3\\s*(?:(?:[a-z]+)=\"(?:[^\"]+)\"\\s*)*>");
        Pattern attr = Pattern.compile("(?<key>[a-z]+)=\"(?<value>[^\"]+)\"");
        Pattern timexTagClose = Pattern.compile("</TIMEX3>");

        HeidelTimeOutputReader() {
        }

        public List<CoreMap> process(CoreMap document, String output) {
            ArrayList<CoreMap> ret = new ArrayList<CoreMap>();
            List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
            List tokens = (List)document.get(CoreAnnotations.TokensAnnotation.class);
            List<Node> nodes = this.toNodeSequence(output);
            int tokenIdx = 0;
            int nodeIdx = 0;
            String partial = "";
            for (Node node : nodes) {
                String text = node.contents.trim();
                while (((CoreLabel)tokens.get(tokenIdx)).word().equals("*NL*") && tokenIdx < tokens.size()) {
                    ++tokenIdx;
                }
                int tokenEndIdx = tokenIdx;
                for (CoreLabel token : tokens.subList(tokenIdx, tokens.size())) {
                    if (text.length() == 0) break;
                    ++tokenEndIdx;
                    String matchStr = token.originalText().trim();
                    if (Objects.equals(matchStr, "*NL*")) continue;
                    if ((partial + text).startsWith(matchStr)) {
                        text = text.substring(matchStr.length() - partial.length()).trim();
                        partial = "";
                        continue;
                    }
                    if (matchStr.startsWith(partial + text)) {
                        partial = matchStr.substring(0, partial.length() + text.length());
                        text = "";
                        continue;
                    }
                    assert (false);
                }
                if (node instanceof TimexNode && ((CoreLabel)tokens.get(tokenIdx)).sentIndex() == ((CoreLabel)tokens.get(tokenEndIdx - 1)).sentIndex()) {
                    TimexNode timexNode = (TimexNode)node;
                    CoreMap sentence = (CoreMap)sentences.get(((CoreLabel)tokens.get(tokenIdx)).sentIndex());
                    ret.add(this.makeTimexMap(timexNode, tokens.subList(tokenIdx, tokenEndIdx), sentence));
                }
                tokenIdx = partial.length() > 0 ? tokenEndIdx - 1 : tokenEndIdx;
                ++nodeIdx;
            }
            return ret;
        }

        private CoreMap makeTimexMap(TimexNode node, List<CoreLabel> tokens, CoreMap sentence) {
            ArrayCoreMap timexMap = new ArrayCoreMap();
            timexMap.set(TimeAnnotations.TimexAnnotation.class, node.timex);
            timexMap.set(CoreAnnotations.TextAnnotation.class, node.contents);
            timexMap.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, HeidelTimeKBPAnnotator.beginOffset(tokens.get(0)));
            timexMap.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, HeidelTimeKBPAnnotator.endOffset(tokens.get(tokens.size() - 1)));
            timexMap.set(CoreAnnotations.TokenBeginAnnotation.class, tokens.get(0).index());
            timexMap.set(CoreAnnotations.TokenEndAnnotation.class, tokens.get(tokens.size() - 1).index());
            timexMap.set(CoreAnnotations.TokensAnnotation.class, tokens);
            if (sentence.get(TimeAnnotations.TimexAnnotations.class) == null) {
                sentence.set(TimeAnnotations.TimexAnnotations.class, new ArrayList());
            }
            ((List)sentence.get(TimeAnnotations.TimexAnnotations.class)).add(timexMap);
            for (CoreLabel token : tokens) {
                token.set(CoreAnnotations.NamedEntityTagAnnotation.class, "DATE");
                token.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, node.timex.value());
                token.set(TimeAnnotations.TimexAnnotation.class, node.timex);
            }
            return timexMap;
        }

        private List<Node> toNodeSequence(String output) {
            output = this.timeMLOpen.matcher(output).replaceAll("").trim();
            output = this.timeMLClose.matcher(output).replaceAll("").trim();
            Matcher openMatcher = this.timexTagOpen.matcher(output);
            Matcher attrMatcher = this.attr.matcher(output);
            Matcher closeMatcher = this.timexTagClose.matcher(output);
            ArrayList<Node> ret = new ArrayList<Node>();
            int charIdx = 0;
            HashMap<String, String> attrs = new HashMap<String, String>();
            while (openMatcher.find(charIdx)) {
                int tagBegin = openMatcher.start();
                int tagBeginEnd = openMatcher.end();
                if (charIdx < tagBegin) {
                    ret.add(new Node(output.substring(charIdx, tagBegin), charIdx, tagBegin));
                }
                attrs.clear();
                while (attrMatcher.find(tagBegin + 1) && attrMatcher.end() < tagBeginEnd) {
                    attrs.put(attrMatcher.group("key"), attrMatcher.group("value"));
                    tagBegin = attrMatcher.end();
                }
                boolean matched = closeMatcher.find(tagBeginEnd);
                assert (matched);
                int tagEndBegin = closeMatcher.start();
                int tagEnd = closeMatcher.end();
                String text = output.substring(tagBeginEnd, tagEndBegin);
                Timex timex = this.toTimex(text, attrs);
                ret.add(new TimexNode(text, tagBeginEnd, tagEndBegin, timex));
                charIdx = closeMatcher.end();
            }
            if (charIdx < output.length()) {
                ret.add(new Node(output.substring(charIdx, output.length()), charIdx, output.length()));
            }
            return ret;
        }

        private Timex toTimex(String text, Map<String, String> attrs) {
            String tid = attrs.get("tid");
            String val = attrs.getOrDefault("val", attrs.get("value"));
            String altVal = attrs.get("alTVal");
            String type = attrs.get("type");
            int beginPoint = Integer.parseInt(attrs.getOrDefault("beginpoint", "-1"));
            int endPoint = Integer.parseInt(attrs.getOrDefault("endpoint", "-1"));
            return new Timex(type, val, altVal, tid, text, beginPoint, endPoint);
        }

        public static class TimexNode
        extends Node {
            public final Timex timex;

            public TimexNode(String contents, int start, int end, Timex timex) {
                super(contents, start, end);
                this.timex = timex;
            }

            @Override
            public String toString() {
                return "[" + this.contents + "|TIMEX:" + this.timex + "]";
            }
        }

        public static class Node {
            public final String contents;
            public final int start;
            public final int end;

            public Node(String contents, int start, int end) {
                this.contents = contents;
                this.start = start;
                this.end = end;
            }

            public String toString() {
                return "[" + this.contents + "]";
            }
        }
    }
}

