/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.util;

import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.tagger.io.TaggedFileRecord;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.List;
import java.util.Properties;
import java.util.Random;

public class MakePrefixFile {
    private static Redwood.RedwoodChannels log = Redwood.channels(MakePrefixFile.class);

    public static void main(String[] args) {
        Properties config = StringUtils.argsToProperties(args);
        log.info(config);
        boolean fullSentence = PropertiesUtils.getBool(config, "fullSentence", false);
        Random random = new Random();
        String tagSeparator = config.getProperty("tagSeparator", "/");
        TaggedFileRecord record = TaggedFileRecord.createRecord(config, config.getProperty("input"));
        for (List sentence : record.reader()) {
            int len = random.nextInt(sentence.size()) + 1;
            System.out.println(SentenceUtils.listToString(sentence.subList(0, len), false, tagSeparator));
            if (!fullSentence) continue;
            System.out.println(SentenceUtils.listToString(sentence, false, tagSeparator));
        }
    }
}

