/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.TestClassifier;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;

public class MulticoreMaxentTaggerITest
extends TestCase {
    private static MaxentTagger singleTagger = null;
    private static MaxentTagger multiTagger = null;
    private static final String taggedText = "projects/core/data/edu/stanford/nlp/tagger/sample_tagged.txt";
    private static final String plainText = "projects/core/data/edu/stanford/nlp/tagger/sample_plain.txt";
    private static final String xmlText = "projects/core/data/edu/stanford/nlp/tagger/sample_xml.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Class<MulticoreMaxentTaggerITest> clazz = MulticoreMaxentTaggerITest.class;
        synchronized (MulticoreMaxentTaggerITest.class) {
            if (singleTagger == null) {
                singleTagger = new MaxentTagger("edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger");
            }
            if (multiTagger == null) {
                multiTagger = new MaxentTagger("edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger", StringUtils.argsToProperties("-model", "edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger", "-nthreads", "4"));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void testXML() throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(xmlText));
        StringWriter sout = new StringWriter();
        singleTagger.tagFromXML(is, (Writer)sout, "p");
        String singleOutput = sout.toString();
        is = new BufferedInputStream(new FileInputStream(xmlText));
        sout = new StringWriter();
        multiTagger.tagFromXML(is, (Writer)sout, "p");
        String multiOutput = sout.toString();
        MulticoreMaxentTaggerITest.assertEquals((String)singleOutput, (String)multiOutput);
    }

    public void testPlainText() throws IOException {
        BufferedReader bin = IOUtils.readerFromString(plainText, "utf-8");
        StringWriter sout = new StringWriter();
        BufferedWriter bout = new BufferedWriter(sout);
        singleTagger.runTagger(bin, bout, "", PlainTextDocumentReaderAndWriter.OutputStyle.SLASH_TAGS);
        bout.flush();
        String singleOutput = sout.toString();
        bin = IOUtils.readerFromString(plainText, "utf-8");
        sout = new StringWriter();
        bout = new BufferedWriter(sout);
        multiTagger.runTagger(bin, bout, "", PlainTextDocumentReaderAndWriter.OutputStyle.SLASH_TAGS);
        bout.flush();
        String multiOutput = sout.toString();
        MulticoreMaxentTaggerITest.assertEquals((String)singleOutput, (String)multiOutput);
    }

    public void testTagged() throws IOException {
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errStream = new ByteArrayOutputStream();
        PrintStream outPrint = new PrintStream(outStream);
        PrintStream errPrint = new PrintStream(errStream);
        System.setOut(outPrint);
        System.setErr(errPrint);
        TestClassifier tc = new TestClassifier(singleTagger, taggedText);
        outPrint.flush();
        errPrint.flush();
        String singleOutput = outStream.toString();
        outStream = new ByteArrayOutputStream();
        errStream = new ByteArrayOutputStream();
        outPrint = new PrintStream(outStream);
        errPrint = new PrintStream(errStream);
        System.setOut(outPrint);
        System.setErr(errPrint);
        tc = new TestClassifier(multiTagger, taggedText);
        outPrint.flush();
        errPrint.flush();
        String multiOutput = outStream.toString();
        MulticoreMaxentTaggerITest.assertEquals((String)singleOutput, (String)multiOutput);
        System.setOut(oldOut);
        System.setErr(oldErr);
    }
}

