/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Assert;

public class CountersTest
extends TestCase {
    private Counter<String> c1;
    private Counter<String> c2;
    private Counter<String> c8;
    private Counter<String> c9;
    private static final double TOLERANCE = 0.001;
    private final String[] ascending = new String[]{"e", "d", "a", "b", "c"};

    protected void setUp() {
        Locale.setDefault(Locale.US);
        this.c1 = new ClassicCounter<String>();
        this.c1.setCount("p", 1.0);
        this.c1.setCount("q", 2.0);
        this.c1.setCount("r", 3.0);
        this.c1.setCount("s", 4.0);
        this.c2 = new ClassicCounter<String>();
        this.c2.setCount("p", 5.0);
        this.c2.setCount("q", 6.0);
        this.c2.setCount("r", 7.0);
        this.c2.setCount("t", 8.0);
        this.c8 = new ClassicCounter<String>();
        this.c8.setCount("r", 2.0);
        this.c8.setCount("z", 4.0);
        this.c9 = new ClassicCounter<String>();
        this.c9.setCount("z", 4.0);
    }

    public void testUnion() {
        Counter<String> c3 = Counters.union(this.c1, this.c2);
        CountersTest.assertEquals((Object)c3.getCount("p"), (Object)6.0);
        CountersTest.assertEquals((Object)c3.getCount("s"), (Object)4.0);
        CountersTest.assertEquals((Object)c3.getCount("t"), (Object)8.0);
        CountersTest.assertEquals((Object)c3.totalCount(), (Object)36.0);
    }

    public void testIntersection() {
        Counter<String> c3 = Counters.intersection(this.c1, this.c2);
        CountersTest.assertEquals((Object)c3.getCount("p"), (Object)1.0);
        CountersTest.assertEquals((Object)c3.getCount("q"), (Object)2.0);
        CountersTest.assertEquals((Object)c3.getCount("s"), (Object)0.0);
        CountersTest.assertEquals((Object)c3.getCount("t"), (Object)0.0);
        CountersTest.assertEquals((Object)c3.totalCount(), (Object)6.0);
    }

    public void testProduct() {
        Counter<String> c3 = Counters.product(this.c1, this.c2);
        CountersTest.assertEquals((Object)c3.getCount("p"), (Object)5.0);
        CountersTest.assertEquals((Object)c3.getCount("q"), (Object)12.0);
        CountersTest.assertEquals((Object)c3.getCount("r"), (Object)21.0);
        CountersTest.assertEquals((Object)c3.getCount("s"), (Object)0.0);
        CountersTest.assertEquals((Object)c3.getCount("t"), (Object)0.0);
    }

    public void testDotProduct() {
        double d1 = Counters.dotProduct(this.c1, this.c2);
        CountersTest.assertEquals((Object)38.0, (Object)d1);
        double d2 = Counters.dotProduct(this.c1, this.c1);
        CountersTest.assertEquals((Object)30.0, (Object)d2);
        double d3 = Counters.optimizedDotProduct(this.c1, this.c2);
        CountersTest.assertEquals((Object)38.0, (Object)d3);
        double d4 = Counters.optimizedDotProduct(this.c1, this.c1);
        CountersTest.assertEquals((Object)30.0, (Object)d4);
        CountersTest.assertEquals((Object)14.0, (Object)Counters.optimizedDotProduct(this.c2, this.c8));
        CountersTest.assertEquals((Object)14.0, (Object)Counters.optimizedDotProduct(this.c8, this.c2));
        CountersTest.assertEquals((Object)0.0, (Object)Counters.optimizedDotProduct(this.c2, this.c9));
        CountersTest.assertEquals((Object)0.0, (Object)Counters.optimizedDotProduct(this.c9, this.c2));
    }

    public void testAbsoluteDifference() {
        Counter<String> c3 = Counters.absoluteDifference(this.c1, this.c2);
        CountersTest.assertEquals((Object)c3.getCount("p"), (Object)4.0);
        CountersTest.assertEquals((Object)c3.getCount("q"), (Object)4.0);
        CountersTest.assertEquals((Object)c3.getCount("r"), (Object)4.0);
        CountersTest.assertEquals((Object)c3.getCount("s"), (Object)4.0);
        CountersTest.assertEquals((Object)c3.getCount("t"), (Object)8.0);
        Counter<String> c4 = Counters.absoluteDifference(this.c2, this.c1);
        CountersTest.assertEquals((Object)c4.getCount("p"), (Object)4.0);
        CountersTest.assertEquals((Object)c4.getCount("q"), (Object)4.0);
        CountersTest.assertEquals((Object)c4.getCount("r"), (Object)4.0);
        CountersTest.assertEquals((Object)c4.getCount("s"), (Object)4.0);
        CountersTest.assertEquals((Object)c4.getCount("t"), (Object)8.0);
    }

    public void testSerialization() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(this.c1);
            byte[] bleh = bout.toByteArray();
            ByteArrayInputStream bin = new ByteArrayInputStream(bleh);
            ObjectInputStream oin = new ObjectInputStream(bin);
            ClassicCounter c3 = (ClassicCounter)oin.readObject();
            CountersTest.assertEquals((Object)c3, this.c1);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testMin() {
        CountersTest.assertEquals((Object)Counters.min(this.c1), (Object)1.0);
        CountersTest.assertEquals((Object)Counters.min(this.c2), (Object)5.0);
    }

    public void testArgmin() {
        CountersTest.assertEquals((String)Counters.argmin(this.c1), (String)"p");
        CountersTest.assertEquals((String)Counters.argmin(this.c2), (String)"p");
    }

    public void testL2Norm() {
        ClassicCounter<String> c = new ClassicCounter<String>();
        c.incrementCount("a", 3.0);
        c.incrementCount("b", 4.0);
        CountersTest.assertEquals((double)5.0, (double)Counters.L2Norm(c), (double)0.001);
        c.incrementCount("c", 6.0);
        c.incrementCount("d", 4.0);
        c.incrementCount("e", 2.0);
        CountersTest.assertEquals((double)9.0, (double)Counters.L2Norm(c), (double)0.001);
    }

    public void testLogNormalize() {
        ClassicCounter<String> c = new ClassicCounter<String>();
        c.incrementCount("a", Math.log(4.0));
        c.incrementCount("b", Math.log(2.0));
        c.incrementCount("c", Math.log(1.0));
        c.incrementCount("d", Math.log(1.0));
        Counters.logNormalizeInPlace(c);
        CountersTest.assertEquals((double)c.getCount("a"), (double)-0.693, (double)0.001);
        CountersTest.assertEquals((double)c.getCount("b"), (double)-1.386, (double)0.001);
        CountersTest.assertEquals((double)c.getCount("c"), (double)-2.079, (double)0.001);
        CountersTest.assertEquals((double)c.getCount("d"), (double)-2.079, (double)0.001);
        CountersTest.assertEquals((double)Counters.logSum(c), (double)0.0, (double)0.001);
    }

    public void testL2Normalize() {
        ClassicCounter<String> c = new ClassicCounter<String>();
        c.incrementCount("a", 4.0);
        c.incrementCount("b", 2.0);
        c.incrementCount("c", 1.0);
        c.incrementCount("d", 2.0);
        ClassicCounter d = Counters.L2Normalize(c);
        CountersTest.assertEquals((double)d.getCount("a"), (double)0.8, (double)0.001);
        CountersTest.assertEquals((double)d.getCount("b"), (double)0.4, (double)0.001);
        CountersTest.assertEquals((double)d.getCount("c"), (double)0.2, (double)0.001);
        CountersTest.assertEquals((double)d.getCount("d"), (double)0.4, (double)0.001);
    }

    public void testRetainAbove() {
        this.c1 = new ClassicCounter<String>();
        this.c1.incrementCount("a", 1.1);
        this.c1.incrementCount("b", 1.0);
        this.c1.incrementCount("c", 0.9);
        this.c1.incrementCount("d", 0.0);
        Set<String> removed = Counters.retainAbove(this.c1, 1.0);
        HashSet<String> expected = new HashSet<String>();
        expected.add("c");
        expected.add("d");
        CountersTest.assertEquals(expected, removed);
        CountersTest.assertEquals((Object)1.1, (Object)this.c1.getCount("a"));
        CountersTest.assertEquals((Object)1.0, (Object)this.c1.getCount("b"));
        CountersTest.assertFalse((boolean)this.c1.containsKey("c"));
        CountersTest.assertFalse((boolean)this.c1.containsKey("d"));
    }

    public void testToSortedList() {
        this.c1 = new ClassicCounter<String>();
        this.c1.incrementCount("a", 0.9);
        this.c1.incrementCount("b", 1.0);
        this.c1.incrementCount("c", 1.5);
        this.c1.incrementCount("d", 0.0);
        this.c1.incrementCount("e", -2.0);
        List<String> ascendList = Counters.toSortedList(this.c1, true);
        List<String> descendList = Counters.toSortedList(this.c1);
        for (int i = 0; i < this.ascending.length; ++i) {
            CountersTest.assertEquals((String)this.ascending[i], (String)ascendList.get(i));
            CountersTest.assertEquals((String)this.ascending[i], (String)descendList.get(this.ascending.length - i - 1));
        }
    }

    public void testRetainTop() {
        this.c1 = new ClassicCounter<String>();
        this.c1.incrementCount("a", 0.9);
        this.c1.incrementCount("b", 1.0);
        this.c1.incrementCount("c", 1.5);
        this.c1.incrementCount("d", 0.0);
        this.c1.incrementCount("e", -2.0);
        Counters.retainTop(this.c1, 3);
        CountersTest.assertEquals((int)3, (int)this.c1.size());
        CountersTest.assertTrue((boolean)this.c1.containsKey("a"));
        CountersTest.assertFalse((boolean)this.c1.containsKey("d"));
        Counters.retainTop(this.c1, 1);
        CountersTest.assertEquals((int)1, (int)this.c1.size());
        CountersTest.assertTrue((boolean)this.c1.containsKey("c"));
        CountersTest.assertEquals((Object)1.5, (Object)this.c1.getCount("c"));
    }

    public void testPointwiseMutualInformation() {
        ClassicCounter<String> x = new ClassicCounter<String>();
        x.incrementCount("0", 0.8);
        x.incrementCount("1", 0.2);
        ClassicCounter<Integer> y = new ClassicCounter<Integer>();
        y.incrementCount(0, 0.25);
        y.incrementCount(1, 0.75);
        ClassicCounter joint = new ClassicCounter();
        joint.incrementCount(new Pair<String, Integer>("0", 0), 0.1);
        joint.incrementCount(new Pair<String, Integer>("0", 1), 0.7);
        joint.incrementCount(new Pair<String, Integer>("1", 0), 0.15);
        joint.incrementCount(new Pair<String, Integer>("1", 1), 0.05);
        Pair<String, Integer> pair = new Pair<String, Integer>("0", 0);
        double pmi = Counters.pointwiseMutualInformation(x, y, joint, pair);
        CountersTest.assertEquals((double)-1.0, (double)pmi, (double)1.0E-4);
        pair = new Pair<String, Integer>("0", 1);
        pmi = Counters.pointwiseMutualInformation(x, y, joint, pair);
        CountersTest.assertEquals((double)0.222392421, (double)pmi, (double)1.0E-4);
        pair = new Pair<String, Integer>("1", 0);
        pmi = Counters.pointwiseMutualInformation(x, y, joint, pair);
        CountersTest.assertEquals((double)1.584962501, (double)pmi, (double)1.0E-4);
        pair = new Pair<String, Integer>("1", 1);
        pmi = Counters.pointwiseMutualInformation(x, y, joint, pair);
        CountersTest.assertEquals((double)-1.584962501, (double)pmi, (double)1.0E-4);
    }

    public void testToSortedString() {
        ClassicCounter<String> c = new ClassicCounter<String>();
        c.setCount("b", 0.25);
        c.setCount("a", 0.5);
        c.setCount("c", 1.0);
        String result = Counters.toSortedString(c, 5, "%s%.1f", ":", "{%s}");
        CountersTest.assertEquals((String)"{c1.0:a0.5:b0.3}", (String)result);
        result = Counters.toSortedString(c, 2, "%2$f %1$s", "\n");
        CountersTest.assertEquals((String)"1.000000 c\n0.500000 a", (String)result);
        int k = 2;
        result = Counters.toSortedString(c, k, "%s=%s", ", ", "[%s]");
        CountersTest.assertEquals((String)Counters.toString(c, k), (String)result);
        CountersTest.assertEquals((String)Counters.toBiggestValuesFirstString(c, k), (String)result);
        result = Counters.toSortedString(c, k, "%2$g\t%1$s", "\n", "%s\n");
        CountersTest.assertEquals((String)Counters.toVerticalString(c, k), (String)result);
        result = Counters.toSortedByKeysString(c, "%s=>%.2f", "; ", "<%s>");
        CountersTest.assertEquals((String)"<a=>0.50; b=>0.25; c=>1.00>", (String)result);
    }

    public void testHIndex() {
        ClassicCounter<String> c = new ClassicCounter<String>();
        CountersTest.assertEquals((int)0, (int)Counters.hIndex(c));
        c.setCount("X", 3.0);
        c.setCount("Y", 2.0);
        c.setCount("Z", 1.0);
        CountersTest.assertEquals((int)2, (int)Counters.hIndex(c));
        for (int i = 0; i < 14; ++i) {
            c.setCount(String.valueOf(i), 15.0);
        }
        CountersTest.assertEquals((int)14, (int)Counters.hIndex(c));
        c.setCount("15", 15.0);
        CountersTest.assertEquals((int)15, (int)Counters.hIndex(c));
    }

    public void testAddInPlaceCollection() {
        this.setUp();
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("p");
        collection.add("p");
        collection.add("s");
        Counters.addInPlace(this.c1, collection);
        CountersTest.assertEquals((Object)3.0, (Object)this.c1.getCount("p"));
        CountersTest.assertEquals((Object)5.0, (Object)this.c1.getCount("s"));
    }

    public void testRemoveKeys() {
        this.setUp();
        ArrayList<String> c = new ArrayList<String>();
        c.add("p");
        c.add("r");
        c.add("s");
        Counters.removeKeys(this.c1, c);
        CountersTest.assertEquals((int)this.c1.keySet().size(), (int)1);
        Object[] keys = this.c1.keySet().toArray();
        CountersTest.assertEquals((Object)keys[0], (Object)"q");
    }

    public void testRetainTopMass() {
        this.setUp();
        System.out.println(Counters.toString(this.c1, this.c1.size()));
        Counters.retainTopMass(this.c1, 3.0);
        CountersTest.assertEquals((Object)this.c1.keySet().toArray()[0], (Object)"s");
        CountersTest.assertEquals((int)this.c1.size(), (int)1);
    }

    public void testDivideInPlace() {
        TwoDimensionalCounter<String, String> a = new TwoDimensionalCounter<String, String>();
        a.setCount("a", "b", 1.0);
        a.setCount("a", "c", 1.0);
        a.setCount("c", "a", 1.0);
        a.setCount("c", "b", 1.0);
        Counters.divideInPlace(a, a.totalCount());
        CountersTest.assertEquals((Object)1.0, (Object)a.totalCount());
        CountersTest.assertEquals((Object)0.25, (Object)a.getCount("a", "b"));
    }

    public void testPearsonsCorrelationCoefficient() {
        this.setUp();
        Counters.pearsonsCorrelationCoefficient(this.c1, this.c2);
    }

    public void testToTiedRankCounter() {
        this.setUp();
        this.c1.setCount("t", 1.0);
        this.c1.setCount("u", 1.0);
        this.c1.setCount("v", 2.0);
        this.c1.setCount("z", 4.0);
        Counter<String> rank = Counters.toTiedRankCounter(this.c1);
        CountersTest.assertEquals((Object)1.5, (Object)rank.getCount("z"));
        CountersTest.assertEquals((Object)7.0, (Object)rank.getCount("t"));
    }

    public void testTransformWithValuesAdd() {
        this.setUp();
        this.c1.setCount("P", 2.0);
        System.out.println(this.c1);
        this.c1 = Counters.transformWithValuesAdd(this.c1, String::toLowerCase);
        System.out.println(this.c1);
    }

    public void testEquals() {
        this.setUp();
        this.c1.clear();
        this.c2.clear();
        this.c1.setCount("p", 1.0);
        this.c1.setCount("q", 2.0);
        this.c1.setCount("r", 3.0);
        this.c1.setCount("s", 4.0);
        this.c2.setCount("p", 1.0);
        this.c2.setCount("q", 2.0);
        this.c2.setCount("r", 3.0);
        this.c2.setCount("s", 4.0);
        CountersTest.assertTrue((boolean)Counters.equals(this.c1, this.c2));
        this.c2.setCount("s", 4.1);
        CountersTest.assertFalse((boolean)Counters.equals(this.c1, this.c2));
        this.c2.remove("s");
        CountersTest.assertFalse((boolean)Counters.equals(this.c1, this.c2));
        this.c2.setCount("s", 4.0000000001);
        CountersTest.assertFalse((boolean)Counters.equals(this.c1, this.c2));
        CountersTest.assertTrue((boolean)Counters.equals(this.c1, this.c2, 1.0E-5));
        this.c2.setCount("2", 3.00008);
        this.c2.setCount("s", 4.00008);
        CountersTest.assertFalse((boolean)Counters.equals(this.c1, this.c2, 1.0E-5));
    }

    public void testJensenShannonDivergence() {
        ClassicCounter<String> a = new ClassicCounter<String>();
        a.setCount("a", 1.0);
        a.setCount("b", 1.0);
        a.setCount("c", 7.0);
        a.setCount("d", 1.0);
        ClassicCounter<String> b = new ClassicCounter<String>();
        b.setCount("b", 1.0);
        b.setCount("c", 1.0);
        b.setCount("d", 7.0);
        b.setCount("e", 1.0);
        b.setCount("f", 0.0);
        CountersTest.assertEquals((double)0.46514844544032313, (double)Counters.jensenShannonDivergence(a, b), (double)1.0E-5);
        ClassicCounter<String> c = new ClassicCounter<String>(Collections.singletonList("A"));
        ClassicCounter<String> d = new ClassicCounter<String>(Arrays.asList("B", "C"));
        CountersTest.assertEquals((double)1.0, (double)Counters.jensenShannonDivergence(c, d), (double)1.0E-5);
    }

    public void testFlatten() {
        HashMap h = new HashMap();
        ClassicCounter<String> a = new ClassicCounter<String>();
        a.setCount("a", 1.0);
        a.setCount("b", 1.0);
        a.setCount("c", 7.0);
        a.setCount("d", 1.0);
        ClassicCounter<String> b = new ClassicCounter<String>();
        b.setCount("b", 1.0);
        b.setCount("c", 1.0);
        b.setCount("d", 7.0);
        b.setCount("e", 1.0);
        b.setCount("f", 1.0);
        h.put("first", a);
        h.put("second", b);
        Counter flat = Counters.flatten(h);
        CountersTest.assertEquals((int)6, (int)flat.size());
        CountersTest.assertEquals((Object)2.0, (Object)flat.getCount("b"));
    }

    public void testSerializeStringCounter() throws IOException {
        ClassicCounter<String> counts = new ClassicCounter<String>();
        for (int base = -10; base < 10; ++base) {
            if (base == 0) continue;
            for (int exponent = -100; exponent < 100; ++exponent) {
                double number = Math.pow(Math.PI * (double)base, exponent);
                counts.setCount(Double.toString(number), number);
            }
        }
        File tmp = File.createTempFile("counts", ".tab.gz");
        tmp.deleteOnExit();
        Counters.serializeStringCounter(counts, tmp.getPath());
        ClassicCounter<String> reread = Counters.deserializeStringCounter(tmp.getPath());
        for (Map.Entry entry : reread.entrySet()) {
            double old = counts.getCount(entry.getKey());
            CountersTest.assertEquals((double)old, (double)entry.getValue(), (double)(Math.abs(old) / 100000.0));
        }
    }
}

