/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.GermanDocument;
import edu.stanford.nlp.simple.Sentence;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class GermanSentence
extends Sentence {
    static Properties SINGLE_SENTENCE_DOCUMENT = new Properties(){
        {
            try (InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-german.properties");){
                this.load(is);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.setProperty("language", "german");
            this.setProperty("annotators", "");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "PTBTokenizer");
            this.setProperty("tokenize.language", "de");
        }
    };
    private static Properties SINGLE_SENTENCE_TOKENIZED_DOCUMENT = new Properties(){
        {
            try (InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-german.properties");){
                this.load(is);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.setProperty("language", "german");
            this.setProperty("annotators", "");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "WhitespaceTokenizer");
            this.setProperty("tokenize.language", "de");
            this.setProperty("tokenize.whitespace", "true");
        }
    };

    public GermanSentence(String text) {
        super((Document)new GermanDocument(text), SINGLE_SENTENCE_DOCUMENT);
    }

    public GermanSentence(List<String> tokens) {
        super(GermanDocument::new, tokens, SINGLE_SENTENCE_TOKENIZED_DOCUMENT);
    }

    public GermanSentence(CoreNLPProtos.Sentence proto) {
        super(GermanDocument::new, proto, SINGLE_SENTENCE_DOCUMENT);
    }
}

