/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.simple.ChineseDocument;
import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.simple.Sentence;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class ChineseSentence
extends Sentence {
    static Properties SINGLE_SENTENCE_DOCUMENT = new Properties(){
        {
            try (InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-chinese.properties");){
                this.load(is);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.setProperty("language", "chinese");
            this.setProperty("annotators", "");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "PTBTokenizer");
            this.setProperty("tokenize.language", "zh");
        }
    };
    private static Properties SINGLE_SENTENCE_TOKENIZED_DOCUMENT = new Properties(){
        {
            try (InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem("edu/stanford/nlp/pipeline/StanfordCoreNLP-chinese.properties");){
                this.load(is);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.setProperty("language", "chinese");
            this.setProperty("annotators", "");
            this.setProperty("ssplit.isOneSentence", "true");
            this.setProperty("tokenize.class", "WhitespaceTokenizer");
            this.setProperty("tokenize.language", "zh");
            this.setProperty("tokenize.whitespace", "true");
        }
    };

    public ChineseSentence(String text) {
        super((Document)new ChineseDocument(text), SINGLE_SENTENCE_DOCUMENT);
    }

    public ChineseSentence(List<String> tokens) {
        super(ChineseDocument::new, tokens, SINGLE_SENTENCE_TOKENIZED_DOCUMENT);
    }

    public ChineseSentence(CoreNLPProtos.Sentence proto) {
        super(ChineseDocument::new, proto, SINGLE_SENTENCE_DOCUMENT);
    }
}

