/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.objectbank.ReaderIteratorFactory;
import edu.stanford.nlp.sequences.ObjectBankWrapper;
import edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class ObjectBankWrapperTest {
    @Test
    public void testUsingIterator() {
        String s = "\n\n@@123\nthis\nis\na\nsentence\n\n@@12\nThis\nis another\n.\n\n";
        String[] output = new String[]{"@@", "123", "this", "is", "a", "sentence", "@@", "12", "This", "is", "another", "."};
        String[] outWSs = new String[]{"@@", "ddd", "xxxx", "xx", "x", "xxxxx", "@@", "dd", "Xxxx", "xx", "xxxxx", "."};
        Assert.assertEquals((String)"Two output arrays should have same length", (long)output.length, (long)outWSs.length);
        Properties props = PropertiesUtils.asProperties("wordShape", "chris2");
        SeqClassifierFlags flags = new SeqClassifierFlags(props);
        PlainTextDocumentReaderAndWriter readerAndWriter = new PlainTextDocumentReaderAndWriter();
        readerAndWriter.init(flags);
        ReaderIteratorFactory rif = new ReaderIteratorFactory(new StringReader(s));
        ObjectBank di = new ObjectBank(rif, readerAndWriter);
        HashSet<String> knownLCWords = new HashSet<String>();
        ObjectBankWrapper obw = new ObjectBankWrapper(flags, di, knownLCWords);
        try {
            int outIdx = 0;
            for (List sent : obw) {
                for (CoreLabel cl : sent) {
                    String tok = cl.word();
                    String shape = (String)cl.get(CoreAnnotations.ShapeAnnotation.class);
                    Assert.assertEquals((Object)output[outIdx], (Object)tok);
                    Assert.assertEquals((Object)outWSs[outIdx], (Object)shape);
                    ++outIdx;
                }
            }
            if (outIdx < output.length) {
                Assert.fail((String)("Too few things in iterator, lacking: " + output[outIdx]));
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Probably too many things in iterator: " + e));
        }
    }

    @Test
    public void testUsingEnhancedFor() {
        String s = "\n\n@@123\nthis\nis\na\nsentence\n\n@@12\nThis\nis another\n.\n\n";
        String[] output = new String[]{"@@", "123", "this", "is", "a", "sentence", "@@", "12", "This", "is", "another", "."};
        String[] outWSs = new String[]{"@@", "ddd", "xxxx", "xx", "x", "xxxxx", "@@", "dd", "Xxxx", "xx", "xxxxx", "."};
        Assert.assertEquals((String)"Two output arrays should have same length", (long)output.length, (long)outWSs.length);
        Properties props = PropertiesUtils.asProperties("wordShape", "chris2");
        SeqClassifierFlags flags = new SeqClassifierFlags(props);
        PlainTextDocumentReaderAndWriter readerAndWriter = new PlainTextDocumentReaderAndWriter();
        readerAndWriter.init(flags);
        ReaderIteratorFactory rif = new ReaderIteratorFactory(new StringReader(s));
        ObjectBank di = new ObjectBank(rif, readerAndWriter);
        HashSet<String> knownLCWords = new HashSet<String>();
        ObjectBankWrapper obw = new ObjectBankWrapper(flags, di, knownLCWords);
        try {
            int outIdx = 0;
            for (List sent : obw) {
                for (CoreLabel cl : sent) {
                    String tok = cl.word();
                    String shape = (String)cl.get(CoreAnnotations.ShapeAnnotation.class);
                    Assert.assertEquals((Object)output[outIdx], (Object)tok);
                    Assert.assertEquals((Object)outWSs[outIdx], (Object)shape);
                    ++outIdx;
                }
            }
            if (outIdx < output.length) {
                Assert.fail((String)("Too few things in iterator, lacking: " + output[outIdx]));
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Probably too many things in iterator." + e));
        }
    }

    @Test
    public void testUsingToArray() {
        String s = "\n\n@@123\nthis\nis\na\nsentence\n\n@@12\nThis\nis another\n.\n\n";
        String[] output = new String[]{"@@", "123", "this", "is", "a", "sentence", "@@", "12", "This", "is", "another", "."};
        String[] outWSs = new String[]{"@@", "ddd", "xxxx", "xx", "x", "xxxxx", "@@", "dd", "Xxxx", "xx", "xxxxx", "."};
        Assert.assertEquals((String)"Two output arrays should have same length", (long)output.length, (long)outWSs.length);
        Properties props = PropertiesUtils.asProperties("wordShape", "chris2");
        SeqClassifierFlags flags = new SeqClassifierFlags(props);
        PlainTextDocumentReaderAndWriter readerAndWriter = new PlainTextDocumentReaderAndWriter();
        readerAndWriter.init(flags);
        ReaderIteratorFactory rif = new ReaderIteratorFactory(new StringReader(s));
        ObjectBank di = new ObjectBank(rif, readerAndWriter);
        HashSet<String> knownLCWords = new HashSet<String>();
        ObjectBankWrapper obw = new ObjectBankWrapper(flags, di, knownLCWords);
        try {
            List[] sents = obw.toArray(new List[0]);
            int outIdx = 0;
            for (List sent : sents) {
                for (CoreLabel cl : sent) {
                    String tok = cl.word();
                    String shape = (String)cl.get(CoreAnnotations.ShapeAnnotation.class);
                    Assert.assertEquals((Object)output[outIdx], (Object)tok);
                    Assert.assertEquals((Object)outWSs[outIdx], (Object)shape);
                    ++outIdx;
                }
            }
            if (outIdx < output.length) {
                Assert.fail((String)("Too few things in iterator, lacking: " + output[outIdx]));
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Probably too many things in iterator: " + e));
        }
    }
}

