/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.sequences.BestSequenceFinder;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import java.util.Arrays;

public class KBestSequenceFinder
implements BestSequenceFinder {
    @Override
    public int[] bestSequence(SequenceModel ts) {
        return Counters.argmax(this.kBestSequences(ts, 1));
    }

    public Counter<int[]> kBestSequences(SequenceModel ts, int k) {
        int pos;
        int length = ts.length();
        int leftWindow = ts.leftWindow();
        int rightWindow = ts.rightWindow();
        if (rightWindow != 0) {
            throw new IllegalArgumentException("KBestSequenceFinder only works with rightWindow == 0 not " + rightWindow);
        }
        int padLength = length + leftWindow + rightWindow;
        int[][] tags = new int[padLength][];
        int[] tagNum = new int[padLength];
        for (int pos2 = 0; pos2 < padLength; ++pos2) {
            tags[pos2] = ts.getPossibleValues(pos2);
            tagNum[pos2] = tags[pos2].length;
        }
        int[] tempTags = new int[padLength];
        int[] productSizes = new int[padLength];
        int curProduct = 1;
        for (int i = 0; i < leftWindow; ++i) {
            curProduct *= tagNum[i];
        }
        for (int pos3 = leftWindow; pos3 < padLength; ++pos3) {
            if (pos3 > leftWindow + rightWindow) {
                curProduct /= tagNum[pos3 - leftWindow - rightWindow - 1];
            }
            productSizes[pos3 - rightWindow] = curProduct *= tagNum[pos3];
        }
        double[][] windowScore = new double[padLength][];
        for (int pos4 = leftWindow; pos4 < leftWindow + length; ++pos4) {
            windowScore[pos4] = new double[productSizes[pos4]];
            Arrays.fill(tempTags, tags[0][0]);
            for (int product = 0; product < productSizes[pos4]; ++product) {
                int p = product;
                int shift = 1;
                for (int curPos = pos4; curPos >= pos4 - leftWindow; --curPos) {
                    tempTags[curPos] = tags[curPos][p % tagNum[curPos]];
                    p /= tagNum[curPos];
                    if (curPos <= pos4) continue;
                    shift *= tagNum[curPos];
                }
                if (tempTags[pos4] != tags[pos4][0]) continue;
                double[] scores = ts.scoresOf(tempTags, pos4);
                for (int t = 0; t < tagNum[pos4]; ++t) {
                    windowScore[pos4][product + t * shift] = scores[t];
                }
            }
        }
        double[][][] score = new double[padLength][][];
        int[][][][] trace = new int[padLength][][][];
        int[][] numWaysToMake = new int[padLength][];
        for (pos = 0; pos < padLength; ++pos) {
            score[pos] = new double[productSizes[pos]][];
            trace[pos] = new int[productSizes[pos]][][];
            numWaysToMake[pos] = new int[productSizes[pos]];
            Arrays.fill(numWaysToMake[pos], 1);
            for (int product = 0; product < productSizes[pos]; ++product) {
                if (pos > leftWindow) {
                    int sharedProduct = product / tagNum[pos];
                    int factor = productSizes[pos] / tagNum[pos];
                    numWaysToMake[pos][product] = 0;
                    for (int newTagNum = 0; newTagNum < tagNum[pos - leftWindow - 1] && numWaysToMake[pos][product] < k; ++newTagNum) {
                        int predProduct = newTagNum * factor + sharedProduct;
                        int[] nArray = numWaysToMake[pos];
                        int n = product;
                        nArray[n] = nArray[n] + numWaysToMake[pos - 1][predProduct];
                    }
                    if (numWaysToMake[pos][product] > k) {
                        numWaysToMake[pos][product] = k;
                    }
                }
                score[pos][product] = new double[numWaysToMake[pos][product]];
                Arrays.fill(score[pos][product], Double.NEGATIVE_INFINITY);
                trace[pos][product] = new int[numWaysToMake[pos][product]][];
                Arrays.fill((Object[])trace[pos][product], new int[]{-1, -1});
            }
        }
        int posMax = length + leftWindow;
        for (pos = leftWindow; pos < posMax; ++pos) {
            int productMax = productSizes[pos];
            for (int product = 0; product < productMax; ++product) {
                double[] scorePos = score[pos][product];
                int[][] tracePos = trace[pos][product];
                if (pos == leftWindow) {
                    scorePos[0] = windowScore[pos][product];
                    continue;
                }
                int sharedProduct = product / tagNum[pos + rightWindow];
                int factor = productSizes[pos] / tagNum[pos + rightWindow];
                int maxTagNum = tagNum[pos - leftWindow - 1];
                for (int newTagNum = 0; newTagNum < maxTagNum; ++newTagNum) {
                    int predProduct = newTagNum * factor + sharedProduct;
                    double[] scorePosPrev = score[pos - 1][predProduct];
                    for (int k1 = 0; k1 < scorePosPrev.length; ++k1) {
                        double predScore = scorePosPrev[k1] + windowScore[pos][product];
                        if (!(predScore > scorePos[0])) continue;
                        int k2 = Arrays.binarySearch(scorePos, predScore);
                        k2 = k2 < 0 ? -k2 - 2 : k2 - 1;
                        System.arraycopy(scorePos, 1, scorePos, 0, k2);
                        System.arraycopy(tracePos, 1, tracePos, 0, k2);
                        scorePos[k2] = predScore;
                        tracePos[k2] = new int[]{predProduct, k1};
                    }
                }
            }
        }
        int[] whichDerivation = new int[k];
        int[] bestCurrentProducts = new int[k];
        double[] bestFinalScores = new double[k];
        Arrays.fill(bestFinalScores, Double.NEGATIVE_INFINITY);
        for (int product = 0; product < productSizes[padLength - 1]; ++product) {
            double[] scorePos = score[padLength - 1][product];
            for (int k1 = scorePos.length - 1; k1 >= 0 && scorePos[k1] > bestFinalScores[0]; --k1) {
                int k2 = Arrays.binarySearch(bestFinalScores, scorePos[k1]);
                k2 = k2 < 0 ? -k2 - 2 : k2 - 1;
                System.arraycopy(bestFinalScores, 1, bestFinalScores, 0, k2);
                System.arraycopy(whichDerivation, 1, whichDerivation, 0, k2);
                System.arraycopy(bestCurrentProducts, 1, bestCurrentProducts, 0, k2);
                bestCurrentProducts[k2] = product;
                whichDerivation[k2] = k1;
                bestFinalScores[k2] = scorePos[k1];
            }
        }
        ClassicCounter<int[]> kBestWithScores = new ClassicCounter<int[]>();
        for (int k1 = k - 1; k1 >= 0 && bestFinalScores[k1] > Double.NEGATIVE_INFINITY; --k1) {
            int lastProduct = bestCurrentProducts[k1];
            for (int last = padLength - 1; last >= length - 1 && last >= 0; --last) {
                tempTags[last] = tags[last][lastProduct % tagNum[last]];
                lastProduct /= tagNum[last];
            }
            for (int pos5 = leftWindow + length - 2; pos5 >= leftWindow; --pos5) {
                int bestNextProduct = bestCurrentProducts[k1];
                bestCurrentProducts[k1] = trace[pos5 + 1][bestNextProduct][whichDerivation[k1]][0];
                whichDerivation[k1] = trace[pos5 + 1][bestNextProduct][whichDerivation[k1]][1];
                tempTags[pos5 - leftWindow] = tags[pos5 - leftWindow][bestCurrentProducts[k1] / (productSizes[pos5] / tagNum[pos5 - leftWindow])];
            }
            kBestWithScores.setCount(Arrays.copyOf(tempTags, tempTags.length), bestFinalScores[k1]);
        }
        return kBestWithScores;
    }
}

