/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.sequences.IOBUtils;
import edu.stanford.nlp.stats.ClassicCounter;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class IOBUtilsTest
extends TestCase {
    private static final String[] words = new String[]{"Deportivo", "scored", "when", "AJ", "Auxerre", "playmaker", "Corentine", "Angelo", "Martins", "tripped", "on", "Brazilian-born", "Spanish", "Donato", "."};
    private static final String[] iob1 = new String[]{"I-ORG", "O", "O", "I-ORG", "I-ORG", "O", "I-PER", "I-PER", "I-PER", "O", "O", "I-MISC", "B-MISC", "I-PER", "O"};
    private static final String[] iob2 = new String[]{"B-ORG", "O", "O", "B-ORG", "I-ORG", "O", "B-PER", "I-PER", "I-PER", "O", "O", "B-MISC", "B-MISC", "B-PER", "O"};
    private static final String[] iobes = new String[]{"S-ORG", "O", "O", "B-ORG", "E-ORG", "O", "B-PER", "I-PER", "E-PER", "O", "O", "S-MISC", "S-MISC", "S-PER", "O"};
    private static final String[] io = new String[]{"I-ORG", "O", "O", "I-ORG", "I-ORG", "O", "I-PER", "I-PER", "I-PER", "O", "O", "I-MISC", "I-MISC", "I-PER", "O"};
    private static final String[] noprefix = new String[]{"ORG", "O", "O", "ORG", "ORG", "O", "PER", "PER", "PER", "O", "O", "MISC", "MISC", "PER", "O"};
    private static final String[] bilou = new String[]{"U-ORG", "O", "O", "B-ORG", "L-ORG", "O", "B-PER", "I-PER", "L-PER", "O", "O", "U-MISC", "U-MISC", "U-PER", "O"};
    private static final String BG = "O";
    private static final String[][] labelsIOB2 = new String[][]{{"O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "I-A", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "I-A", "I-A", "O", "O", "O", "O"}, {"O", "O", "O", "I-A", "I-A", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "I-A", "I-B", "O", "O", "O", "O"}, {"O", "O", "O", "O", "I-A", "B-A", "O", "O", "O", "O"}, {"O", "O", "O", "O", "O", "O", "O", "O", "O", "I-A"}};
    private static final String[][] labelsIOB = new String[][]{{"O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "B-A", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "B-A", "I-A", "O", "O", "O", "O"}, {"O", "O", "O", "B-A", "I-A", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "B-A", "B-A", "O", "O", "O", "O"}};
    private static final String[][] labelsIOE = new String[][]{{"O", "O", "O", "O", "I-A", "E-A", "I-A", "O", "O", "O"}, {"O", "O", "O", "O", "I-A", "L-A", "I-A", "O", "O", "O"}, {"O", "O", "O", "O", "I-A", "I-A", "I-A", "O", "O", "O"}};
    private static final String[][] labelsIO = new String[][]{{"O", "O", "O", "O", "O", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "I-A", "O", "O", "O", "O", "O"}, {"O", "O", "O", "O", "I-A", "I-A", "O", "O", "O", "O"}, {"O", "O", "O", "I-A", "I-A", "O", "O", "O", "O", "O"}, {"O", "O", "O", "I-A", "I-A", "I-A", "I-A", "O", "O", "O"}, {"O", "O", "O", "I-A", "I-B", "I-B", "I-A", "O", "O", "O"}, {"O", "O", "O", "I-A", "I-A", "I-B", "I-A", "O", "O", "O"}};
    private static final String[][] labelsIOBES = new String[][]{{"O", "O", "O", "B-A", "E-A", "O", "O", "O", "O", "O"}, {"O", "O", "O", "B-A", "L-A", "O", "O", "O", "O", "O"}, {"O", "O", "O", "B-A", "I-A", "I-A", "E-A", "O", "O", "O"}, {"O", "O", "O", "B-A", "I-A", "I-A", "L-A", "O", "O", "O"}, {"O", "O", "O", "B-A", "L-A", "U-A", "U-A", "O", "O", "O"}};

    public void testIOB1IOB2() {
        List<CoreLabel> testInput = IOBUtilsTest.loadCoreLabelList(words, iob1);
        IOBUtils.entitySubclassify(testInput, CoreAnnotations.AnswerAnnotation.class, BG, "iob2", true);
        IOBUtilsTest.checkAnswers(testInput, words, iob2);
    }

    public void testIOB1IOB1() {
        List<CoreLabel> testInput = IOBUtilsTest.loadCoreLabelList(words, iob1);
        IOBUtils.entitySubclassify(testInput, CoreAnnotations.AnswerAnnotation.class, BG, "iob1", true);
        IOBUtilsTest.checkAnswers(testInput, words, iob1);
    }

    public void testIOB2IOB1() {
        List<CoreLabel> testInput = IOBUtilsTest.loadCoreLabelList(words, iob2);
        IOBUtils.entitySubclassify(testInput, CoreAnnotations.AnswerAnnotation.class, BG, "iob1", true);
        IOBUtilsTest.checkAnswers(testInput, words, iob1);
    }

    public void testIOB2IOBES() {
        List<CoreLabel> testInput = IOBUtilsTest.loadCoreLabelList(words, iob2);
        IOBUtils.entitySubclassify(testInput, CoreAnnotations.AnswerAnnotation.class, BG, "iobes", true);
        IOBUtilsTest.checkAnswers(testInput, words, iobes);
    }

    public void testIOBESIOB1() {
        List<CoreLabel> testInput = IOBUtilsTest.loadCoreLabelList(words, iobes);
        IOBUtils.entitySubclassify(testInput, CoreAnnotations.AnswerAnnotation.class, BG, "iob1", true);
        IOBUtilsTest.checkAnswers(testInput, words, iob1);
    }

    public void testIOB1IO() {
        List<CoreLabel> testInput = IOBUtilsTest.loadCoreLabelList(words, iob1);
        IOBUtils.entitySubclassify(testInput, CoreAnnotations.AnswerAnnotation.class, BG, "io", true);
        IOBUtilsTest.checkAnswers(testInput, words, io);
    }

    public void testIOB1NoPrefix() {
        List<CoreLabel> testInput = IOBUtilsTest.loadCoreLabelList(words, iob1);
        IOBUtils.entitySubclassify(testInput, CoreAnnotations.AnswerAnnotation.class, BG, "noprefix", true);
        IOBUtilsTest.checkAnswers(testInput, words, noprefix);
    }

    public void testNoPrefixIO() {
        List<CoreLabel> testInput = IOBUtilsTest.loadCoreLabelList(words, noprefix);
        IOBUtils.entitySubclassify(testInput, CoreAnnotations.AnswerAnnotation.class, BG, "io", true);
        IOBUtilsTest.checkAnswers(testInput, words, io);
    }

    public void testBILOUIOBES() {
        List<CoreLabel> testInput = IOBUtilsTest.loadCoreLabelList(words, bilou);
        IOBUtils.entitySubclassify(testInput, CoreAnnotations.AnswerAnnotation.class, BG, "iobes", true);
        IOBUtilsTest.checkAnswers(testInput, words, iobes);
    }

    public void testIOB2BILOU() {
        List<CoreLabel> testInput = IOBUtilsTest.loadCoreLabelList(words, iob2);
        IOBUtils.entitySubclassify(testInput, CoreAnnotations.AnswerAnnotation.class, BG, "BILOU", true);
        IOBUtilsTest.checkAnswers(testInput, words, bilou);
    }

    private static List<CoreLabel> loadCoreLabelList(String[] words, String[] answers) {
        ArrayList<CoreLabel> testInput = new ArrayList<CoreLabel>();
        String[] fields = new String[]{"word", "answer"};
        String[] values = new String[2];
        IOBUtilsTest.assertEquals((int)words.length, (int)answers.length);
        for (int i = 0; i < words.length; ++i) {
            values[0] = words[i];
            values[1] = answers[i];
            CoreLabel c = new CoreLabel(fields, values);
            testInput.add(c);
        }
        return testInput;
    }

    private static void checkAnswers(List<CoreLabel> testInput, String[] words, String[] answers) {
        for (int i = 0; i < testInput.size(); ++i) {
            IOBUtilsTest.assertEquals((String)("Wrong for " + words[i]), (String)answers[i], (String)((String)testInput.get(i).get(CoreAnnotations.AnswerAnnotation.class)));
        }
    }

    private static void runIOBResultsTest(String[] gold, String[] guess, double tp, double fp, double fn) {
        List<CoreLabel> sentence = IOBUtilsTest.makeListCoreLabel(gold, guess);
        ClassicCounter<String> entityTP = new ClassicCounter<String>();
        ClassicCounter<String> entityFP = new ClassicCounter<String>();
        ClassicCounter<String> entityFN = new ClassicCounter<String>();
        IOBUtils.countEntityResults(sentence, entityTP, entityFP, entityFN, BG);
        IOBUtilsTest.assertEquals((String)"For true positives", (double)tp, (double)entityTP.totalCount(), (double)1.0E-4);
        IOBUtilsTest.assertEquals((String)"For false positives", (double)fp, (double)entityFP.totalCount(), (double)1.0E-4);
        IOBUtilsTest.assertEquals((String)"For false negatives", (double)fn, (double)entityFN.totalCount(), (double)1.0E-4);
    }

    private static List<CoreLabel> makeListCoreLabel(String[] gold, String[] guess) {
        IOBUtilsTest.assertEquals((String)"Cannot run test on lists of different length", (int)gold.length, (int)guess.length);
        ArrayList<CoreLabel> sentence = new ArrayList<CoreLabel>();
        for (int i = 0; i < gold.length; ++i) {
            CoreLabel word = new CoreLabel();
            word.set(CoreAnnotations.GoldAnswerAnnotation.class, gold[i]);
            word.set(CoreAnnotations.AnswerAnnotation.class, guess[i]);
            sentence.add(word);
        }
        return sentence;
    }

    public void testIOB2Results() {
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[0], labelsIOB2[0], 0.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[0], labelsIOB2[1], 0.0, 1.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[1], labelsIOB2[0], 0.0, 0.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[1], labelsIOB2[1], 1.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[0], labelsIOB2[2], 0.0, 1.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[2], labelsIOB2[0], 0.0, 0.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[1], labelsIOB2[2], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[2], labelsIOB2[1], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[2], labelsIOB2[2], 1.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[0], labelsIOB2[3], 0.0, 1.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[3], labelsIOB2[0], 0.0, 0.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[1], labelsIOB2[3], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[3], labelsIOB2[1], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[2], labelsIOB2[3], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[3], labelsIOB2[2], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[3], labelsIOB2[3], 1.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[0], labelsIOB2[4], 0.0, 2.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[4], labelsIOB2[0], 0.0, 0.0, 2.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[1], labelsIOB2[4], 1.0, 1.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[4], labelsIOB2[1], 1.0, 0.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[2], labelsIOB2[4], 0.0, 2.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[4], labelsIOB2[2], 0.0, 1.0, 2.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[3], labelsIOB2[4], 0.0, 2.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[4], labelsIOB2[3], 0.0, 1.0, 2.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[4], labelsIOB2[4], 2.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[0], labelsIOB2[5], 0.0, 2.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[5], labelsIOB2[0], 0.0, 0.0, 2.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[1], labelsIOB2[5], 1.0, 1.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[5], labelsIOB2[1], 1.0, 0.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[2], labelsIOB2[5], 0.0, 2.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[5], labelsIOB2[2], 0.0, 1.0, 2.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[3], labelsIOB2[5], 0.0, 2.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[5], labelsIOB2[3], 0.0, 1.0, 2.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[4], labelsIOB2[5], 1.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[5], labelsIOB2[4], 1.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[5], labelsIOB2[5], 2.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[0], labelsIOB2[6], 0.0, 1.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[6], labelsIOB2[0], 0.0, 0.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[1], labelsIOB2[6], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[6], labelsIOB2[1], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[2], labelsIOB2[6], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[6], labelsIOB2[2], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[3], labelsIOB2[6], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[6], labelsIOB2[3], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[4], labelsIOB2[6], 0.0, 1.0, 2.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[6], labelsIOB2[4], 0.0, 2.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[5], labelsIOB2[6], 0.0, 1.0, 2.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[6], labelsIOB2[5], 0.0, 2.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB2[6], labelsIOB2[6], 1.0, 0.0, 0.0);
    }

    public void testIOBResults() {
        IOBUtilsTest.runIOBResultsTest(labelsIOB[0], labelsIOB[0], 0.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[0], labelsIOB[1], 0.0, 1.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[1], labelsIOB[0], 0.0, 0.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[1], labelsIOB[1], 1.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[0], labelsIOB[2], 0.0, 1.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[2], labelsIOB[0], 0.0, 0.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[2], labelsIOB[2], 1.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[0], labelsIOB[3], 0.0, 1.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[3], labelsIOB[0], 0.0, 0.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[1], labelsIOB[3], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[3], labelsIOB[1], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[2], labelsIOB[3], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[3], labelsIOB[2], 0.0, 1.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[3], labelsIOB[3], 1.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[2], labelsIOB[4], 0.0, 2.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[4], labelsIOB[2], 0.0, 1.0, 2.0);
    }

    public void testIOEResults() {
        IOBUtilsTest.runIOBResultsTest(labelsIOE[0], labelsIOE[1], 2.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOE[0], labelsIOE[2], 0.0, 1.0, 2.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOE[2], labelsIOE[0], 0.0, 2.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOE[0], labelsIOB[2], 1.0, 0.0, 1.0);
    }

    public void testIOResults() {
        IOBUtilsTest.runIOBResultsTest(labelsIOB[2], labelsIO[2], 1.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOB[4], labelsIO[2], 0.0, 1.0, 2.0);
        IOBUtilsTest.runIOBResultsTest(labelsIO[2], labelsIOB[2], 1.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIO[2], labelsIOB[4], 0.0, 2.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIO[4], labelsIO[5], 0.0, 3.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIO[4], labelsIO[6], 0.0, 3.0, 1.0);
        IOBUtilsTest.runIOBResultsTest(labelsIO[5], labelsIO[6], 1.0, 2.0, 2.0);
    }

    public void testIOBESResults() {
        IOBUtilsTest.runIOBResultsTest(labelsIOBES[0], labelsIOBES[1], 1.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOBES[4], labelsIOBES[0], 1.0, 0.0, 2.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOBES[2], labelsIOBES[3], 1.0, 0.0, 0.0);
        IOBUtilsTest.runIOBResultsTest(labelsIOBES[2], labelsIOBES[4], 0.0, 3.0, 1.0);
    }
}

