/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon.pred;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.Ssurgeon;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonWordlist;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.pred.NodeTest;

public class WordlistTest
extends NodeTest {
    private TYPE type;
    private String resourceID;
    private String myID;

    public WordlistTest(String myID, String resourceID, String type, String matchName) {
        super(matchName);
        this.resourceID = resourceID;
        this.myID = myID;
        this.type = TYPE.valueOf(type);
    }

    @Override
    protected boolean evaluate(IndexedWord node) throws Exception {
        SsurgeonWordlist wl = Ssurgeon.inst().getResource(this.resourceID);
        if (wl == null) {
            throw new Exception("No wordlist resource with ID=" + this.resourceID);
        }
        if (this.type == TYPE.lemma) {
            return wl.contains(node.lemma().toLowerCase());
        }
        if (this.type == TYPE.current_lasttoken) {
            String[] tokens = node.originalText().split("\\s+");
            String lastCurrent = tokens[tokens.length - 1].toLowerCase();
            return wl.contains(lastCurrent);
        }
        if (this.type == TYPE.lemma_and_currlast) {
            String[] tokens = node.originalText().split("\\s+");
            String lastCurrent = tokens[tokens.length - 1].toLowerCase();
            return wl.contains(node.lemma().toLowerCase()) || wl.contains(lastCurrent);
        }
        if (this.type == TYPE.word) {
            return wl.contains(node.word());
        }
        if (this.type == TYPE.pos) {
            return wl.contains(node.tag());
        }
        return false;
    }

    @Override
    public String getDisplayName() {
        return "wordlist-test :type " + (Object)((Object)this.type) + " :resourceID " + this.resourceID;
    }

    @Override
    public String getID() {
        return this.myID;
    }

    public static enum TYPE {
        lemma,
        current_lasttoken,
        lemma_and_currlast,
        word,
        pos;

    }
}

