/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import java.io.StringWriter;

public class AddEdge
extends SsurgeonEdit {
    public static final String LABEL = "addEdge";
    protected String govName;
    protected String depName;
    protected GrammaticalRelation relation;
    protected double weight;

    public AddEdge(String govName, String depName, GrammaticalRelation relation) {
        this.govName = govName;
        this.depName = depName;
        this.relation = relation;
        this.weight = 0.0;
    }

    public AddEdge(String govName, String depName, GrammaticalRelation relation, double weight) {
        this(govName, depName, relation);
        this.weight = weight;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-gov");
        buf.write(" ");
        buf.write(this.govName);
        buf.write("\t");
        buf.write("-dep");
        buf.write(" ");
        buf.write(this.depName);
        buf.write("\t");
        buf.write("-reln");
        buf.write(" ");
        buf.write(this.relation.toString());
        buf.write("\t");
        buf.write("-weight");
        buf.write(" ");
        buf.write(String.valueOf(this.weight));
        return buf.toString();
    }

    public static AddEdge createEngAddEdge(String govName, String depName, String engRelnName) {
        GrammaticalRelation reln = EnglishGrammaticalRelations.valueOf(engRelnName);
        return new AddEdge(govName, depName, reln);
    }

    public static AddEdge createEngAddEdge(String govName, String depName, String engRelnName, double weight) {
        GrammaticalRelation reln = EnglishGrammaticalRelations.valueOf(engRelnName);
        return new AddEdge(govName, depName, reln, weight);
    }

    @Override
    public void evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        IndexedWord depNode;
        IndexedWord govNode = this.getNamedNode(this.govName, sm);
        SemanticGraphEdge existingEdge = sg.getEdge(govNode, depNode = this.getNamedNode(this.depName, sm), this.relation);
        if (existingEdge == null) {
            if (!sg.containsVertex(govNode)) {
                sg.addVertex(govNode);
            }
            if (!sg.containsVertex(depNode)) {
                sg.addVertex(depNode);
            }
            sg.addEdge(govNode, depNode, this.relation, this.weight, false);
        }
    }
}

