/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.patterns.PatternsAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.semgraph.semgrex.Alignment;
import edu.stanford.nlp.semgraph.semgrex.Env;
import edu.stanford.nlp.semgraph.semgrex.SemgrexBatchParser;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.Tree;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;

public class SemgrexPatternTest
extends TestCase {
    public void testPrettyPrint() {
        SemgrexPattern pat = SemgrexPattern.compile("({}=partnerOne [[<prep_to ({word:/married/} >nsubjpass {}=partnerTwo)] | [<nsubjpass ({word:married} >prep_to {}=partnerTwo)]]) @ ({} [[>/nn|appos/ {lemma:/wife|husband/} >poss ({}=txtPartner @ {}=partnerTwo)] | [<poss (({}=txtPartner @ {}=partnerTwo) >/appos|nn/ {lemma:/wife|husband/})]])");
        pat.prettyPrint();
    }

    public void testFind() throws Exception {
        SemanticGraph h = SemanticGraph.valueOf("[married/VBN nsubjpass>Hughes/NNP auxpass>was/VBD prep_to>Gracia/NNP]");
        SemanticGraph t = SemanticGraph.valueOf("[loved/VBD\nnsubj>Hughes/NNP\ndobj>[wife/NN poss>his/PRP$ appos>Gracia/NNP]\nconj_and>[obsessed/JJ\ncop>was/VBD\nadvmod>absolutely/RB\nprep_with>[Elicia/NN poss>his/PRP$ amod>little/JJ compound>daughter/NN]]]");
        String s = "(ROOT\n(S\n(NP (DT The) (NN chimney) (NNS sweeps))\n(VP (VBP do) (RB not)\n(VP (VB like)\n(S\n(VP (VBG working)\n(PP (IN on)\n(NP (DT an) (JJ empty) (NN stomach)))))))\n(. .)))";
        Tree tree = Tree.valueOf(s);
        SemanticGraph sg = SemanticGraphFactory.makeFromTree(tree, SemanticGraphFactory.Mode.COLLAPSED, GrammaticalStructure.Extras.MAXIMAL, null);
        SemgrexPattern pat = SemgrexPattern.compile("{}=gov ![>det {}] & > {word:/^(?!not).*$/}=dep");
        sg.prettyPrint();
        pat.prettyPrint();
        SemgrexMatcher mat = pat.matcher(sg);
        while (mat.find()) {
            String gov = mat.getNode("gov").word();
            String dep = mat.getNode("dep").word();
            System.out.println(dep + ' ' + gov);
        }
        SemgrexPattern pat2 = SemgrexPattern.compile("{} [[>/nn|appos/ ({lemma:/wife|husband|partner/} >/poss/ {}=txtPartner)] | [<poss ({}=txtPartner >/nn|appos/ {lemma:/wife|husband|partner/})]| [<nsubj ({$} >> ({word:/wife|husband|partner/} >poss {word:/his|her/} >/nn|appos/ {}))]]");
        SemgrexMatcher mat2 = pat2.matcher(t);
        while (mat2.find()) {
            String match = mat2.getMatch().word();
            System.out.println(match);
        }
        HashMap<IndexedWord, IndexedWord> map = new HashMap<IndexedWord, IndexedWord>();
        map.put(h.getNodeByWordPattern("Hughes"), t.getNodeByWordPattern("Hughes"));
        map.put(h.getNodeByWordPattern("Gracia"), t.getNodeByWordPattern("Gracia"));
        Alignment alignment = new Alignment(map, 0.0, "");
        SemgrexPattern fullPat = SemgrexPattern.compile("({}=partnerOne [[<prep_to ({word:married} >nsubjpass {}=partnerTwo)] | [<nsubjpass ({word:married} >prep_to {}=partnerTwo)]]) @ ({} [[>/nn|appos/ ({lemma:/wife|husband|partner/} >/poss/ {}=txtPartner)] | [<poss ({}=txtPartner >/nn|appos/ {lemma:/wife|husband|partner/})]| [<nsubj ({$} >> ({word:/wife|husband|partner/} >poss {word:/his|her/} >/nn|appos/ {}=txtPartner))]])");
        fullPat.prettyPrint();
        SemgrexMatcher fullMat = fullPat.matcher(h, alignment, t);
        if (fullMat.find()) {
            System.out.println("woo: " + fullMat.getMatch().word());
            System.out.println(fullMat.getNode("txtPartner"));
            System.out.println(fullMat.getNode("partnerOne"));
            System.out.println(fullMat.getNode("partnerTwo"));
        } else {
            System.out.println("boo");
        }
        SemgrexPattern pat3 = SemgrexPattern.compile("({word:LIKE}=parent >>/aux.*/ {word:/do/}=node)");
        System.out.println("pattern is ");
        pat3.prettyPrint();
        System.out.println("tree is ");
        sg.prettyPrint();
        SemgrexMatcher mat3 = pat3.matcher(sg, true);
        if (mat3.find()) {
            String parent = mat3.getNode("parent").word();
            String node = mat3.getNode("node").word();
            System.out.println("Result: parent is " + parent + " and node is " + node);
            Assert.assertEquals((Object)parent, (Object)"like");
            Assert.assertEquals((Object)node, (Object)"do");
        } else {
            Assert.fail();
        }
    }

    public void testMacro() throws IOException {
        boolean ignoreCase;
        SemanticGraph h = SemanticGraph.valueOf("[married/VBN nsubjpass>Hughes/NNP auxpass>was/VBD nmod:to>Gracia/NNP]");
        String macro = "macro WORD = married";
        String pattern = "({word:${WORD}}=parent >>nsubjpass {}=node)";
        List<SemgrexPattern> pats = SemgrexBatchParser.compileStream(new ByteArrayInputStream((macro + "\n" + pattern).getBytes(StandardCharsets.UTF_8)));
        SemgrexPattern pat3 = pats.get(0);
        SemgrexMatcher mat3 = pat3.matcher(h, ignoreCase = true);
        if (!mat3.find()) {
            throw new RuntimeException("failed!");
        }
        String parent = mat3.getNode("parent").word();
        String node = mat3.getNode("node").word();
        System.out.println("Result: parent is " + parent + " and node is " + node);
        Assert.assertEquals((Object)parent, (Object)"married");
        Assert.assertEquals((Object)node, (Object)"Hughes");
    }

    public void testEnv() throws IOException {
        SemanticGraph h = SemanticGraph.valueOf("[married/VBN nsubjpass>Hughes/NNP auxpass>was/VBD nmod:to>Gracia/NNP]");
        h.getFirstRoot().set(PatternsAnnotations.PatternLabel1.class, "YES");
        String macro = "macro WORD = married";
        Env env = new Env();
        env.bind("pattern1", PatternsAnnotations.PatternLabel1.class);
        String pattern = "({pattern1:YES}=parent >>nsubjpass {}=node)";
        List<SemgrexPattern> pats = SemgrexBatchParser.compileStream(new ByteArrayInputStream((macro + "\n" + pattern).getBytes(StandardCharsets.UTF_8)), env);
        SemgrexPattern pat3 = pats.get(0);
        boolean ignoreCase = true;
        SemgrexMatcher mat3 = pat3.matcher(h, ignoreCase);
        if (!mat3.find()) {
            throw new RuntimeException("failed!");
        }
        String parent = mat3.getNode("parent").word();
        String node = mat3.getNode("node").word();
        System.out.println("Result: parent is " + parent + " and node is " + node);
        Assert.assertEquals((Object)parent, (Object)"married");
        Assert.assertEquals((Object)node, (Object)"Hughes");
    }

    public void testSerialization() throws IOException, ClassNotFoundException {
        SemgrexPattern pat3 = SemgrexPattern.compile("({word:LIKE}=parent >>nn {word:/do/}=node)");
        File tempfile = File.createTempFile("temp", "file");
        tempfile.deleteOnExit();
        IOUtils.writeObjectToFile((Object)pat3, tempfile);
        SemgrexPattern pat4 = (SemgrexPattern)IOUtils.readObjectFromFile(tempfile);
        Assert.assertEquals((Object)pat3, (Object)pat4);
    }

    public void testSiblingPatterns() {
        SemanticGraph sg = SemanticGraph.valueOf("[loved/VBD-2\nnsubj>Hughes/NNP-1\ndobj>[wife/NN-4 nmod:poss>his/PRP$-3 appos>Gracia/NNP-5]\nconj:and>[obsessed/JJ-9\ncop>was/VBD-7\nadvmod>absolutely/RB-8\nnmod:with>[Elicia/NN-14 nmod:poss>his/PRP$-11 amod>little/JJ-12 compound>daughter/NN-13]]]");
        SemgrexPattern pat1 = SemgrexPattern.compile("{tag:NNP}=w1 . {tag:VBD}=w2");
        SemgrexMatcher matcher = pat1.matcher(sg);
        if (!matcher.find()) {
            throw new RuntimeException("failed!");
        }
        String w1 = matcher.getNode("w1").word();
        String w2 = matcher.getNode("w2").word();
        Assert.assertEquals((Object)"Hughes", (Object)w1);
        Assert.assertEquals((Object)"loved", (Object)w2);
        SemgrexPattern pat2 = SemgrexPattern.compile("{word:was}=w1 $+ {}=w2");
        matcher = pat2.matcher(sg);
        if (!matcher.find()) {
            throw new RuntimeException("failed!");
        }
        String w12 = matcher.getNode("w1").word();
        String w22 = matcher.getNode("w2").word();
        Assert.assertEquals((Object)"was", (Object)w12);
        Assert.assertEquals((Object)"absolutely", (Object)w22);
        SemgrexPattern pat3 = SemgrexPattern.compile("{word:absolutely}=w1 $- {}=w2");
        matcher = pat3.matcher(sg);
        if (!matcher.find()) {
            throw new RuntimeException("failed!");
        }
        String w13 = matcher.getNode("w1").word();
        String w23 = matcher.getNode("w2").word();
        Assert.assertEquals((Object)"absolutely", (Object)w13);
        Assert.assertEquals((Object)"was", (Object)w23);
        SemgrexPattern pat4 = SemgrexPattern.compile("{word:his}=w1 $++ {tag:NN}=w2");
        matcher = pat4.matcher(sg);
        if (!matcher.find()) {
            throw new RuntimeException("failed!");
        }
        String w14 = matcher.getNode("w1").word();
        String w24 = matcher.getNode("w2").word();
        Assert.assertEquals((Object)"his", (Object)w14);
        Assert.assertEquals((Object)"daughter", (Object)w24);
        SemgrexPattern pat6 = SemgrexPattern.compile("{word:daughter}=w1 $-- {tag:/PRP./}=w2");
        matcher = pat6.matcher(sg);
        if (!matcher.find()) {
            throw new RuntimeException("failed!");
        }
        String w15 = matcher.getNode("w1").word();
        String w25 = matcher.getNode("w2").word();
        Assert.assertEquals((Object)"daughter", (Object)w15);
        Assert.assertEquals((Object)"his", (Object)w25);
        SemgrexPattern pat5 = SemgrexPattern.compile("{word:his}=w1 $-- {}=w2");
        matcher = pat5.matcher(sg);
        if (matcher.find()) {
            throw new RuntimeException("failed!");
        }
        SemgrexPattern pat7 = SemgrexPattern.compile("{word:his}=w1 !$-- {}");
        matcher = pat7.matcher(sg);
        if (!matcher.find()) {
            throw new RuntimeException("failed!");
        }
        String w16 = matcher.getNode("w1").word();
        Assert.assertEquals((Object)"his", (Object)w16);
        SemgrexPattern pat8 = SemgrexPattern.compile("{word:his}=w1 !$++ {}");
        matcher = pat8.matcher(sg);
        if (matcher.find()) {
            throw new RuntimeException("failed!");
        }
    }
}

