/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.junit.Test;

public class SemgrexPatternITest
extends TestCase {
    @Test
    public void testNERStanfordDependencies() throws Exception {
        String sentence = "John lives in Washington.";
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit, pos, lemma, ner, parse");
        props.setProperty("parse.originalDependencies", "true");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        Annotation doc = new Annotation(sentence);
        pipeline.annotate(doc);
        CoreMap sent = (CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        SemanticGraph graph = (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class);
        graph.prettyPrint();
        String patStr = "({word:/lives/} >/prep_in/ {word:/\\QCalifornia\\E|\\QWashington\\E/} >nsubj {ner:PERSON})";
        SemgrexPattern pat = SemgrexPattern.compile(patStr);
        SemgrexMatcher mat = pat.matcher(graph, true);
        SemgrexPatternITest.assertTrue((boolean)mat.find());
    }

    @Test
    public void testNERUniversalDependencies() throws Exception {
        String sentence = "John lives in Washington.";
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit, pos, lemma, ner, parse");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        props.setProperty("parse.originalDependencies", "false");
        Annotation doc = new Annotation(sentence);
        pipeline.annotate(doc);
        CoreMap sent = (CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        SemanticGraph graph = (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class);
        graph.prettyPrint();
        String patStr = "({word:/lives/} >/nmod:in/ {word:/\\QCalifornia\\E|\\QWashington\\E/} >nsubj {ner:PERSON})";
        SemgrexPattern pat = SemgrexPattern.compile(patStr);
        SemgrexMatcher mat = pat.matcher(graph, true);
        SemgrexPatternITest.assertTrue((boolean)mat.find());
    }
}

