/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalRelations;
import edu.stanford.nlp.util.Generics;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import junit.framework.TestCase;

public class SemanticGraphTest
extends TestCase {
    private SemanticGraph graph;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() {
        Class<SemanticGraphTest> clazz = SemanticGraphTest.class;
        synchronized (SemanticGraphTest.class) {
            if (this.graph == null) {
                this.graph = SemanticGraphTest.makeGraph();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static SemanticGraph makeGraph() {
        Tree tree;
        try {
            tree = new PennTreeReader(new StringReader("(S1 (S (S (S (NP (DT The) (NN CD14) (NN LPS) (NN receptor)) (VP (VBZ is) (, ,) (ADVP (RB however)) (, ,) (ADVP (RB up)) (VP (VBN regulated) (PRN (-LRB- -LRB-) (FRAG (RB not) (ADJP (RB down) (VBN regulated))) (-RRB- -RRB-)) (PP (IN in) (NP (JJ tolerant) (NNS cells)))))) (, ,) (CC and) (S (NP (NN LPS)) (VP (MD can) (, ,) (PP (IN in) (NP (NN fact))) (, ,) (ADVP (RB still)) (VP (VB lead) (PP (TO to) (NP (NP (NN activation)) (PP (IN of) (NP (JJ tolerant) (NNS cells))))) (SBAR (IN as) (S (VP (VBN evidenced) (PP (IN by) (NP (NP (NN mobilization)) (PP (IN of) (NP (DT the) (NN transcription) (NN factor) (NP (NP (JJ nuclear) (NN factor) (NN kappa) (NN B)) (PRN (-LRB- -LRB-) (NP (NN NF-kappa) (NN B)) (-RRB- -RRB-)))))))))))))) (. .)))"), new LabeledScoredTreeFactory()).readTree();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return SemanticGraphFactory.makeFromTree(tree, SemanticGraphFactory.Mode.BASIC, GrammaticalStructure.Extras.MAXIMAL);
    }

    public void testShortestPath() {
        IndexedWord word1 = this.graph.getNodeByIndex(10);
        IndexedWord word2 = this.graph.getNodeByIndex(14);
        List<SemanticGraphEdge> edges = this.graph.getShortestUndirectedPathEdges(word1, word2);
        SemanticGraphTest.assertNotNull(edges);
        List<IndexedWord> nodes = this.graph.getShortestUndirectedPathNodes(word1, word2);
        SemanticGraphTest.assertNotNull(nodes);
        SemanticGraphTest.assertEquals((Object)word1, (Object)nodes.get(0));
        SemanticGraphTest.assertEquals((Object)word2, (Object)nodes.get(nodes.size() - 1));
        edges = this.graph.getShortestUndirectedPathEdges(word1, word1);
        SemanticGraphTest.assertNotNull(edges);
        SemanticGraphTest.assertEquals((int)0, (int)edges.size());
        nodes = this.graph.getShortestUndirectedPathNodes(word1, word1);
        SemanticGraphTest.assertNotNull(nodes);
        SemanticGraphTest.assertEquals((int)1, (int)nodes.size());
        SemanticGraphTest.assertEquals((Object)word1, (Object)nodes.get(0));
    }

    public void testGetCommonAncestor() {
        IndexedWord common = this.graph.getCommonAncestor(this.graph.getNodeByIndex(43), this.graph.getNodeByIndex(44));
        SemanticGraphTest.assertEquals((int)45, (int)common.index());
        common = this.graph.getCommonAncestor(this.graph.getNodeByIndex(41), this.graph.getNodeByIndex(39));
        SemanticGraphTest.assertEquals((int)41, (int)common.index());
        common = this.graph.getCommonAncestor(this.graph.getNodeByIndex(39), this.graph.getNodeByIndex(41));
        SemanticGraphTest.assertEquals((int)41, (int)common.index());
        common = this.graph.getCommonAncestor(this.graph.getNodeByIndex(40), this.graph.getNodeByIndex(42));
        SemanticGraphTest.assertEquals((int)41, (int)common.index());
        common = this.graph.getCommonAncestor(this.graph.getNodeByIndex(10), this.graph.getNodeByIndex(42));
        SemanticGraphTest.assertEquals(null, (Object)common);
        common = this.graph.getCommonAncestor(this.graph.getNodeByIndex(10), this.graph.getNodeByIndex(10));
        SemanticGraphTest.assertEquals((int)10, (int)common.index());
        common = this.graph.getCommonAncestor(this.graph.getNodeByIndex(40), this.graph.getNodeByIndex(40));
        SemanticGraphTest.assertEquals((int)40, (int)common.index());
        common = this.graph.getCommonAncestor(this.graph.getNodeByIndex(10), this.graph.getNodeByIndex(1));
        SemanticGraphTest.assertEquals((int)10, (int)common.index());
        common = this.graph.getCommonAncestor(this.graph.getNodeByIndex(1), this.graph.getNodeByIndex(10));
        SemanticGraphTest.assertEquals((int)10, (int)common.index());
    }

    public void testCommonAncestor() {
        SemanticGraphTest.assertEquals((int)1, (int)this.graph.commonAncestor(this.graph.getNodeByIndex(43), this.graph.getNodeByIndex(44)));
        SemanticGraphTest.assertEquals((int)1, (int)this.graph.commonAncestor(this.graph.getNodeByIndex(41), this.graph.getNodeByIndex(39)));
        SemanticGraphTest.assertEquals((int)1, (int)this.graph.commonAncestor(this.graph.getNodeByIndex(39), this.graph.getNodeByIndex(41)));
        SemanticGraphTest.assertEquals((int)2, (int)this.graph.commonAncestor(this.graph.getNodeByIndex(40), this.graph.getNodeByIndex(42)));
        SemanticGraphTest.assertEquals((int)2, (int)this.graph.commonAncestor(this.graph.getNodeByIndex(42), this.graph.getNodeByIndex(40)));
        SemanticGraphTest.assertEquals((int)-1, (int)this.graph.commonAncestor(this.graph.getNodeByIndex(10), this.graph.getNodeByIndex(42)));
        SemanticGraphTest.assertEquals((int)0, (int)this.graph.commonAncestor(this.graph.getNodeByIndex(10), this.graph.getNodeByIndex(10)));
        SemanticGraphTest.assertEquals((int)0, (int)this.graph.commonAncestor(this.graph.getNodeByIndex(40), this.graph.getNodeByIndex(40)));
        SemanticGraphTest.assertEquals((int)2, (int)this.graph.commonAncestor(this.graph.getNodeByIndex(10), this.graph.getNodeByIndex(1)));
        SemanticGraphTest.assertEquals((int)2, (int)this.graph.commonAncestor(this.graph.getNodeByIndex(1), this.graph.getNodeByIndex(10)));
    }

    public void testTopologicalSort() {
        SemanticGraph gr = SemanticGraph.valueOf("[ate subj>Bill dobj>[muffins compound>blueberry]]");
        SemanticGraphTest.verifyTopologicalSort(gr);
        List<IndexedWord> vertices = gr.vertexListSorted();
        gr.addEdge(vertices.get(1), vertices.get(2), UniversalEnglishGrammaticalRelations.DIRECT_OBJECT, 1.0, false);
        SemanticGraphTest.verifyTopologicalSort(gr);
        gr = SemanticGraph.valueOf("[ate subj>Bill dobj>[muffins compound>blueberry]]");
        vertices = gr.vertexListSorted();
        gr.addEdge(vertices.get(2), vertices.get(1), UniversalEnglishGrammaticalRelations.DIRECT_OBJECT, 1.0, false);
        SemanticGraphTest.verifyTopologicalSort(gr);
        gr = SemanticGraph.valueOf("[ate subj>Bill dobj>[muffins compound>blueberry]]");
        vertices = gr.vertexListSorted();
        gr.addEdge(vertices.get(1), vertices.get(3), UniversalEnglishGrammaticalRelations.DIRECT_OBJECT, 1.0, false);
        SemanticGraphTest.verifyTopologicalSort(gr);
        gr = SemanticGraph.valueOf("[ate subj>Bill dobj>[muffins compound>blueberry]]");
        vertices = gr.vertexListSorted();
        gr.addEdge(vertices.get(3), vertices.get(0), UniversalEnglishGrammaticalRelations.DIRECT_OBJECT, 1.0, false);
        try {
            SemanticGraphTest.verifyTopologicalSort(gr);
            throw new RuntimeException("Expected to fail");
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    private static void verifyTopologicalSort(SemanticGraph graph) {
        List<IndexedWord> sorted = graph.topologicalSort();
        Map<IndexedWord, Integer> indices = Generics.newHashMap();
        for (int index = 0; index < sorted.size(); ++index) {
            indices.put(sorted.get(index), index);
        }
        for (IndexedWord parent : graph.vertexSet()) {
            SemanticGraphTest.assertTrue((boolean)indices.containsKey(parent));
            int parentIndex = (Integer)indices.get(parent);
            for (IndexedWord child : graph.getChildren(parent)) {
                SemanticGraphTest.assertTrue((boolean)indices.containsKey(child));
                int childIndex = (Integer)indices.get(child);
                SemanticGraphTest.assertTrue((parentIndex < childIndex ? 1 : 0) != 0);
            }
        }
    }

    public void testGetPathToRoot() {
        SemanticGraphTest.verifyPath(this.graph.getPathToRoot(this.graph.getNodeByIndex(1)), 4, 10);
        SemanticGraphTest.verifyPath(this.graph.getPathToRoot(this.graph.getNodeByIndex(10)), new int[0]);
        SemanticGraphTest.verifyPath(this.graph.getPathToRoot(this.graph.getNodeByIndex(34)), 35, 28, 10);
    }

    private static void verifyPath(List<IndexedWord> path, int ... expected) {
        SemanticGraphTest.assertEquals((int)expected.length, (int)path.size());
        for (int i = 0; i < expected.length; ++i) {
            SemanticGraphTest.assertEquals((int)expected[i], (int)path.get(i).index());
        }
    }

    public void testGetSiblings() {
        SemanticGraphTest.verifySet(this.graph.getSiblings(this.graph.getNodeByIndex(43)), 42, 44, 48);
        SemanticGraphTest.verifySet(this.graph.getSiblings(this.graph.getNodeByIndex(10)), new int[0]);
        SemanticGraphTest.verifySet(this.graph.getSiblings(this.graph.getNodeByIndex(42)), 43, 44, 48);
    }

    private static void verifySet(Collection<IndexedWord> nodes, int ... expected) {
        TreeSet<Integer> results = Generics.newTreeSet();
        for (IndexedWord node : nodes) {
            results.add(node.index());
        }
        TreeSet<Integer> expectedIndices = Generics.newTreeSet();
        int[] nArray = expected;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer index = nArray[i];
            expectedIndices.add(index);
        }
        SemanticGraphTest.assertEquals(expectedIndices, results);
    }

    public void testIsAncestor() {
        SemanticGraphTest.assertEquals((int)1, (int)this.graph.isAncestor(this.graph.getNodeByIndex(42), this.graph.getNodeByIndex(45)));
        SemanticGraphTest.assertEquals((int)2, (int)this.graph.isAncestor(this.graph.getNodeByIndex(40), this.graph.getNodeByIndex(37)));
        SemanticGraphTest.assertEquals((int)-1, (int)this.graph.isAncestor(this.graph.getNodeByIndex(40), this.graph.getNodeByIndex(38)));
        SemanticGraphTest.assertEquals((int)-1, (int)this.graph.isAncestor(this.graph.getNodeByIndex(40), this.graph.getNodeByIndex(10)));
        SemanticGraphTest.assertEquals((int)-1, (int)this.graph.isAncestor(this.graph.getNodeByIndex(45), this.graph.getNodeByIndex(42)));
    }

    public void testHasChildren() {
        SemanticGraph gr = SemanticGraph.valueOf("[ate subj>Bill dobj>[muffins compound>blueberry]]");
        List<IndexedWord> vertices = gr.vertexListSorted();
        for (IndexedWord word : vertices) {
            if (word.word().equals("ate") || word.word().equals("muffins")) {
                SemanticGraphTest.assertTrue((boolean)gr.hasChildren(word));
                continue;
            }
            SemanticGraphTest.assertFalse((boolean)gr.hasChildren(word));
        }
    }
}

