/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.quoteattribution;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.classify.LinearClassifierFactory;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.RVFDatum;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.QuoteAttributionAnnotator;
import edu.stanford.nlp.quoteattribution.Sieves.Sieve;
import edu.stanford.nlp.quoteattribution.Sieves.training.SupervisedSieveTraining;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class ExtractQuotesClassifier {
    boolean verbose = true;
    private Classifier<String, String> quoteToMentionClassifier;

    public ExtractQuotesClassifier(GeneralDataset<String, String> trainingSet) {
        LinearClassifierFactory lcf = new LinearClassifierFactory();
        this.quoteToMentionClassifier = lcf.trainClassifier((GeneralDataset)trainingSet);
    }

    public ExtractQuotesClassifier(String modelPath) {
        try {
            ObjectInputStream si = IOUtils.readStreamFromString(modelPath);
            this.quoteToMentionClassifier = (Classifier)si.readObject();
            si.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public Classifier<String, String> getClassifier() {
        return this.quoteToMentionClassifier;
    }

    public void scoreBestMentionNew(SupervisedSieveTraining.FeaturesData fd, Annotation doc) {
        List quotes = (List)doc.get(CoreAnnotations.QuotationsAnnotation.class);
        for (int i = 0; i < quotes.size(); ++i) {
            CoreMap quote = (CoreMap)quotes.get(i);
            if (quote.get(QuoteAttributionAnnotator.MentionAnnotation.class) != null) continue;
            double maxConfidence = 0.0;
            int maxDataIdx = -1;
            int goldDataIdx = -1;
            Pair<Integer, Integer> dataRange = fd.mapQuoteToDataRange.get(i);
            if (dataRange == null) continue;
            for (int dataIdx = ((Integer)dataRange.first).intValue(); dataIdx <= (Integer)dataRange.second; ++dataIdx) {
                RVFDatum<String, String> datum = fd.dataset.getRVFDatum(dataIdx);
                double isMentionConfidence = this.quoteToMentionClassifier.scoresOf(datum).getCount("isMention");
                if (!(isMentionConfidence > maxConfidence)) continue;
                maxConfidence = isMentionConfidence;
                maxDataIdx = dataIdx;
            }
            if (maxDataIdx == -1) continue;
            Sieve.MentionData mentionData = fd.mapDatumToMention.get(maxDataIdx);
            if (mentionData.type.equals("animate noun")) continue;
            quote.set(QuoteAttributionAnnotator.MentionAnnotation.class, mentionData.text);
            quote.set(QuoteAttributionAnnotator.MentionBeginAnnotation.class, mentionData.begin);
            quote.set(QuoteAttributionAnnotator.MentionEndAnnotation.class, mentionData.end);
            quote.set(QuoteAttributionAnnotator.MentionTypeAnnotation.class, mentionData.type);
            quote.set(QuoteAttributionAnnotator.MentionSieveAnnotation.class, "supervised");
        }
    }
}

