/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.objectbank.IdentityFunction;
import edu.stanford.nlp.process.TransformXML;
import edu.stanford.nlp.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.function.Function;
import junit.framework.TestCase;

public class TransformXMLTest
extends TestCase {
    private String testCase = "<doc><el arg=\"funny&amp;'&gt;&quot;stuff\">yo! C&amp;C! </el></doc>";
    private String expectedAnswer = "<doc> <el arg=\"funny&amp;&apos;&gt;&quot;stuff\"> yo! C&amp;C! </el> </doc>";
    private String expectedAnswer2 = "<doc> <el arg=\"funny&amp;&apos;&gt;&quot;stuff\"> yo! C&amp;C!yo! C&amp;C! </el> </doc>";
    private Function<String, String> duplicate = in -> in + in;

    public void testTransformXML1() {
        TransformXML<String> tx = new TransformXML<String>();
        StringWriter sw = new StringWriter();
        tx.transformXML(StringUtils.EMPTY_STRING_ARRAY, new IdentityFunction(), (InputStream)new ByteArrayInputStream(this.testCase.getBytes()), sw);
        String answer = sw.toString().replaceAll("\\s+", " ").trim();
        TransformXMLTest.assertEquals((String)"Bad XML transform", (String)this.expectedAnswer, (String)answer);
        sw = new StringWriter();
        tx.transformXML(new String[]{"el"}, this.duplicate, (InputStream)new ByteArrayInputStream(this.testCase.getBytes()), sw);
        String answer2 = sw.toString().replaceAll("\\s+", " ").trim();
        TransformXMLTest.assertEquals((String)"Bad XML transform", (String)this.expectedAnswer2, (String)answer2);
    }
}

