/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class TokenizerAnnotatorITest
extends TestCase {
    private static final String spanishText = "Me voy a Madrid (ES).\n\"Me gusta\", lo dice.";
    private static List<String> spanishTokens = Arrays.asList("Me", "voy", "a", "Madrid", "=LRB=", "ES", "=RRB=", ".", "\"", "Me", "gusta", "\"", ",", "lo", "dice", ".");
    private static List<String> spanishTokens2 = Arrays.asList("Me", "voy", "a", "Madrid", "=LRB=", "ES", "=RRB=", ".", "*NL*", "\"", "Me", "gusta", "\"", ",", "lo", "dice", ".");

    public void testNotSpanish() {
        Annotation ann = new Annotation("Damelo");
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize");
        props.setProperty("tokenize.language", "english");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        pipeline.annotate(ann);
        TokenizerAnnotatorITest.assertEquals((int)1, (int)((List)ann.get(CoreAnnotations.TokensAnnotation.class)).size());
        TokenizerAnnotatorITest.assertEquals((String)"Damelo", (String)((CoreLabel)((List)ann.get(CoreAnnotations.TokensAnnotation.class)).get(0)).word());
    }

    public void testSpanishTokenizer() {
        int i;
        TokenizerAnnotator annotator = new TokenizerAnnotator(false, "es", null);
        Annotation annotation = new Annotation(spanishText);
        annotator.annotate(annotation);
        List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        TokenizerAnnotatorITest.assertEquals((int)spanishTokens.size(), (int)tokens.size());
        for (i = 0; i < tokens.size(); ++i) {
            TokenizerAnnotatorITest.assertEquals((String)spanishTokens.get(i), (String)((CoreLabel)tokens.get(i)).value());
        }
        annotator = new TokenizerAnnotator(false, "es", "tokenizeNLs,");
        annotation = new Annotation(spanishText);
        annotator.annotate(annotation);
        tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        TokenizerAnnotatorITest.assertEquals((int)spanishTokens2.size(), (int)tokens.size());
        for (i = 0; i < tokens.size(); ++i) {
            TokenizerAnnotatorITest.assertEquals((String)spanishTokens2.get(i), (String)((CoreLabel)tokens.get(i)).value());
        }
    }
}

