/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class TokenBeginEndAnnotationITest
extends TestCase {
    public String basicText = "Joe Smith went to Hawaii. His vacation lasted three weeks. He had a great time.";
    public String basicNewlineText = "\nJoe Smith went to Hawaii.\n\n\nHis vacation lasted three weeks.  He had a great time.\nHe plans to go again.";
    public String xmlDocPath = "/u/scr/nlp/data/stanford-corenlp-testing/test-docs/ENG_DF_001471_20160410_G00A00PY2.xml";
    public String xmlDocPipelineProps = "/u/scr/nlp/data/stanford-corenlp-testing/test-props/kbp_2016.properties";
    public StanfordCoreNLP pipeline;
    public StanfordCoreNLP xmlPipeline;

    public void setUp() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner");
        props.setProperty("tokenize.options", "tokenizeNLs,invertible,ptb3Escaping=true");
        this.pipeline = new StanfordCoreNLP(props);
        String xmlDocContents = IOUtils.stringFromFile(this.xmlDocPath);
        Properties pipelineProps = StringUtils.argsToProperties("-props", this.xmlDocPipelineProps);
        pipelineProps.setProperty("annotators", "tokenize,cleanxml,ssplit,pos,lemma,ner");
        this.xmlPipeline = new StanfordCoreNLP(pipelineProps);
    }

    public void checkSentenceTokenAlignmentCorrectness(Annotation annotation) {
        int i = 0;
        for (CoreLabel token : (List)annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            if (!token.isNewline().booleanValue()) {
                TokenBeginEndAnnotationITest.assertEquals((int)i, (int)((Integer)token.get(CoreAnnotations.TokenBeginAnnotation.class)));
                TokenBeginEndAnnotationITest.assertEquals((int)(i + 1), (int)((Integer)token.get(CoreAnnotations.TokenEndAnnotation.class)));
            }
            ++i;
        }
        for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
            List sentenceTokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            TokenBeginEndAnnotationITest.assertEquals(sentence.get(CoreAnnotations.TokenBeginAnnotation.class), ((CoreLabel)sentenceTokens.get(0)).get(CoreAnnotations.TokenBeginAnnotation.class));
            TokenBeginEndAnnotationITest.assertEquals((int)((Integer)sentence.get(CoreAnnotations.TokenEndAnnotation.class)), (int)((Integer)((CoreLabel)sentenceTokens.get(sentenceTokens.size() - 1)).get(CoreAnnotations.TokenBeginAnnotation.class) + 1));
        }
    }

    public void testBasicExample() {
        Annotation basicExample = new Annotation(this.basicText);
        this.pipeline.annotate(basicExample);
        this.checkSentenceTokenAlignmentCorrectness(basicExample);
        CoreMap sentenceOne = (CoreMap)((List)basicExample.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        TokenBeginEndAnnotationITest.assertEquals((int)0, (int)((Integer)sentenceOne.get(CoreAnnotations.TokenBeginAnnotation.class)));
        TokenBeginEndAnnotationITest.assertEquals((int)6, (int)((Integer)sentenceOne.get(CoreAnnotations.TokenEndAnnotation.class)));
        CoreMap sentenceTwo = (CoreMap)((List)basicExample.get(CoreAnnotations.SentencesAnnotation.class)).get(1);
        TokenBeginEndAnnotationITest.assertEquals((int)6, (int)((Integer)sentenceTwo.get(CoreAnnotations.TokenBeginAnnotation.class)));
        TokenBeginEndAnnotationITest.assertEquals((int)12, (int)((Integer)sentenceTwo.get(CoreAnnotations.TokenEndAnnotation.class)));
        CoreMap sentenceThree = (CoreMap)((List)basicExample.get(CoreAnnotations.SentencesAnnotation.class)).get(2);
        TokenBeginEndAnnotationITest.assertEquals((int)12, (int)((Integer)sentenceThree.get(CoreAnnotations.TokenBeginAnnotation.class)));
        TokenBeginEndAnnotationITest.assertEquals((int)18, (int)((Integer)sentenceThree.get(CoreAnnotations.TokenEndAnnotation.class)));
        CoreLabel tokenIndexFour = (CoreLabel)((List)basicExample.get(CoreAnnotations.TokensAnnotation.class)).get(4);
        TokenBeginEndAnnotationITest.assertEquals((String)"Hawaii", (String)tokenIndexFour.originalText());
        CoreLabel tokenIndexSeven = (CoreLabel)((List)basicExample.get(CoreAnnotations.TokensAnnotation.class)).get(7);
        TokenBeginEndAnnotationITest.assertEquals((String)"vacation", (String)tokenIndexSeven.originalText());
        CoreLabel tokenIndexFifteen = (CoreLabel)((List)basicExample.get(CoreAnnotations.TokensAnnotation.class)).get(15);
        TokenBeginEndAnnotationITest.assertEquals((String)"great", (String)tokenIndexFifteen.originalText());
    }

    public void testBasicNewlineExample() {
        Annotation basicNewlineExample = new Annotation(this.basicNewlineText);
        this.pipeline.annotate(basicNewlineExample);
        this.checkSentenceTokenAlignmentCorrectness(basicNewlineExample);
        CoreMap sentenceOne = (CoreMap)((List)basicNewlineExample.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        TokenBeginEndAnnotationITest.assertEquals((int)0, (int)((Integer)sentenceOne.get(CoreAnnotations.TokenBeginAnnotation.class)));
        TokenBeginEndAnnotationITest.assertEquals((int)6, (int)((Integer)sentenceOne.get(CoreAnnotations.TokenEndAnnotation.class)));
        CoreMap sentenceTwo = (CoreMap)((List)basicNewlineExample.get(CoreAnnotations.SentencesAnnotation.class)).get(1);
        TokenBeginEndAnnotationITest.assertEquals((int)6, (int)((Integer)sentenceTwo.get(CoreAnnotations.TokenBeginAnnotation.class)));
        TokenBeginEndAnnotationITest.assertEquals((int)12, (int)((Integer)sentenceTwo.get(CoreAnnotations.TokenEndAnnotation.class)));
        CoreMap sentenceThree = (CoreMap)((List)basicNewlineExample.get(CoreAnnotations.SentencesAnnotation.class)).get(2);
        TokenBeginEndAnnotationITest.assertEquals((int)12, (int)((Integer)sentenceThree.get(CoreAnnotations.TokenBeginAnnotation.class)));
        TokenBeginEndAnnotationITest.assertEquals((int)18, (int)((Integer)sentenceThree.get(CoreAnnotations.TokenEndAnnotation.class)));
        CoreMap sentenceFour = (CoreMap)((List)basicNewlineExample.get(CoreAnnotations.SentencesAnnotation.class)).get(3);
        TokenBeginEndAnnotationITest.assertEquals((int)18, (int)((Integer)sentenceFour.get(CoreAnnotations.TokenBeginAnnotation.class)));
        TokenBeginEndAnnotationITest.assertEquals((int)24, (int)((Integer)sentenceFour.get(CoreAnnotations.TokenEndAnnotation.class)));
        CoreLabel tokenIndexFour = (CoreLabel)((List)basicNewlineExample.get(CoreAnnotations.TokensAnnotation.class)).get(4);
        TokenBeginEndAnnotationITest.assertEquals((String)"Hawaii", (String)tokenIndexFour.originalText());
        CoreLabel tokenIndexSeven = (CoreLabel)((List)basicNewlineExample.get(CoreAnnotations.TokensAnnotation.class)).get(7);
        TokenBeginEndAnnotationITest.assertEquals((String)"vacation", (String)tokenIndexSeven.originalText());
        TokenBeginEndAnnotationITest.assertTrue((tokenIndexSeven.isNewline() == false ? 1 : 0) != 0);
        CoreLabel tokenIndexFifteen = (CoreLabel)((List)basicNewlineExample.get(CoreAnnotations.TokensAnnotation.class)).get(15);
        TokenBeginEndAnnotationITest.assertEquals((String)"great", (String)tokenIndexFifteen.originalText());
    }

    public void testXMLDoc() {
        Annotation xmlDocAnnotation = new Annotation(IOUtils.stringFromFile(this.xmlDocPath));
        this.xmlPipeline.annotate(xmlDocAnnotation);
        this.checkSentenceTokenAlignmentCorrectness(xmlDocAnnotation);
        System.err.println("finished...");
        CoreLabel tokenIndexOne = (CoreLabel)((List)xmlDocAnnotation.get(CoreAnnotations.TokensAnnotation.class)).get(1);
        TokenBeginEndAnnotationITest.assertEquals((String)"iPhone", (String)tokenIndexOne.originalText());
        CoreLabel tokenIndexFour = (CoreLabel)((List)xmlDocAnnotation.get(CoreAnnotations.TokensAnnotation.class)).get(4);
        TokenBeginEndAnnotationITest.assertEquals((String)"Have", (String)tokenIndexFour.originalText());
        TokenBeginEndAnnotationITest.assertTrue((tokenIndexFour.isNewline() == false ? 1 : 0) != 0);
        CoreLabel tokenIndexNinetySix = (CoreLabel)((List)xmlDocAnnotation.get(CoreAnnotations.TokensAnnotation.class)).get(96);
        TokenBeginEndAnnotationITest.assertEquals((String)"so", (String)tokenIndexNinetySix.originalText());
        CoreLabel tokenIndexTwoNinetyThree = (CoreLabel)((List)xmlDocAnnotation.get(CoreAnnotations.TokensAnnotation.class)).get(293);
        TokenBeginEndAnnotationITest.assertEquals((String)"them", (String)tokenIndexTwoNinetyThree.originalText());
        TokenBeginEndAnnotationITest.assertTrue((tokenIndexTwoNinetyThree.isNewline() == false ? 1 : 0) != 0);
        CoreLabel tokenIndexFiveFortyTwo = (CoreLabel)((List)xmlDocAnnotation.get(CoreAnnotations.TokensAnnotation.class)).get(542);
        TokenBeginEndAnnotationITest.assertEquals((String)"location", (String)tokenIndexFiveFortyTwo.originalText());
        CoreLabel tokenIndexFiveFiftyFour = (CoreLabel)((List)xmlDocAnnotation.get(CoreAnnotations.TokensAnnotation.class)).get(543);
        TokenBeginEndAnnotationITest.assertEquals((String)".", (String)tokenIndexFiveFiftyFour.originalText());
    }
}

