/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.common.ParserAnnotations;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.ParserAnnotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class ParserAnnotatorITest
extends TestCase {
    private static AnnotationPipeline pipeline = null;
    private static AnnotationPipeline noPOSPipeline = null;
    private static AnnotationPipeline noParserPipeline = null;
    private static AnnotationPipeline parserOnlyPipeline = null;
    private static ParserAnnotator parser = null;
    private static AnnotationPipeline timeoutPipeline = null;
    private static AnnotationPipeline threaded3TimeoutPipeline = null;
    private static AnnotationPipeline threaded4TimeoutPipeline = null;
    private static AnnotationPipeline threaded3Pipeline = null;
    private static AnnotationPipeline threaded4Pipeline = null;
    static final String TEXT = "I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  ";
    static final String[] ANSWER = new String[]{"(ROOT (S (NP (PRP I)) (VP (VBD saw) (S (NP (PRP him)) (VP (VBG ordering) (NP (PRP them)) (PP (TO to) (NP (NN saw)))))) (. .)))", "(ROOT (S (NP (NP (NNP Jack) (POS 's)) (NN father)) (VP (VBZ has) (RB n't) (VP (VBN played) (NP (NN golf)) (PP (IN since) (ADVP (NP (CD 20) (NNS years)) (RB ago))))) (. .)))", "(ROOT (S (NP (PRP I)) (VP (VBP 'm) (VP (VBG going) (PP (TO to) (NP (DT the) (NN bookstore))) (S (VP (TO to) (VP (VB return) (NP (NP (DT a) (NN book)) (SBAR (S (NP (NP (NNP Jack)) (CC and) (NP (PRP$ his) (NNS friends))) (VP (VBD bought) (NP (PRP me))))))))))) (. .)))"};
    static final String[] XPARSES = new String[]{"(X (XX I) (XX saw) (XX him) (XX ordering) (XX them) (XX to) (XX saw) (XX .))", "(X (XX Jack) (XX 's) (XX father) (XX has) (XX n't) (XX played) (XX golf) (XX since) (XX 20) (XX years) (XX ago) (XX .))", "(X (XX I) (XX 'm) (XX going) (XX to) (XX the) (XX bookstore) (XX to) (XX return) (XX a) (XX book) (XX Jack) (XX and) (XX his) (XX friends) (XX bought) (XX me) (XX .))"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Class<ParserAnnotatorITest> clazz = ParserAnnotatorITest.class;
        synchronized (ParserAnnotatorITest.class) {
            if (pipeline != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            parser = new ParserAnnotator(false, -1);
            pipeline = new AnnotationPipeline();
            pipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
            pipeline.addAnnotator(new WordsToSentencesAnnotator(false));
            pipeline.addAnnotator(new POSTaggerAnnotator(false));
            pipeline.addAnnotator(parser);
            noPOSPipeline = new AnnotationPipeline();
            noPOSPipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
            noPOSPipeline.addAnnotator(new WordsToSentencesAnnotator(false));
            noPOSPipeline.addAnnotator(parser);
            noParserPipeline = new AnnotationPipeline();
            noParserPipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
            noParserPipeline.addAnnotator(new WordsToSentencesAnnotator(false));
            parserOnlyPipeline = new AnnotationPipeline();
            parserOnlyPipeline.addAnnotator(parser);
            Properties props = new Properties();
            props.setProperty("parse.maxtime", "1");
            props.setProperty("annotators", "tokenize, ssplit, parse");
            timeoutPipeline = new StanfordCoreNLP(props);
            props = new Properties();
            props.setProperty("parse.maxtime", "1");
            props.setProperty("parse.nthreads", "3");
            props.setProperty("annotators", "tokenize, ssplit, parse");
            threaded3TimeoutPipeline = new StanfordCoreNLP(props);
            props.setProperty("parse.nthreads", "4");
            threaded4TimeoutPipeline = new StanfordCoreNLP(props);
            props.setProperty("parse.maxtime", "-1");
            threaded4Pipeline = new StanfordCoreNLP(props);
            props.setProperty("parse.nthreads", "3");
            threaded3Pipeline = new StanfordCoreNLP(props);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void testNoPOSParserAnnotator() throws Exception {
        Annotation document = new Annotation("John Bauer works at Stanford.");
        noPOSPipeline.annotate(document);
        ParserAnnotatorITest.assertEquals((int)1, (int)((List)document.get(CoreAnnotations.SentencesAnnotation.class)).size());
        CoreMap sentence = (CoreMap)((List)document.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        Tree parse = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
        ParserAnnotatorITest.assertEquals((String)"(ROOT (S (NP (NNP John) (NNP Bauer)) (VP (VBZ works) (PP (IN at) (NP (NNP Stanford)))) (. .)))", (String)parse.toString());
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        ArrayList<Label> leaves = parse.yield();
        ParserAnnotatorITest.assertEquals((int)6, (int)tokens.size());
        ParserAnnotatorITest.assertEquals((int)6, (int)leaves.size());
        String[] expectedTags = new String[]{"NNP", "NNP", "VBZ", "IN", "NNP", "."};
        for (int i = 0; i < tokens.size(); ++i) {
            ParserAnnotatorITest.assertEquals((String)expectedTags[i], (String)((CoreLabel)tokens.get(i)).tag());
            ParserAnnotatorITest.assertTrue((boolean)(leaves.get(i) instanceof CoreLabel));
            ParserAnnotatorITest.assertEquals((String)expectedTags[i], (String)((CoreLabel)leaves.get(i)).tag());
        }
    }

    public void testParserAnnotator() {
        Annotation document = new Annotation(TEXT);
        pipeline.annotate(document);
        int i = 0;
        for (CoreMap sentence : (List)document.get(CoreAnnotations.SentencesAnnotation.class)) {
            Tree parse = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
            ParserAnnotatorITest.assertEquals((String)parse.toString(), (String)ANSWER[i++]);
        }
    }

    public void testThreadedAnnotator() {
        Annotation document = new Annotation("I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  ");
        threaded4Pipeline.annotate(document);
        this.verifyAnswers(document, ANSWER);
        document = new Annotation("I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  ");
        threaded3Pipeline.annotate(document);
        this.verifyAnswers(document, ANSWER);
        document = new Annotation(TEXT);
        threaded4Pipeline.annotate(document);
        this.verifyAnswers(document, ANSWER);
    }

    public void testMaxLen() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit, parse");
        props.setProperty("parse.maxlen", "7");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        Annotation document = new Annotation(TEXT);
        pipeline.annotate(document);
        this.verifyAnswers(document, XPARSES);
        props.setProperty("parse.maxlen", "8");
        pipeline = new StanfordCoreNLP(props);
        document = new Annotation(TEXT);
        pipeline.annotate(document);
        ParserAnnotatorITest.assertEquals((String)ANSWER[0], (String)((Tree)((CoreMap)((List)document.get(CoreAnnotations.SentencesAnnotation.class)).get(0)).get(TreeCoreAnnotations.TreeAnnotation.class)).toString());
        ParserAnnotatorITest.assertEquals((String)XPARSES[1], (String)((Tree)((CoreMap)((List)document.get(CoreAnnotations.SentencesAnnotation.class)).get(1)).get(TreeCoreAnnotations.TreeAnnotation.class)).toString());
        ParserAnnotatorITest.assertEquals((String)XPARSES[2], (String)((Tree)((CoreMap)((List)document.get(CoreAnnotations.SentencesAnnotation.class)).get(2)).get(TreeCoreAnnotations.TreeAnnotation.class)).toString());
    }

    public void testConstraints() {
        String expectedResult = "(ROOT (S (NP (PRP$ My) (NN dog)) (ADVP (RB also)) (VP (VBZ likes) (S (VP (VBG eating) (NP (NN sausage))))) (. .)))";
        Annotation annotation = new Annotation("My dog also likes eating sausage.");
        noParserPipeline.annotate(annotation);
        CoreMap sentence = (CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        parserOnlyPipeline.annotate(annotation);
        ParserAnnotatorITest.assertEquals((String)expectedResult, (String)((Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class)).toString());
        ParserConstraint constraint = new ParserConstraint(0, 2, "SBAR|SBAR[^a-zA-Z].*");
        ArrayList<ParserConstraint> constraints = new ArrayList<ParserConstraint>();
        constraints.add(constraint);
        sentence.set(ParserAnnotations.ConstraintAnnotation.class, constraints);
        parserOnlyPipeline.annotate(annotation);
        String result = ((Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class)).toString();
        ParserAnnotatorITest.assertFalse((String)"Tree should not match the original tree any more", (boolean)expectedResult.equals(result));
        ParserAnnotatorITest.assertTrue((String)"Tree should be forced to contain SBAR", (result.indexOf("SBAR") >= 0 ? 1 : 0) != 0);
    }

    public void testTimeout() {
        Annotation document = new Annotation(TEXT);
        timeoutPipeline.annotate(document);
        this.verifyAnswers(document, XPARSES);
    }

    public void testThreadedTimeout() {
        for (int i = 0; i < 20; ++i) {
            Annotation document = new Annotation("I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  ");
            threaded3TimeoutPipeline.annotate(document);
            this.verifyAnswers(document, XPARSES);
            document = new Annotation("I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  I saw him ordering them to saw. Jack 's father has n't played\ngolf since 20 years ago . I 'm going to the\nbookstore to return a book Jack and his friends bought me .  ");
            threaded4TimeoutPipeline.annotate(document);
            this.verifyAnswers(document, XPARSES);
        }
    }

    private void assertParseOK(ParserAnnotator parser) {
        AnnotationPipeline pipeline = new AnnotationPipeline();
        pipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
        pipeline.addAnnotator(new WordsToSentencesAnnotator(false));
        pipeline.addAnnotator(parser);
        Annotation document = new Annotation("John Bauer works at Stanford.");
        pipeline.annotate(document);
        ParserAnnotatorITest.assertEquals((int)1, (int)((List)document.get(CoreAnnotations.SentencesAnnotation.class)).size());
        CoreMap sentence = (CoreMap)((List)document.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        Tree parse = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
        ParserAnnotatorITest.assertEquals((String)"(ROOT (S (NP (NNP John) (NNP Bauer)) (VP (VBZ works) (PP (IN at) (NP (NNP Stanford)))) (. .)))", (String)parse.toString());
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        ArrayList<Label> leaves = parse.yield();
        ParserAnnotatorITest.assertEquals((int)6, (int)tokens.size());
        ParserAnnotatorITest.assertEquals((int)6, (int)leaves.size());
        String[] expectedTags = new String[]{"NNP", "NNP", "VBZ", "IN", "NNP", "."};
        for (int i = 0; i < tokens.size(); ++i) {
            ParserAnnotatorITest.assertEquals((String)expectedTags[i], (String)((CoreLabel)tokens.get(i)).tag());
            ParserAnnotatorITest.assertTrue((boolean)(leaves.get(i) instanceof CoreLabel));
            ParserAnnotatorITest.assertEquals((String)expectedTags[i], (String)((CoreLabel)leaves.get(i)).tag());
        }
    }

    public void testAnnotatorConstructors() {
        this.assertParseOK(new ParserAnnotator(false, -1));
        this.assertParseOK(new ParserAnnotator(false, 100));
        Properties props = new Properties();
        props.setProperty("annotators", "parse");
        this.assertParseOK(new ParserAnnotator("parse", props));
    }

    public void verifyAnswers(Annotation document, String[] expected) {
        int i = 0;
        for (CoreMap sentence : (List)document.get(CoreAnnotations.SentencesAnnotation.class)) {
            Tree parse = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
            ParserAnnotatorITest.assertFalse((String)("Sentence " + i + " was null"), (parse == null ? 1 : 0) != 0);
            ParserAnnotatorITest.assertEquals((String)expected[i++ % expected.length], (String)parse.toString());
        }
    }
}

