/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.util.ArrayCoreMap;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class POSTaggerAnnotatorITest
extends TestCase {
    private static POSTaggerAnnotator tagger;
    private static final String[] testSentences;
    private static final String shortText;
    private static final String longText;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Class<POSTaggerAnnotatorITest> clazz = POSTaggerAnnotatorITest.class;
        synchronized (POSTaggerAnnotatorITest.class) {
            if (tagger == null) {
                tagger = new POSTaggerAnnotator(false);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static List<CoreLabel> makeSentence(String sentence) {
        String[] words = sentence.split(" ");
        return SentenceUtils.toCoreLabelList(words);
    }

    private static CoreMap makeSentenceCoreMap(String sentence) {
        List<CoreLabel> tokens = POSTaggerAnnotatorITest.makeSentence(sentence);
        ArrayCoreMap map = new ArrayCoreMap(1);
        map.set(CoreAnnotations.TokensAnnotation.class, tokens);
        return map;
    }

    private static void checkLabels(List<CoreLabel> sentence, String ... tags) {
        POSTaggerAnnotatorITest.assertEquals((int)tags.length, (int)sentence.size());
        for (int i = 0; i < tags.length; ++i) {
            POSTaggerAnnotatorITest.assertEquals((String)tags[i], (String)((String)sentence.get(i).get(CoreAnnotations.PartOfSpeechAnnotation.class)));
        }
    }

    private static void checkLabels(CoreMap sentence, String ... tags) {
        POSTaggerAnnotatorITest.checkLabels((List)sentence.get(CoreAnnotations.TokensAnnotation.class), tags);
    }

    public void testWordsPLAnnotation() {
        CoreMap sent = POSTaggerAnnotatorITest.makeSentenceCoreMap(testSentences[0]);
        ArrayList<CoreMap> sentences = new ArrayList<CoreMap>();
        sentences.add(sent);
        Annotation annotation = new Annotation(shortText);
        annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        tagger.annotate(annotation);
        POSTaggerAnnotatorITest.checkLabels(sent, "PRP$", "NN", "VBZ", "JJ", "CC", "JJ", ".");
    }

    public void testMultipleWordsPLAnnotation() {
        CoreMap firstLabels = POSTaggerAnnotatorITest.makeSentenceCoreMap(testSentences[0]);
        CoreMap secondLabels = POSTaggerAnnotatorITest.makeSentenceCoreMap(testSentences[1]);
        ArrayList<CoreMap> sentences = new ArrayList<CoreMap>();
        sentences.add(firstLabels);
        sentences.add(secondLabels);
        Annotation annotation = new Annotation(longText);
        annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        tagger.annotate(annotation);
        POSTaggerAnnotatorITest.checkLabels(firstLabels, "PRP$", "NN", "VBZ", "JJ", "CC", "JJ", ".");
        POSTaggerAnnotatorITest.checkLabels(secondLabels, "DT", "VBZ", "DT", "JJ", "NN", ".");
    }

    public void testSentencesAnnotation() {
        List<CoreLabel> labels = POSTaggerAnnotatorITest.makeSentence(testSentences[0]);
        ArrayCoreMap sentence = new ArrayCoreMap();
        sentence.set(CoreAnnotations.TokensAnnotation.class, labels);
        ArrayList<ArrayCoreMap> sentences = new ArrayList<ArrayCoreMap>();
        sentences.add(sentence);
        Annotation annotation = new Annotation(shortText);
        annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        tagger.annotate(annotation);
        POSTaggerAnnotatorITest.checkLabels(labels, "PRP$", "NN", "VBZ", "JJ", "CC", "JJ", ".");
    }

    public void testMultipleSentencesAnnotation() {
        List<CoreLabel> firstLabels = POSTaggerAnnotatorITest.makeSentence(testSentences[0]);
        List<CoreLabel> secondLabels = POSTaggerAnnotatorITest.makeSentence(testSentences[1]);
        ArrayCoreMap firstSentence = new ArrayCoreMap();
        firstSentence.set(CoreAnnotations.TokensAnnotation.class, firstLabels);
        ArrayCoreMap secondSentence = new ArrayCoreMap();
        secondSentence.set(CoreAnnotations.TokensAnnotation.class, secondLabels);
        ArrayList<ArrayCoreMap> sentences = new ArrayList<ArrayCoreMap>();
        sentences.add(firstSentence);
        sentences.add(secondSentence);
        Annotation annotation = new Annotation(longText);
        annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        tagger.annotate(annotation);
        POSTaggerAnnotatorITest.checkLabels(firstLabels, "PRP$", "NN", "VBZ", "JJ", "CC", "JJ", ".");
        POSTaggerAnnotatorITest.checkLabels(secondLabels, "DT", "VBZ", "DT", "JJ", "NN", ".");
    }

    private static Annotation makeAnnotation(String ... testText) {
        ArrayList<ArrayCoreMap> sentences = new ArrayList<ArrayCoreMap>();
        for (String text : testText) {
            List<CoreLabel> labels = POSTaggerAnnotatorITest.makeSentence(text);
            ArrayCoreMap sentence = new ArrayCoreMap();
            sentence.set(CoreAnnotations.TokensAnnotation.class, labels);
            sentences.add(sentence);
        }
        Annotation annotation = new Annotation(StringUtils.join(testText));
        annotation.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        return annotation;
    }

    public void testMulticoreAnnotation() {
        Properties props = new Properties();
        POSTaggerAnnotator localTagger = new POSTaggerAnnotator("pos", props);
        Annotation ann = POSTaggerAnnotatorITest.makeAnnotation(testSentences);
        localTagger.annotate(ann);
        Annotation shortAnn = POSTaggerAnnotatorITest.makeAnnotation(testSentences[0], testSentences[1]);
        localTagger.annotate(shortAnn);
        props.setProperty("nthreads", "4");
        localTagger = new POSTaggerAnnotator("pos", props);
        Annotation ann2 = POSTaggerAnnotatorITest.makeAnnotation(testSentences);
        localTagger.annotate(ann2);
        Annotation shortAnn2 = POSTaggerAnnotatorITest.makeAnnotation(testSentences[0], testSentences[1]);
        localTagger.annotate(shortAnn2);
        POSTaggerAnnotatorITest.assertEquals((Object)ann, (Object)ann2);
        POSTaggerAnnotatorITest.assertEquals((Object)shortAnn, (Object)shortAnn2);
        ((CoreLabel)((List)((CoreMap)((List)shortAnn.get(CoreAnnotations.SentencesAnnotation.class)).get(0)).get(CoreAnnotations.TokensAnnotation.class)).get(0)).set(CoreAnnotations.PartOfSpeechAnnotation.class, "foo");
        POSTaggerAnnotatorITest.assertFalse((boolean)shortAnn.equals(shortAnn2));
    }

    public void testEmptyAnnotation() {
        try {
            tagger.annotate(new Annotation(""));
        }
        catch (RuntimeException e) {
            return;
        }
        throw new RuntimeException("Never expected to get this far... the annotator should have thrown an exception by now");
    }

    static {
        testSentences = new String[]{"My dog is fluffy and white .", "This is a second sentence .", "This sentence is only used in the threaded test .", "The Flyers have had frequent defensive breakdowns in recent games .", "Every time they are about to reach .500 , they lose another game ."};
        shortText = testSentences[0];
        longText = testSentences[0] + '\n' + testSentences[1];
    }
}

