/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class NERConfidenceITest {
    @Test
    public void testDefaultPipeline() {
        String example = "ABCDEFG Smith lives on Krypton in June 2012.  Tom Johnson paid $500 for it.  Joe Smith was born in California.  He works for the EU.";
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner");
        props.setProperty("ner.combinationMode", "HIGH_RECALL");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        Annotation ann = new Annotation(example);
        pipeline.annotate(ann);
        System.err.println("Text: " + example);
        System.err.println("---");
        System.err.println("entities and confidences");
        List tokens = (List)ann.get(CoreAnnotations.TokensAnnotation.class);
        for (CoreLabel token : tokens) {
            System.err.println(token.word() + "\t" + token.ner() + "\t" + token.nerConfidence());
        }
        Assert.assertEquals((Object)"ABCDEFG", (Object)((CoreLabel)tokens.get(0)).word());
        Assert.assertEquals((Object)"PERSON", (Object)((CoreLabel)tokens.get(0)).ner());
        Assert.assertEquals((double)0.7986500069491159, (double)((CoreLabel)tokens.get(0)).nerConfidence().get("PERSON"), (double)0.001);
        Assert.assertEquals((Object)"Krypton", (Object)((CoreLabel)tokens.get(4)).word());
        Assert.assertEquals((Object)"LOCATION", (Object)((CoreLabel)tokens.get(4)).ner());
        Assert.assertEquals((double)0.6698305229562858, (double)((CoreLabel)tokens.get(4)).nerConfidence().get("LOCATION"), (double)0.001);
        Assert.assertEquals((Object)"2012", (Object)((CoreLabel)tokens.get(7)).word());
        Assert.assertEquals((Object)"DATE", (Object)((CoreLabel)tokens.get(7)).ner());
        Assert.assertEquals((double)0.9733532843140376, (double)((CoreLabel)tokens.get(7)).nerConfidence().get("DATE"), (double)0.001);
        Assert.assertEquals((Object)".", (Object)((CoreLabel)tokens.get(8)).word());
        Assert.assertEquals((Object)"O", (Object)((CoreLabel)tokens.get(8)).ner());
        Assert.assertEquals((double)0.9999996795616342, (double)((CoreLabel)tokens.get(8)).nerConfidence().get("O"), (double)0.001);
        Assert.assertEquals((Object)"Tom", (Object)((CoreLabel)tokens.get(9)).word());
        Assert.assertEquals((Object)"PERSON", (Object)((CoreLabel)tokens.get(9)).ner());
        Assert.assertEquals((double)0.9971518907102458, (double)((CoreLabel)tokens.get(9)).nerConfidence().get("PERSON"), (double)0.001);
        Assert.assertEquals((Object)"California", (Object)((CoreLabel)tokens.get(22)).word());
        Assert.assertEquals((Object)"STATE_OR_PROVINCE", (Object)((CoreLabel)tokens.get(22)).ner());
        Assert.assertEquals((double)0.9999100454498762, (double)((CoreLabel)tokens.get(22)).nerConfidence().get("LOCATION"), (double)0.001);
        List entityMentions = (List)ann.get(CoreAnnotations.MentionsAnnotation.class);
        Assert.assertEquals((Object)"ABCDEFG Smith", ((CoreMap)entityMentions.get(0)).get(CoreAnnotations.TextAnnotation.class));
        Assert.assertEquals((Object)"PERSON", ((CoreMap)entityMentions.get(0)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        Assert.assertEquals((double)0.7986500069491159, (double)((Double)((Map)((CoreMap)entityMentions.get(0)).get(CoreAnnotations.NamedEntityTagProbsAnnotation.class)).get("PERSON")), (double)0.001);
        Assert.assertEquals((Object)"Krypton", ((CoreMap)entityMentions.get(1)).get(CoreAnnotations.TextAnnotation.class));
        Assert.assertEquals((Object)"LOCATION", ((CoreMap)entityMentions.get(1)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        Assert.assertEquals((double)0.6698305229562858, (double)((Double)((Map)((CoreMap)entityMentions.get(1)).get(CoreAnnotations.NamedEntityTagProbsAnnotation.class)).get("LOCATION")), (double)0.001);
        Assert.assertEquals((Object)"June 2012", ((CoreMap)entityMentions.get(2)).get(CoreAnnotations.TextAnnotation.class));
        Assert.assertEquals((Object)"DATE", ((CoreMap)entityMentions.get(2)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        Assert.assertEquals((double)0.9733532843140376, (double)((Double)((Map)((CoreMap)entityMentions.get(2)).get(CoreAnnotations.NamedEntityTagProbsAnnotation.class)).get("DATE")), (double)0.001);
        Assert.assertEquals((Object)"Tom Johnson", ((CoreMap)entityMentions.get(3)).get(CoreAnnotations.TextAnnotation.class));
        Assert.assertEquals((Object)"PERSON", ((CoreMap)entityMentions.get(3)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        Assert.assertEquals((double)0.9971518907102458, (double)((Double)((Map)((CoreMap)entityMentions.get(3)).get(CoreAnnotations.NamedEntityTagProbsAnnotation.class)).get("PERSON")), (double)0.001);
        Assert.assertEquals((Object)"$500", ((CoreMap)entityMentions.get(4)).get(CoreAnnotations.TextAnnotation.class));
        Assert.assertEquals((Object)"MONEY", ((CoreMap)entityMentions.get(4)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        Assert.assertEquals((double)0.9978595519414504, (double)((Double)((Map)((CoreMap)entityMentions.get(4)).get(CoreAnnotations.NamedEntityTagProbsAnnotation.class)).get("MONEY")), (double)0.001);
        Assert.assertEquals((Object)"Joe Smith", ((CoreMap)entityMentions.get(5)).get(CoreAnnotations.TextAnnotation.class));
        Assert.assertEquals((Object)"PERSON", ((CoreMap)entityMentions.get(5)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        Assert.assertEquals((double)0.9998883592998197, (double)((Double)((Map)((CoreMap)entityMentions.get(5)).get(CoreAnnotations.NamedEntityTagProbsAnnotation.class)).get("PERSON")), (double)0.001);
        Assert.assertEquals((Object)"California", ((CoreMap)entityMentions.get(6)).get(CoreAnnotations.TextAnnotation.class));
        Assert.assertEquals((Object)"STATE_OR_PROVINCE", ((CoreMap)entityMentions.get(6)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        Assert.assertEquals((double)0.9999100454498762, (double)((Double)((Map)((CoreMap)entityMentions.get(6)).get(CoreAnnotations.NamedEntityTagProbsAnnotation.class)).get("LOCATION")), (double)0.001);
        Assert.assertEquals((Object)"EU", ((CoreMap)entityMentions.get(7)).get(CoreAnnotations.TextAnnotation.class));
        Assert.assertEquals((Object)"ORGANIZATION", ((CoreMap)entityMentions.get(7)).get(CoreAnnotations.NamedEntityTagAnnotation.class));
        Assert.assertEquals((double)0.7744041644052911, (double)((Double)((Map)((CoreMap)entityMentions.get(7)).get(CoreAnnotations.NamedEntityTagProbsAnnotation.class)).get("ORGANIZATION")), (double)0.001);
    }
}

