/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.DeterministicCorefAnnotator;
import edu.stanford.nlp.pipeline.MorphaAnnotator;
import edu.stanford.nlp.pipeline.NERCombinerAnnotator;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.ParserAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.util.CoreMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.junit.Assert;

public class DeterministicCorefAnnotatorITest
extends TestCase {
    private static AnnotationPipeline pipeline;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        Class<DeterministicCorefAnnotatorITest> clazz = DeterministicCorefAnnotatorITest.class;
        synchronized (DeterministicCorefAnnotatorITest.class) {
            pipeline = new AnnotationPipeline();
            pipeline.addAnnotator(new TokenizerAnnotator(false, "en"));
            pipeline.addAnnotator(new WordsToSentencesAnnotator(false));
            pipeline.addAnnotator(new POSTaggerAnnotator(false));
            pipeline.addAnnotator(new MorphaAnnotator(false));
            pipeline.addAnnotator(new NERCombinerAnnotator(false));
            pipeline.addAnnotator(new ParserAnnotator(false, -1));
            Properties corefProps = new Properties();
            corefProps.setProperty("dcoref.demonym", "edu/stanford/nlp/models/dcoref/demonyms.txt");
            corefProps.setProperty("dcoref.animate", "edu/stanford/nlp/models/dcoref/animate.unigrams.txt");
            corefProps.setProperty("dcoref.inanimate", "edu/stanford/nlp/models/dcoref/inanimate.unigrams.txt");
            pipeline.addAnnotator(new DeterministicCorefAnnotator(corefProps));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void testDeterministicCorefAnnotator() throws Exception {
        String text = "Dan Ramage is working for\nMicrosoft. He's in Seattle!\nAt least, he used to be.  Ed is not in Seattle.";
        Annotation document = new Annotation(text);
        pipeline.annotate(document);
        Map corefChains = (Map)document.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        Assert.assertNotNull((Object)corefChains);
        Iterator iterator = corefChains.keySet().iterator();
        while (iterator.hasNext()) {
            int chainID = (Integer)iterator.next();
            CorefChain c = (CorefChain)corefChains.get(chainID);
            for (CorefChain.CorefMention m : c.getMentionsInTextualOrder()) {
                Assert.assertEquals((long)m.corefClusterID, (long)chainID);
            }
        }
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        CoreLabel ramageToken = (CoreLabel)((List)((CoreMap)sentences.get(0)).get(CoreAnnotations.TokensAnnotation.class)).get(1);
        CoreLabel heToken = (CoreLabel)((List)((CoreMap)sentences.get(1)).get(CoreAnnotations.TokensAnnotation.class)).get(0);
        Integer ramageClusterId = (Integer)ramageToken.get(CorefCoreAnnotations.CorefClusterIdAnnotation.class);
        Assert.assertNotNull((Object)ramageClusterId);
        Assert.assertSame((Object)ramageClusterId, heToken.get(CorefCoreAnnotations.CorefClusterIdAnnotation.class));
    }

    public void testSameString() throws Exception {
        String text = "Your mom thinks she lives in Denver, but it's a big city.  She actually lives outside of Denver.";
        Annotation document = new Annotation(text);
        pipeline.annotate(document);
        Map chains = (Map)document.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        Assert.assertNotNull((Object)chains);
        Iterator iterator = chains.keySet().iterator();
        while (iterator.hasNext()) {
            int chainID = (Integer)iterator.next();
            CorefChain c = (CorefChain)chains.get(chainID);
            for (CorefChain.CorefMention m : c.getMentionsInTextualOrder()) {
                Assert.assertEquals((long)m.corefClusterID, (long)chainID);
            }
        }
        List sentences = (List)document.get(CoreAnnotations.SentencesAnnotation.class);
        CoreLabel yourMomsToken = (CoreLabel)((List)((CoreMap)sentences.get(0)).get(CoreAnnotations.TokensAnnotation.class)).get(1);
        CoreLabel sheToken1 = (CoreLabel)((List)((CoreMap)sentences.get(0)).get(CoreAnnotations.TokensAnnotation.class)).get(3);
        CoreLabel sheToken2 = (CoreLabel)((List)((CoreMap)sentences.get(1)).get(CoreAnnotations.TokensAnnotation.class)).get(0);
        CoreLabel denverToken1 = (CoreLabel)((List)((CoreMap)sentences.get(0)).get(CoreAnnotations.TokensAnnotation.class)).get(6);
        CoreLabel denverToken2 = (CoreLabel)((List)((CoreMap)sentences.get(1)).get(CoreAnnotations.TokensAnnotation.class)).get(5);
        Integer yourMomsClusterId = (Integer)yourMomsToken.get(CorefCoreAnnotations.CorefClusterIdAnnotation.class);
        Integer she1ClusterId = (Integer)sheToken1.get(CorefCoreAnnotations.CorefClusterIdAnnotation.class);
        Integer she2ClusterId = (Integer)sheToken2.get(CorefCoreAnnotations.CorefClusterIdAnnotation.class);
        Integer denver1ClusterId = (Integer)denverToken1.get(CorefCoreAnnotations.CorefClusterIdAnnotation.class);
        Integer denver2ClusterId = (Integer)denverToken2.get(CorefCoreAnnotations.CorefClusterIdAnnotation.class);
        Assert.assertNotNull((Object)yourMomsClusterId);
        Assert.assertNotNull((Object)she1ClusterId);
        Assert.assertNotNull((Object)she2ClusterId);
        Assert.assertNotNull((Object)denver1ClusterId);
        Assert.assertNotNull((Object)denver2ClusterId);
        Assert.assertSame((Object)yourMomsClusterId, (Object)she1ClusterId);
        Assert.assertSame((Object)yourMomsClusterId, (Object)she2ClusterId);
        Assert.assertSame((Object)denver1ClusterId, (Object)denver2ClusterId);
        Assert.assertNotSame((Object)yourMomsClusterId, (Object)denver1ClusterId);
    }

    public static void main(String[] args) throws Exception {
        DeterministicCorefAnnotatorITest itest = new DeterministicCorefAnnotatorITest();
        itest.testDeterministicCorefAnnotator();
    }
}

