/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;

public class CoreQuoteSanityITest
extends TestCase {
    public String testDocText = "In the summer Joe Smith decided to go on vacation.  He said \"I'm going to go to Hawaii.\"  That July, vacationer Joe went to Hawaii. ";
    public StanfordCoreNLP pipeline;

    public void setUp() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,depparse,coref,quote");
        this.pipeline = new StanfordCoreNLP(props);
    }

    public void testCoreQuote() {
        CoreDocument testDoc = new CoreDocument(this.testDocText);
        this.pipeline.annotate(testDoc);
        CoreMap canonicalEntityMention = (CoreMap)((List)testDoc.annotation().get(CoreAnnotations.MentionsAnnotation.class)).get(1);
        CoreQuoteSanityITest.assertEquals((String)"Joe Smith", (String)((String)canonicalEntityMention.get(CoreAnnotations.TextAnnotation.class)));
        CoreQuoteSanityITest.assertEquals((int)14, (int)((Integer)canonicalEntityMention.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)));
        CoreQuoteSanityITest.assertEquals((int)23, (int)((Integer)canonicalEntityMention.get(CoreAnnotations.CharacterOffsetEndAnnotation.class)));
        CoreQuoteSanityITest.assertEquals((Object)canonicalEntityMention, (Object)testDoc.quotes().get(0).canonicalSpeakerEntityMention().get().coreMap());
    }
}

