/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChineseSegmenterAnnotatorITest {
    private StanfordCoreNLP pipeline;

    @Before
    public void setUp() throws Exception {
        if (this.pipeline != null) {
            return;
        }
        Properties props = new Properties();
        props.setProperty("annotators", "cseg");
        props.setProperty("customAnnotatorClass.cseg", "edu.stanford.nlp.pipeline.ChineseSegmenterAnnotator");
        props.setProperty("cseg.model", "edu/stanford/nlp/models/segmenter/chinese/ctb.gz");
        props.setProperty("cseg.sighanCorporaDict", "edu/stanford/nlp/models/segmenter/chinese");
        props.setProperty("cseg.serDictionary", "edu/stanford/nlp/models/segmenter/chinese/dict-chris6.ser.gz");
        props.setProperty("cseg.sighanPostProcessing", "true");
        this.pipeline = new StanfordCoreNLP(props);
    }

    @Test
    public void testPipeline() {
        this.testOne("\u4f60\u9a6c\u4e0a\u56de\u6765\u5317\u4eac\u5417\uff1f", new String[]{"\u4f60", "\u9a6c\u4e0a", "\u56de\u6765", "\u5317\u4eac", "\u5417", "\uff1f"}, new int[]{0, 1, 3, 5, 7, 8}, new int[]{1, 3, 5, 7, 8, 9});
        this.testOne("<post id=\"something\" anything>\u8fd9\u662f\u4e00\u4e2a\u6d4b\u8bd5</post>", new String[]{"<post id=\"something\" anything>", "\u8fd9", "\u662f", "\u4e00", "\u4e2a", "\u6d4b\u8bd5", "</post>"}, new int[]{0, 30, 31, 32, 33, 34, 36}, new int[]{30, 31, 32, 33, 34, 36, 43});
        this.testOne("<post author=\"\u62d6\u57ae\u7f8e\u5e1d\" datetime=\"2011-12-06T22:36:00\" id=\"p3\">\n\u8fd9\u4e2a\u5f88\u96be\u56de\u7b54\u3002\n</post>", new String[]{"<post author=\"\u62d6\u57ae\u7f8e\u5e1d\" datetime=\"2011-12-06T22:36:00\" id=\"p3\">", "\u8fd9\u4e2a", "\u5f88", "\u96be", "\u56de\u7b54", "\u3002", "</post>"}, new int[]{0, 60, 62, 63, 64, 66, 68}, new int[]{59, 62, 63, 64, 66, 67, 75});
        this.testOne("\u8fd9\u91cc\u6709\u4e00\u4e2a\u56fe\u7247\u3002<img src=\"http://bbsfile.ifeng.com/bbsfile/images/smilies/default/lol.gif\"/>  \u5e0c\u671b\u4f60\u4eec\u90fd\u80fd\u770b\u770b\u3002", new String[]{"\u8fd9\u91cc", "\u6709", "\u4e00", "\u4e2a", "\u56fe\u7247", "\u3002", "<img src=\"http://bbsfile.ifeng.com/bbsfile/images/smilies/default/lol.gif\"/>", "\u5e0c\u671b", "\u4f60\u4eec", "\u90fd", "\u80fd", "\u770b\u770b", "\u3002"}, new int[]{0, 2, 3, 4, 5, 7, 8, 86, 88, 90, 91, 92, 94}, new int[]{2, 3, 4, 5, 7, 8, 84, 88, 90, 91, 92, 94, 95});
        this.testOne("\u4e70\u70b9\u5496\u5561\u63d0\u70b9\u7cbe\u795e\ud83d\ude0a", new String[]{"\u4e70", "\u70b9", "\u5496\u5561", "\u63d0", "\u70b9", "\u7cbe\u795e", "\ud83d\ude0a"}, new int[]{0, 1, 2, 4, 5, 6, 8}, new int[]{1, 2, 4, 5, 6, 8, 10});
    }

    private void testOne(String query, String[] expectedWords, int[] expectedBeginPositions, int[] expectedEndPositions) {
        Annotation annotation = new Annotation(query);
        this.pipeline.annotate(annotation);
        List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        Assert.assertEquals((long)expectedWords.length, (long)tokens.size());
        for (int i = 0; i < expectedWords.length; ++i) {
            Assert.assertEquals((Object)expectedWords[i], (Object)((CoreLabel)tokens.get(i)).word());
            Assert.assertEquals((long)expectedBeginPositions[i], (long)((CoreLabel)tokens.get(i)).beginPosition());
            Assert.assertEquals((long)expectedEndPositions[i], (long)((CoreLabel)tokens.get(i)).endPosition());
        }
    }
}

