/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.ReaderInputStream;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationCreator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

public abstract class AbstractInputStreamAnnotationCreator
implements AnnotationCreator {
    @Override
    public Annotation createFromText(String text) throws IOException {
        return this.create(new StringReader(text));
    }

    @Override
    public Annotation createFromFile(String filename) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(filename));
        Annotation anno = this.create(stream);
        IOUtils.closeIgnoringExceptions(stream);
        return anno;
    }

    @Override
    public Annotation createFromFile(File file) throws IOException {
        return this.createFromFile(file.getAbsolutePath());
    }

    @Override
    public Annotation create(InputStream stream) throws IOException {
        return this.create(stream, "UTF-8");
    }

    @Override
    public Annotation create(Reader reader) throws IOException {
        return this.create(new ReaderInputStream(reader));
    }
}

