/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.surface.PatternToken;
import edu.stanford.nlp.patterns.surface.SurfacePattern;
import edu.stanford.nlp.patterns.surface.SurfacePatternFactory;
import edu.stanford.nlp.patterns.surface.Token;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.concurrent.ConcurrentHashIndex;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SurfacePatternTest {
    @Before
    public void setUp() {
    }

    @Test
    public void testSubsumesArray() {
        Object[] arr1 = new String[]{",", "line", ",", "on"};
        Object[] arr2 = new String[]{",", "line", ","};
        Assert.assertTrue((boolean)SurfacePattern.subsumesArray(arr1, arr2));
        Assert.assertFalse((boolean)SurfacePattern.subsumesArray(arr2, null));
    }

    Token[] createContext(Map<Class, String> res) {
        Token[] toks = new Token[res.size()];
        int i = 0;
        for (Map.Entry<Class, String> en : res.entrySet()) {
            Token t = new Token(PatternFactory.PatternType.SURFACE);
            t.addORRestriction(en.getKey(), en.getValue());
            toks[i] = t;
            ++i;
        }
        return toks;
    }

    @Test
    public void testSimplerTokens() {
        HashMap<Class, String> prev = new HashMap<Class, String>(){
            {
                this.put(CoreAnnotations.LemmaAnnotation.class, "name");
                this.put(CoreAnnotations.LemmaAnnotation.class, "is");
            }
        };
        HashMap<Class, String> next = new HashMap<Class, String>(){
            {
                this.put(CoreAnnotations.LemmaAnnotation.class, "Duck");
            }
        };
        PatternToken token = new PatternToken("V", false, true, 2, null, false, false, null);
        SurfacePattern p = new SurfacePattern(this.createContext((Map<Class, String>)prev), token, this.createContext((Map<Class, String>)next), SurfacePatternFactory.Genre.PREVNEXT);
        HashMap<Class, String> prev2 = new HashMap<Class, String>(){
            {
                this.put(CoreAnnotations.LemmaAnnotation.class, "name");
                this.put(CoreAnnotations.LemmaAnnotation.class, "is");
            }
        };
        HashMap<Class, String> next2 = new HashMap<Class, String>(){
            {
                this.put(CoreAnnotations.LemmaAnnotation.class, "Duck");
            }
        };
        PatternToken token2 = new PatternToken("V", false, true, 2, null, false, false, null);
        SurfacePattern p2 = new SurfacePattern(this.createContext((Map<Class, String>)prev2), token2, this.createContext((Map<Class, String>)next2), SurfacePatternFactory.Genre.PREVNEXT);
        assert (p.compareTo(p2) == 0);
        ClassicCounter<SurfacePattern> pats = new ClassicCounter<SurfacePattern>();
        pats.setCount(p, 1.0);
        pats.setCount(p2, 1.0);
        assert (pats.size() == 1);
        System.out.println("pats size is " + pats.size());
        ConcurrentHashIndex<SurfacePattern> index = new ConcurrentHashIndex<SurfacePattern>();
        index.add(p);
        index.add(p2);
        assert (index.size() == 1);
    }
}

