/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce.demo;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParser;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.StringReader;
import java.util.List;

public class ShiftReduceDemo {
    private static Redwood.RedwoodChannels log = Redwood.channels(ShiftReduceDemo.class);

    public static void main(String[] args) {
        String modelPath = "edu/stanford/nlp/models/srparser/englishSR.ser.gz";
        String taggerPath = "edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger";
        int argIndex = 0;
        block8: while (argIndex < args.length) {
            switch (args[argIndex]) {
                case "-tagger": {
                    taggerPath = args[argIndex + 1];
                    argIndex += 2;
                    continue block8;
                }
                case "-model": {
                    modelPath = args[argIndex + 1];
                    argIndex += 2;
                    continue block8;
                }
            }
            throw new RuntimeException("Unknown argument " + args[argIndex]);
        }
        String text = "My dog likes to shake his stuffed chickadee toy.";
        MaxentTagger tagger = new MaxentTagger(taggerPath);
        ShiftReduceParser model = ShiftReduceParser.loadModel(modelPath, new String[0]);
        DocumentPreprocessor tokenizer = new DocumentPreprocessor(new StringReader(text));
        for (List<HasWord> sentence : tokenizer) {
            List<TaggedWord> tagged = tagger.tagSentence(sentence);
            Tree tree = model.apply(tagged);
            log.info(tree);
        }
    }
}

